/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.gui.CheckUpdateDialog;
import it.businesslogic.ireport.plugin.IReportPlugin;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URLConnection;

/**
 *
 * @author  Administrator
 */
public class UpgradeSearch implements Runnable {
    
    private CheckUpdateDialog win = null;
    public void run() {
        
        if (! IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.update.checking.enabled", "true").equals("true"))
        {
            // Update checking disabled...
            return;
        }
        
        try {
            java.net.URL url = new java.net.URL(IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.update.url"));
            
            URLConnection uConn = url.openConnection();
            //uConn.setReadTimeout(1000);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(uConn.getInputStream()));
            String version = null;
            while ((version = lnr.readLine() ) != null)
            {
                //IRPlugin.getMainInstance().getMainFrame().logOnConsole("v? " +version);
        
                if (version.startsWith("JasperIntelligence ")) {
                    String vnumber = version.substring( "JasperIntelligence ".length());
                    
                    //IRPlugin.getMainInstance().getMainFrame().logOnConsole("Remote: " + vnumber + " local: " + IRPlugin.CURRENT_VERSION+ " (" + vnumber.compareTo(IRPlugin.CURRENT_VERSION) + ")");
                    
                    if (vnumber.compareTo(IRPlugin.CURRENT_VERSION) > 0) {

                        final String fversion = "" + vnumber;
                        javax.swing.SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            javax.swing.JOptionPane.showMessageDialog(it.businesslogic.ireport.gui.MainFrame.getMainInstance(),
                                    IRPlugin.getFormattedString("messages.newversion", "{0} is available on http://www.jasperforge.org!", 
                                               new Object[] {fversion}));
                        }});
                    }
                }
            }
            
        } catch (Throwable ex) {
            ex.printStackTrace();
        }
        
        if (win != null)   win.setVisible(false);
    }

    public CheckUpdateDialog getWin() {
        return win;
    }

    public void setWin(CheckUpdateDialog win) {
        this.win = win;
    }
}

