/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war;

import com.meterware.httpunit.*;

import junit.framework.*;

/**
 * This Class is used for writing Testcases for testing a Jasper site. The test cases are for: -
 * Connecting the Jasper Server Startup Page - checking the Jasper Server Home Page - checking the
 * Jasper Server Admin Reports Page
 **/
public class HttpUnitAdminTest
	extends HttpUnitBaseTestCase {
	//private static String homePageUrl    = JasperServerConstants.instance().HOME_PAGE_URL;
	
	private static String  admHomePageUrl = JasperServerConstants.instance().BASE_URL +
	    "/jasperserver/flow.html%3f_flowId=repoAdminFlow";

	private static String adminPgText1 = "Repository Management";
	//private static String adminPgText2  = "NOTIFICATIONS"; // not used
	
	/**
	 * Constructor
	 *
	 * @param s
	 **/
	public HttpUnitAdminTest(String s) {
		super(s);
	}

	/**
	 * Checks through commonLoginFunction for logging in in at first time 
	 *
	 * @throws Exception if fails
	 **/
	public void setUp()
	  throws Exception {
			wResponse = commonLoginFunction(admHomePageUrl);
		}
	
	
	//****--------------------------------------------------------------------------*****/
	//*				HttpUnit test cases		                                            */
	//****--------------------------------------------------------------------------*****/	

	
	
	/**
	 * This test case method is for Admin Home Page of JS application This Page checks if the
	 * wResponse for this page is Null, and also checks for the text contents. On a proper
	 * response - test is success else - failure
	 *
	 * @throws Exception if fails
	 **/
	public void testAdmHomePage()
	  throws Exception {
		WebResponse adminPage = this.getWebConversation().getCurrentPage();
		assertNotNull("Admin Page Response is Null", adminPage);

		String opt = adminPage.getText();
		
		if ((opt == null) || (opt.trim().length() == 0)) {
			fail("Text not found in response");
		}

		assertTrue(opt.indexOf(adminPgText1) != -1);
	}
	
	
	//****--------------------------------------------------------------------------*****/
	//*				Base class method implementaion                                     */
	//****--------------------------------------------------------------------------*****/	

	
	
	/* (non-Javadoc)
	 * @see com.jaspersoft.jasperserver.war.HttpUnitBaseTestCase#getloginCredentials()
	 */
	protected String[] getloginCredentials() {
		return new String[] { JasperServerConstants.instance().USERNAME, 
				      JasperServerConstants.instance().PASSWORD };
	}
	
	//****--------------------------------------------------------------------------*****/
	//*				HttpUnit framework methods                                          */
	//****--------------------------------------------------------------------------*****/		
	
	
	/**
	 * the main method for calling all the test cases whichever is being added into the suite.
	 *
	 * @param args
	 **/
	public static void main(String[] args) {
		try {
			junit.textui.TestRunner.run(suite());
		} catch (Exception _ex) {
			_ex.printStackTrace();
		}
	}
	
	/**
	 * this method is for adding which all test case/s method/s need to be tested
	 *
	 * @return Test
	 *
	 * @throws Exception if fails
	 **/
	public static Test suite()
	  throws Exception {
		TestSuite suite = new TestSuite();

		TestCase test1 = new HttpUnitAdminTest("testAdmHomePage");
		suite.addTest(test1);

		return suite;
	}

}
