/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 * WSClientTest.java
 *
 * Created on December 16, 2006, 12:07 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.jaspersoft.jasperserver.ws.axis;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.war.JasperServerConstants;

import com.jaspersoft.jasperserver.irplugin.*;
import com.jaspersoft.jasperserver.irplugin.wsclient.*;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.axis.AxisFault;

/**
 *
 * @author gtoffoli
 */
public class WSClientTest extends TestCase {
	
	private static final String FIELD_USERNAME = "username";
	private static final String FIELD_PASSWORD = "password";
	private String targetUrl = JasperServerConstants.instance().WS_END_POINT_URL;
	private static String reportUnitURI = "/reports/samples/AllAccounts";
	
	private static String newRUURI = "/reports/testRU";
	
	private static String reportUnitDataSourceURI = "/datasources/JServerJdbcDS";
        
        private static WSClient wsclnt = null;
	private static JServer jserver = null;
	
	private boolean errorAllowed = false;
    
        /**
	 * default constructor
	 */
	public WSClientTest(String method) {
		super(method);
	}
	public WSClientTest(String method, boolean errorAllowed) {
		super(method);
		this.errorAllowed = errorAllowed;
	}

	/*
	 * setUp method
	 */
	public void setUp() throws Exception, AxisFault {

		if (wsclnt == null) {
			jserver = new JServer();
			jserver.setUrl(targetUrl);
			jserver.setUsername(JasperServerConstants.instance().USERNAME);
			jserver.setPassword(JasperServerConstants.instance().PASSWORD);
			wsclnt = new WSClient(jserver);
		}
	}

	/*
	 * tearDown method
	 */
	public void tearDown() {
		//Dont tear down the logged in client
	}

	/**
	 * main method defined here
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			junit.textui.TestRunner.run(suite());
		} catch (Exception _ex) {
			_ex.printStackTrace();
		}
	}

	/**
	 * this method is for adding which all test case/s method/s need to be
	 * @return Test
	 * @throws Exception if fails
	 */
	public static Test suite() throws Exception {

		TestSuite suite = new TestSuite();

		

		//TestCase test1 = new WSClientTest("testValidLogin");
  		TestCase testInValidLogin = new WSClientTest("testInValidLogin", true);
  		TestCase testListDataSources = new WSClientTest("testListDataSources");
  		TestCase testListRoot = new WSClientTest("testListRoot");
  		TestCase testGet = new WSClientTest("testGet");
  		TestCase testPut = new WSClientTest("testPut");
  		TestCase testDelete = new WSClientTest("testDelete");
  		TestCase testDeleteWithPossError = new WSClientTest("testDelete", false);
  		TestCase testTraffic = new WSClientTest("testTraffic");
  		TestCase testGetJasperPrint = new WSClientTest("testGetJasperPrint");
  		TestCase testGetJasperPrintWithParameters = new WSClientTest("testGetJasperPrintWithParameters");
  		TestCase testGetJasperPrintWithInvalidParameters = new WSClientTest("testGetJasperPrintWithInvalidParameters");
  		TestCase testGetHTML = new WSClientTest("testGetHTML");
  		TestCase testGetPDF = new WSClientTest("testGetPDF");
  		TestCase testPutRU = new WSClientTest("testPutRU");
  		TestCase testRunRU = new WSClientTest("testRunRU");
                
                
                suite.addTest(testListRoot);
  		suite.addTest(testListDataSources);
  		suite.addTest(testGet);
  		suite.addTest(testDeleteWithPossError);
  		
                suite.addTest(testPut);
  		suite.addTest(testDelete);
  		
                //suite.addTest(testTraffic);
  		suite.addTest(testGetJasperPrint);
  		
                suite.addTest(testGetJasperPrintWithParameters);
  		suite.addTest(testGetJasperPrintWithInvalidParameters);
  		
  		suite.addTest(testGetHTML);
                suite.addTest(testGetPDF);
  		
  		
  		suite.addTest(testPutRU);
                suite.addTest(testRunRU);
                
                suite.addTest(testInValidLogin);
                
  		
  		
		
                return suite;
        }
        
        /**
	 * testInValidLogin - method
	 */
	public void testInValidLogin() {

		System.out.println("testInValidLogin");
		try {
			JServer invalidJserver = new JServer();
			invalidJserver.setUrl(targetUrl);
			invalidJserver.setUsername(JasperServerConstants.instance().USERNAME2);
			invalidJserver.setPassword(JasperServerConstants.instance().BAD_PASSWORD2);
			WSClient invalidWsclnt = new WSClient(invalidJserver);
			invalidWsclnt.getVersion();
                        fail("No exception thrown at invalid Login");
                } catch (AxisFault ex)
                {
                    boolean isError = true;
                    if (errorAllowed) {
                            if (ex.getFaultString().indexOf("401") >= 0) {
                                    isError = false;
                            }
                    }
                    if (isError) {
                            fail("Unexpected error");
                    }
		} catch (Exception _ex) {
		    fail("Unexpected error");
		}
		
                System.out.println("end testInValidLogin");

	}

	/*
	 * testListDataSources method
	 * @param args
	 * @return
	 */
	public void testListDataSources() throws Exception {
		System.out.println("testListDataSources");

		List lst = wsclnt.listDatasources();
		assertNotNull("Datasources is null", lst);
		assertTrue("No datasources returned", lst.size()>0);
		System.out.println("end testListDataSources");

	}

	/*
	 * testListRoot method
	 * 
	 * @return
	 */
	public void testListRoot() throws Exception {
		System.out.println("testListRoot");
	
                
		ResourceDescriptor rd = new ResourceDescriptor();
                rd.setWsType( ResourceDescriptor.TYPE_FOLDER );
                rd.setUriString("/");
		List lst = wsclnt.list(rd);
		assertNotNull("Null LIST returned", lst);
		assertFalse("List has no valid content", lst.isEmpty());

		System.out.println("end testListRoot");
	}

	/*
	 * testGet method
	 * @param args
	 * @return
	 */
	public void testGet() throws Exception {
		System.out.println("testGet");

		String imgUri = "/images/JRLogo";
		ResourceDescriptor rdis = new ResourceDescriptor();
		rdis.setParentFolder("/images");
		rdis.setUriString(imgUri);
		
		ResourceDescriptor result = wsclnt.get(rdis, null);
		assertNotNull("Object returned is NULL", result);
		String imgName = result.getName();
		assertNotNull("Image Name is NULL", imgName);
		System.out.println("end testGet");

	}

	/*
	 * testPut method
	 * @param args
	 * @return
	 */
	public void testPut() throws Exception {
		System.out.println("testPut");

		ResourceDescriptor rdis = new ResourceDescriptor();
		rdis.setResourceType(ResourceDescriptor.TYPE_IMAGE);
		rdis.setName("testImageName");
		rdis.setLabel("TestImageLabel");
		rdis.setDescription("Test Image Description");
		rdis.setParentFolder("/images");
		
		rdis.setUriString(rdis.getParentFolder() + "/" + rdis.getName());
		rdis.setWsType(ResourceDescriptor.TYPE_IMAGE);
		File img = new File(getFileResourceURL("logo.jpg")); //Use ImageDir appropriately
		rdis.setHasData(true);
		rdis.setIsNew(true);
		ResourceDescriptor result = wsclnt.addOrModifyResource(rdis, img);
		assertNotNull("Upload image is Un-Successful", result);
		System.out.println("end testPut");

	}

	/*
	 * testDelete method
	 * @param args
	 * @return
	 */
	public void testDelete() {
		System.out.println("testDelete");

		try {
    	   String imgUri = "/images/testImageName";
           ResourceDescriptor rdes = new ResourceDescriptor();
           rdes.setUriString(imgUri);
           wsclnt.delete(rdes);
        } catch (Exception ex) {
        	boolean isError = true;
        	if (errorAllowed) {
        		if (ex.getMessage().indexOf("Resource not found") >= 0) {
        			isError = false;
        		}
        	}
        	if (isError) {
        		fail("Image Delete Unsuccessful");
        	}
        }
		System.out.println("end testDelete");
	}
	
	public void testTraffic() throws Exception {
		System.out.println("testTraffic");
		
		for (int i = 0; i < 10; i++) {
			testGet();
			Thread.sleep(1000);
			testPut();
			Thread.sleep(1000);
			testDelete();
			Thread.sleep(1000);
		}
		System.out.println("end testTraffic");
		
	}
	
	public void testGetJasperPrint() throws Exception {
		System.out.println("testGetJasperPrint");
		
       ResourceDescriptor rdes = new ResourceDescriptor();
       rdes.setUriString(reportUnitURI);
       JasperPrint js = wsclnt.runReport(rdes, new HashMap());
       assertNotNull("No JasperPrint", js);
	   System.out.println("end testGetJasperPrint");
	}
	
	
	
	public void testGetJasperPrintWithParameters() throws Exception {
		System.out.println("testGetJasperPrintWithParameters");
		
 	   String imgUri = "/reports/samples/SalesByMonth";
       ResourceDescriptor rdes = new ResourceDescriptor();
       rdes.setUriString(imgUri);
       
       Map args = new HashMap();
       args.put("TextInputControl", "5"); 
       
       
       JasperPrint js = wsclnt.runReport(rdes, args);
       
       assertNotNull("No JasperPrint", js);
	   System.out.println("end testGetJasperPrintWithParameters");
	}
	
	public void testGetJasperPrintWithInvalidParameters() throws Exception {
		System.out.println("testGetJasperPrintWithInvalidParameters");
		
 	   String imgUri = "/reports/samples/SalesByMonth";
       ResourceDescriptor rdes = new ResourceDescriptor();
       rdes.setUriString(imgUri);
       
       Map args = new HashMap();
       args.put("TextInputControl", "BAD-HAS TO BE A NUMBER"); 
       
       
       JasperPrint js = wsclnt.runReport(rdes, args);
       
       assertNotNull("No JasperPrint", js);
	   System.out.println("end testGetJasperPrintWithInvalidParameters");
	}
	
	
	
	
	
	
	
	
	/*
	 * Disabled: only gets one attachment back, when it is sent 4!
	 */
	public void testGetHTML() throws Exception {
		System.out.println("testGetHTML");
		
       ResourceDescriptor rdes = new ResourceDescriptor();
       rdes.setUriString(reportUnitURI);
       
       List args = new ArrayList();
   	   args.add(new Argument(Argument.RUN_OUTPUT_FORMAT, Argument.RUN_OUTPUT_FORMAT_HTML));
       
       Map attachments = wsclnt.runReport(rdes, new HashMap(), args);
       
       assertNotNull("No result", attachments);

       Iterator it = attachments.entrySet().iterator();
       List mimeTypes = new java.util.ArrayList();
       
       FileContent content = null;
       while (it.hasNext()) {
    	   Map.Entry entry = (Map.Entry) it.next();
    	   content = (FileContent)entry.getValue();
    	   System.out.println("Got " + entry.getKey() + " " + content.getName() +" " + content.getMimeType());
    	   mimeTypes.add(content.getMimeType());
    	}
       
	   
	if (attachments != null && !attachments.isEmpty()) {
		   content = (FileContent) attachments.get("report");
	}
	
        assertNotNull("No report", content);
        assertTrue("not html. was: " + content.getMimeType(), content.getMimeType().equals("text/html"));

	//content = (FileContent) attachments.get("px");
	//assertNotNull("No spacer image", content);
	//assertTrue("not gif. was: " + content.getMimeType(), content.getMimeType().equals("image/gif"));

	assertTrue("jpeg image not found: ", mimeTypes.contains("image/jpeg"));
	assertTrue("gif image not found: ", mimeTypes.contains("image/gif"));

	System.out.println("end testGetHTML");
	}
	
	public void testGetPDF() throws Exception {
		System.out.println("testGetPDF");
		
       ResourceDescriptor rdes = new ResourceDescriptor();
       rdes.setUriString(reportUnitURI);
       
       List args = new ArrayList();
   	   args.add(new Argument(Argument.RUN_OUTPUT_FORMAT, Argument.RUN_OUTPUT_FORMAT_PDF));

           
       Map attachments = wsclnt.runReport(rdes, new HashMap(), args);
       
       assertNotNull("No result", attachments);

	   FileContent content = null;
           // get the first key....
           
           
	   if (attachments != null && !attachments.isEmpty()) {
                   Object key = attachments.keySet().iterator().next();
                   content = (FileContent) attachments.get(key);
	   }
       assertNotNull("No PDF report", content);
       
       assertTrue("not pdf. was: " + content.getMimeType(), content.getMimeType().equals("application/pdf"));

	   System.out.println("end testGetPDF");
	}

	/** Fetches the URL of the Files in the classpath
	 * @return file path
	 **/
	private String getFileResourceURL(String name) {
		return  getClass().getClassLoader().getResource(name).getFile();
	}
 
	/*
	 * testPutRU method
	 * @param args
	 * @return
	 */
	public void testPutRU() throws Exception {
		System.out.println("testPutRU");
		
		// Delete if exists:
		
		try {
    	           ResourceDescriptor rdes = new ResourceDescriptor();
                   rdes.setUriString(newRUURI);
                   wsclnt.delete(rdes);
                } catch (Exception ex) {
        	}
        	
		

		ResourceDescriptor rd = new ResourceDescriptor();
     		File resourceFile = null;
        
        	rd.setWsType( ResourceDescriptor.TYPE_REPORTUNIT );
        	rd.setName("testRU");
		rd.setLabel("Test RU");
		rd.setDescription("Test RU Description");
		rd.setParentFolder("/reports");
        	
        	rd.setUriString(newRUURI);
        	rd.setIsNew( true );
        
        	ResourceDescriptor tmpDataSourceDescriptor = new ResourceDescriptor();
                tmpDataSourceDescriptor.setWsType( ResourceDescriptor.TYPE_DATASOURCE );
                tmpDataSourceDescriptor.setReferenceUri( reportUnitDataSourceURI );
                tmpDataSourceDescriptor.setIsReference(true);
             	rd.getChildren().add( tmpDataSourceDescriptor );
        	        	
        	ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
        	jrxmlDescriptor.setWsType( ResourceDescriptor.TYPE_JRXML );
        	jrxmlDescriptor.setName( "test_jrxml");
                jrxmlDescriptor.setLabel("Main jrxml"); //getResource().getDescriptor().getLabel()  );
                jrxmlDescriptor.setDescription("Main jrxml"); //getResource().getDescriptor().getDescription()
                jrxmlDescriptor.setIsNew(true);
                jrxmlDescriptor.setHasData(true);
                jrxmlDescriptor.setMainReport(true);
                
                resourceFile = new File( getFileResourceURL("test.jrxml"));
                System.out.println(resourceFile + " " + resourceFile.length());

                assertTrue("Test jrxml file not found!", resourceFile.exists());    

                rd.getChildren().add( jrxmlDescriptor );	
                
                ResourceDescriptor result = wsclnt.addOrModifyResource(rd, resourceFile);
        	assertNotNull("Object returned is NULL", result);
		String ruName = result.getName();
		assertNotNull("RU Name is NULL", ruName);
		System.out.println("end testPutRU");

        }   
        

        /*
	 * testRunRU method
	 * @param args
	 * @return
	 */
        public void testRunRU() throws Exception {
		System.out.println("testRunRU");
		
	       ResourceDescriptor rdes = new ResourceDescriptor();
	       rdes.setUriString(newRUURI);
	       
	       List args = new ArrayList();
	   	   args.add(new Argument(Argument.RUN_OUTPUT_FORMAT, Argument.RUN_OUTPUT_FORMAT_PDF));
	
	
	       HashMap params = new HashMap();
	       params.put("TEST_PARAMETER","test string");
	           
	       Map attachments = wsclnt.runReport(rdes, params, args);
	       
	       assertNotNull("No result", attachments);
	
	       FileContent content = null;
	           // get the first key....
	           
	           
	       if (attachments != null && !attachments.isEmpty()) {
	                   Object key = attachments.keySet().iterator().next();
	                   content = (FileContent) attachments.get(key);
	                   
	       }
	       assertNotNull("No PDF report", content);
	       assertTrue("not pdf. was: " + content.getMimeType(), content.getMimeType().equals("application/pdf"));

	       File f = new File(content.getName());
	       /*
               File f2 = new File("./test.pdf");
               if (f2.exists()) {
           	  f2.delete();
               }
               f.renameTo(f2);
               */ 
	       System.out.println("File created: " + f);
	       
	   System.out.println("end testRunRU");
	}
	
}
