/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.util.Properties;
import java.util.ArrayList;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;

import junit.framework.TestCase;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ContentResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;

public class ContentRepositoryTest extends TestCase
{
	private Properties jdbcProps;
	private RepositoryService repo;
	private ClassPathXmlApplicationContext appContext;

	protected void setUp() throws Exception {
		loadJdbcProps();
		appContext = new ClassPathXmlApplicationContext(
				new String[] {"hibernateConfig.xml", "viewService.xml"});

		repo = (RepositoryService) appContext.getBean("repoService");
	}
	
	protected void tearDown() {
		appContext.close();
	}

	protected Properties loadJdbcProps() throws IOException, FileNotFoundException {
		jdbcProps = new Properties();
		String jdbcPropFile = System.getProperty("test.hibernate.jdbc.properties");
		BufferedInputStream is = new BufferedInputStream(new FileInputStream(jdbcPropFile));
		jdbcProps.load(is);
		is.close();
		return jdbcProps;
	}

	public void testFolder()
	{
		Folder dsFolder = new FolderImpl();
		dsFolder.setName("ContentFiles");
		dsFolder.setLabel("Content files");
		dsFolder.setDescription("Content files generated by reports");
		repo.saveFolder(null, dsFolder);

		Folder newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("html");
		newFolder.setLabel("html");
		repo.saveFolder(null, newFolder);

		newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("pdf");
		newFolder.setLabel("pdf");
		repo.saveFolder(null, newFolder);

		newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("xls");
		newFolder.setLabel("xls");
		repo.saveFolder(null, newFolder);

	}

	public void testFiles()
	{
		ContentResource fileResource = new ContentResourceImpl();
		fileResource.setName("PdfTestFile");
		fileResource.setLabel("Pdf test file");
		fileResource.setParentFolder("/ContentFiles/pdf");
		InputStream file  = getClass().getResourceAsStream("/FontsReport.pdf");
		fileResource.readData(file);
		fileResource.setFileType(ContentResource.TYPE_PDF);
		repo.saveResource(null, fileResource);


		ContentResource htmlFile = new ContentResourceImpl();
		htmlFile.setName("HtmlTestFile");
		htmlFile.setLabel("HTML test file with images");
		htmlFile.setParentFolder("/ContentFiles/html");
		file  = getClass().getResourceAsStream("/FirstJasper.html");
		htmlFile.readData(file);
		htmlFile.setFileType(ContentResource.TYPE_HTML);

		ArrayList images = new ArrayList();

		ContentResource image = new ContentResourceImpl();
		image.setName("img_0_0_1");
		image.setLabel("img_0_0_1");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/img_0_0_1");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		image = new ContentResourceImpl();
		image.setName("img_0_7_125");
		image.setLabel("img_0_7_125");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/img_0_7_125");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		image = new ContentResourceImpl();
		image.setName("px");
		image.setLabel("px");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/px");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		htmlFile.setResources(images);
		repo.saveResource(null, htmlFile);


		htmlFile = new ContentResourceImpl();
		htmlFile.setName("Test");
		htmlFile.setLabel("HTML test file with one image");
		htmlFile.setParentFolder("/ContentFiles/html");
		file  = getClass().getResourceAsStream("/Test.html");
		htmlFile.readData(file);
		htmlFile.setFileType(ContentResource.TYPE_HTML);

		image = new ContentResourceImpl();
		image.setName("image0");
		image.setLabel("image0");
		file  = getClass().getResourceAsStream("/Test.html_files/image0");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images = new ArrayList();
		images.add(image);

		htmlFile.setResources(images);
		repo.saveResource(null, htmlFile);
	}
}
