/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Iterator;

import junit.framework.TestCase;
import junit.textui.TestRunner;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.RepoReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;


/**
 * @author swood
 * @version $Id: HibernateAccessTest.java 10075 2007-09-14 15:31:49Z tony $
 */
public class HibernateAccessTest extends TestCase {

	public static int NUMBER_OF_TEST_ROLES = 5;
	
	SessionFactory sf;
	RepoReportUnit testObject;
	RepoFolder root;
	HibernateTemplate template;
	private ClassPathXmlApplicationContext appContext;
	
	User testUser;
	List testRoles = new ArrayList(NUMBER_OF_TEST_ROLES);
	
	public HibernateAccessTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		TestRunner.run(HibernateAccessTest.class);
	}

	public void setUp() throws Exception {
		System.out.println("Setup HibernateAccessTest");
		appContext = new ClassPathXmlApplicationContext(
		        new String[] {"hibernateConfig.xml", "viewService.xml"});
		/*
		 * The TransactionSynchronizationManager work is only needed in tests to allow multiple
		 * Hibernate transactions to occur. Otherwise, each "template." call is a transaction.
		 * Lazy initialization of collections will not occur otherwise. In a web app, there is Spring
		 * configuration to do a transaction per web request - OpenSessionInViewFilter.
		 */
		sf = (SessionFactory) appContext.getBean("sessionFactory");
		Session s = sf.openSession();
		
		TransactionSynchronizationManager.bindResource(sf, new SessionHolder(s));
		
		HibernateDaoSupport dao = (HibernateDaoSupport) appContext.getBean("jasperServerDao");
		template = dao.getHibernateTemplate();

		// TODO: root folder needs to be here for other unit-test suites to run
		
		//we need to create a folder because RepoResource.parent is not nullable
		final RepoFolder root = new RepoFolder();
		root.setCreationDate(new Date());
		root.setName(Folder.SEPARATOR);
		root.setLabel("root");
		root.setDescription("Root of the folder hierarchy");
		root.setURI(Folder.SEPARATOR);
		root.setHidden(false);
		root.setParent(null);
		template.save(root);
	}
	
	public void tearDown() {
		try {
			System.out.println("Tear down HibernateAccessTest");
			/*
			 *  Leave entries in the database
			 *  		
					if (testObject != null) {
						final ReportUnit testObjectDel = testObject;
						template.delete(testObjectDel);
					}
					if (testUser != null) {
						final User testObjectDel = testUser;
						template.delete(testObjectDel);
					}
					if (testRoles != null) {
						Iterator it = testRoles.iterator();
						while (it.hasNext()) {
							final Role testObjectDel = (Role) it.next();
							template.delete(testObjectDel);
						}
					}					
			*/
			
			SessionHolder holder = (SessionHolder) TransactionSynchronizationManager.getResource(sf);
					
			Session s = holder.getSession();
					
			s.flush();
			TransactionSynchronizationManager.unbindResource(sf);
			SessionFactoryUtils.releaseSession(s, sf);
						
		} finally {
			appContext.close();
		}		
	}
	
	public void createReportUnit() throws Exception {
		System.out.println("createReportUnit");
		
		final RepoReportUnit testObjectImpl = new RepoReportUnit();
		testObjectImpl.setCreationDate(new Date());
		testObjectImpl.setDescription("Test");
		testObjectImpl.setName("Test");
		testObjectImpl.setLabel("Test");
		testObjectImpl.setParent(root);
		final Long testObjectId = (Long) template.save(testObjectImpl);
		assertNotNull("testObjectId", testObjectId);
		testObject = (RepoReportUnit) template.load(RepoReportUnit.class, testObjectId);
		assertNotNull("testObject", testObject);
	}
	
	public void createUser() throws Exception {
		System.out.println("createUser");
		final RepoUser testUserImpl = new RepoUser();
		testUserImpl.setUsername("TestUser");
		testUserImpl.setFullName("TestUser");
		testUserImpl.setPassword("newPassword");
		testUserImpl.setEnabled(true);
		testUserImpl.setExternallyDefined(false);
		
		Long testObjectId = (Long) template.save(testUserImpl);
		testUser = (User) template.load(RepoUser.class, testObjectId);
		assertNotNull("testUser null", testUser);
	}
	
	public void createRoles() throws Exception {
		System.out.println("testCreateRoles");
		for (int i = 0; i < NUMBER_OF_TEST_ROLES; i++) {
			final RepoRole testRoleImpl = new RepoRole();
			String roleName = "TestRole" + i;
			testRoleImpl.setRoleName(roleName);
			testRoleImpl.setExternallyDefined(false);
		
			template.saveOrUpdate(testRoleImpl);
			
			testRoles.add(testRoleImpl);
			
			testUser.addRole(testRoleImpl);
		}
		
		template.saveOrUpdate(testUser);
		assertTrue("testUser.getRoles().size()", testUser.getRoles().size() == NUMBER_OF_TEST_ROLES);
				
	}
	
	public void disabled_testReportUnitQuery() throws Exception {

		createReportUnit();

		System.out.println("testQuery");
		List result = template.find("from RepoReportUnit where name = ?", "Test");
		assertNotNull("result", result);
		assertTrue("result.size() == 1", result.size() == 1);
		testObject = (RepoReportUnit) result.get(0);
	}
	
	public void testUserQuery() throws Exception {
		createUser();
		createRoles();
		template.flush();

		System.out.println("testUserQuery");
		
		List result = template.find("from RepoUser where username = ?", "TestUser");

		assertNotNull("result", result);
		assertTrue("result.size() == 1",result.size() == 1);

		System.out.println("testUserQuery: found result OK");
		
		testUser = (User) result.get(0);
		assertNotNull("testUser", testUser);
		assertNotNull("testUser.getRoles()", testUser.getRoles());
		assertTrue("testUser.getRoles().size()", testUser.getRoles().size() == NUMBER_OF_TEST_ROLES);

		System.out.println("testUserQuery: roles OK");
	}
	
}
