/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

import junit.framework.TestCase;

/**
 * @author swood
 *
 */
public class ObjectPermissionTest extends TestCase {
	private ClassPathXmlApplicationContext appContext;
	ApplicationContext factory;

	HibernateRepositoryService repo;
	UserAuthorityService userAuthService;
	ObjectPermissionService objectPermissionService;

	boolean error = false;

	public void setUp() {
		System.out.println("Setup");
		appContext = new ClassPathXmlApplicationContext(
		        new String[] {"hibernateConfig.xml", "userAuthorityService.xml", "viewService.xml"});

		factory = (ApplicationContext) appContext;

		// Get the services

		userAuthService = (UserAuthorityService) factory.getBean("userAuthorityService");
		objectPermissionService = (ObjectPermissionService) factory.getBean("objectPermissionService");
		repo = (HibernateRepositoryService) factory.getBean("repoService");

	}
	public void tearDown() {
		System.out.println("Tear down");
		/*
		 *  Leave entries in the database
		 */
		
		appContext.close();
	}

	// Now let's do some object identity outside of security

	public void testObjectPermissionMaintenance() throws Exception {
		System.out.println("testObjectPermissionMaintenance");
		try {

			Folder root = repo.getFolder(null, Folder.SEPARATOR);

			// Set read and admin permissions on the root folder. Since it is the parent of everything,
			// these are the default permissions

			Role userRole = userAuthService.getRole(null, ObjectPermissionServiceTest.userRoleName);
			Role adminRole = userAuthService.getRole(null, ObjectPermissionServiceTest.administratorRoleName);
			createObjectPermission(root, adminRole, SimpleAclEntry.ADMINISTRATION);
		} catch (Exception e) {
			error = true;
			throw e;
		}
	}

	private ObjectPermission createObjectPermission(InternalURI target, Role role, int permissionMask) {
		ObjectPermission permission = objectPermissionService.newObjectPermission(null);
		permission.setURI(target.getURI());
		permission.setPermissionRecipient(role);
		permission.setPermissionMask(permissionMask);
		objectPermissionService.putObjectPermission(null, permission);
		return permission;
	}
}
