/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.util.List;
import java.util.Iterator;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

import junit.framework.TestCase;

/**
 * @author sbirney
 *
 */
public class ProfileAttributeTest extends TestCase {

    ClassPathXmlApplicationContext appContext;
    ApplicationContext factory;

    HibernateRepositoryService repo;
    UserAuthorityService userAuthService;
    ProfileAttributeService profileAttributeService;

    boolean error = false;

    public void setUp() {
	System.out.println("Setup");
	appContext = 
	    new ClassPathXmlApplicationContext(new String[] {"hibernateConfig.xml", 
							     "userAuthorityService.xml", 
							     "viewService.xml"});
	factory = (ApplicationContext) appContext;

	// Get the services
	userAuthService = 
	    (UserAuthorityService) factory.getBean("userAuthorityService");
	profileAttributeService = 
	    (ProfileAttributeService) factory.getBean("profileAttributeService");
	repo = (HibernateRepositoryService) factory.getBean("repoService");
    }

    public void tearDown() {
	System.out.println("Tear down");
	/*
	 *  Leave entries in the database
	 */
		
	// get rid of repository objects we don't want in the sample data
	
	userAuthService.deleteUser(null, "California_User");
	
	appContext.close();
    }

    /* from ObjectPermissionServiceTest */
    private Role getOrCreateRole(String roleName) {
	Role r = userAuthService.getRole(null, roleName);
	if (r == null) {
	    r = userAuthService.newRole(null);
	    r.setRoleName(roleName);
	    r.setExternallyDefined(false);
	    userAuthService.putRole(null, r);
	}
	return r;
    }

    /* from ObjectPermissionServiceTest */
    private User findOrCreateUser(String username) {
	User workingUser = userAuthService.getUser(null, username);
	if (workingUser == null) {
	    workingUser = userAuthService.newUser(null);
	    workingUser.setUsername(username);
	    workingUser.setPassword(username);
	    workingUser.setFullName(username + " user");
	    workingUser.setEnabled(true);
            
	    userAuthService.putUser(null, workingUser);
	}
	
	return workingUser;
    }

    public void testProfileAttributeService() {
	User caluser = findOrCreateUser("California_User");
	ProfileAttribute attr = createTestAttr( caluser, "State", "CA" );
	profileAttributeService.putProfileAttribute( null, attr );
	attr = createTestAttr( caluser, "Cities", "San Francisco, Oakland, San Jose" );
	profileAttributeService.putProfileAttribute( null, attr );
	List attrList = 
	    profileAttributeService.getProfileAttributesForPrincipal( null,
								      caluser );

	assertTrue( "ProfileAttribute list was empty", attrList.size() > 0 );
	for (Iterator it = attrList.iterator(); !attrList.isEmpty() && it.hasNext();) {
	    ProfileAttribute elem = (ProfileAttribute) it.next();
	    if ("State".equals(elem.getAttrName())) {
		assertTrue( "Test attribute did not match expected value", 
			    "CA".equals(elem.getAttrValue()) );
	    }
	}
    }

    private ProfileAttribute createTestAttr(Object principal,
					    String name,
					    String value) {
	ProfileAttribute attr = profileAttributeService.newProfileAttribute( null );
	attr.setPrincipal( principal );
	attr.setAttrName( name );
	attr.setAttrValue( value );
	return attr;
    }

}
