/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.util.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import junit.framework.TestCase;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.ParametersImpl;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: BaseExportTestCase.java 8408 2007-05-29 23:29:12Z melih $
 */
public abstract class BaseExportTestCase extends TestCase {

	protected static final String EXPORT_BASE_DIR = "target";

	protected static final String EXPORT_COMMAND_BEAN_NAME = "exportCommandBean";
	protected static final String IMPORT_COMMAND_BEAN_NAME = "importCommandBean";
	
	protected static final String PARAM_EXPORT_DIR = "output-dir";
	protected static final String PARAM_EXPORT_URIS = "uris";
	protected static final String PARAM_EXPORT_REPORT_JOB_URIS = "report-jobs";
	protected static final String PARAM_EXPORT_USERS = "users";
	protected static final String PARAM_EXPORT_ROLES = "roles";
	
	protected static final String PARAM_IMPORT_DIR = "input-dir";
	protected static final String PARAM_IMPORT_PREPEND_PATH = "prepend-path";
	
	private static final String FILE_SEPARATOR = System.getProperty("file.separator");
	private static final Random random = new Random(System.currentTimeMillis());

	private final String[] springConfigResources;

	private ConfigurableApplicationContext applicationContext;
	private List exportFolders = new ArrayList();
	
	public BaseExportTestCase(String[] springConfigResources) {
		super();
		
		this.springConfigResources = springConfigResources;
	}

	public BaseExportTestCase(String name, String[] springConfigResources) {
		super(name);
		
		this.springConfigResources = springConfigResources;
	}
	
	protected void initApplicationContext() {
		applicationContext = new ClassPathXmlApplicationContext(springConfigResources);
	}
	
	protected Object getBean(String beanName) {
		return applicationContext.getBean(beanName);
	}

	public void setUp() throws Exception {
		exportFolders.clear();
		
		initApplicationContext();
	}
	
	public void tearDown() throws Exception {
		try {
			deleteExportFolders();
		} finally {
			applicationContext.close();
		}
	}

	protected void deleteExportFolders() {
		for (Iterator it = exportFolders.iterator(); it.hasNext();) {
			String folder = (String) it.next();
			deleteFolder(new File(folder));
		}
	}
	
	protected void deleteFolder(File folder) {
		if (folder.exists() && folder.isDirectory()) {
			File[] subFiles = folder.listFiles();
			if (subFiles != null) {
				for (int i = 0; i < subFiles.length; i++) {
					File subFile = subFiles[i];
					if (subFile.isFile()) {
						subFile.delete();
					} else if (subFile.isDirectory()) {
						deleteFolder(subFile);
					}
				}
			}
			
			folder.delete();
		}
	}

	protected String createExportDir() {
		String dir = EXPORT_BASE_DIR + FILE_SEPARATOR + "export_" + random.nextInt();
		exportFolders.add(dir);
		return dir;
	}

	protected void performExport(Parameters params) {
		CommandBean exporter = (CommandBean) getBean(EXPORT_COMMAND_BEAN_NAME);
		exporter.process(params);
	}

	protected void performImport(Parameters params) {
		CommandBean importer = (CommandBean) getBean(IMPORT_COMMAND_BEAN_NAME);
		importer.process(params);
	}
	
	protected Parameters createParameters() {
		return new ParametersImpl();
	}

}
