/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.util.test;

/**
 * @author tkavanagh
 * @version $id $
 */

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import junit.framework.TestCase;
import junit.textui.TestRunner;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.DataTypeImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.ReportUnitImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.RepoReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.util.DataSourceBean;
import com.jaspersoft.jasperserver.util.ExportResource;
import com.jaspersoft.jasperserver.util.FileResourceBean;
import com.jaspersoft.jasperserver.util.ImportResource;
import com.jaspersoft.jasperserver.util.ReportUnitBean;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import  com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;

public class ExportOlapTest extends TestCase {

	static final String PATH_SEP = "/";
	static final String LABEL = "_label";
	static final String DESC = "_description";
	static final String DESC_TEXT = " for export-import testing";
		
	protected final String foodMartSchemaURI = "/queries/Foodmart.xml";
	protected final String sugarCRMSchemaURI = "/queries/SugarCRMOpps.xml";
	
	final String OLAP_FOLDER = "test_olap_05";
	final String OLAP_REPORT_NAME = "OlapSugarMondrianView";
	
	private RepositoryService repo;
    private OlapConnectionService olapConn;

	UserAuthorityService userAuthService = null;		// todo: not using
	private Properties jdbcProps;
	private ExecutionContext context;
	
    private String SAMPLE_SUGAR_CRM_MDX_QUERY =
    	"select {[Measures].[Total Sale Amount], [Measures].[Number of Sales], [Measures].[Avg Sale Amount], [Measures].[Avg Time To Close (Days)], [Measures].[Avg Close Probablility]} ON COLUMNS, " +
    	" NON EMPTY {([Account Categorization].[All Accounts], [Close Period].[All Periods])} ON ROWS " +
    	" from [SalesAnalysis] " +
    	" where [Sale State].[All Types].[Closed Won]";

	public ExportOlapTest(String name) {
		super(name);
	}
	
	public static void main(String[] args) {
		TestRunner.run(ExportOlapTest.class);
	}
	
	public void setUp() throws Exception {
		System.out.println("ExportOlapTest: setUp");
		
		ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext(
		        new String[] {"hibernateConfig.xml", "viewService.xml"});
		
		repo = (RepositoryService) appContext.getBean("repoService");
		
		olapConn = (OlapConnectionService) appContext.getBean("olapConnectionService");
		
		loadJdbcProps();
	}
	
	public void tearDown() {
		System.out.println("ExportOlapTest: tearDown");
	}
	
	
	/*
	 * This test will create a few olap resources and then
	 * create an olap unit that uses a MondrianConnection
	 * against the SugarCRM database.
	 */
	public void testOlapView() {
		
		createOlapConnectionSimpleResources();
		
		ExportResource exporter = new ExportResource(repo, 
				userAuthService,
				null,
				context, 
				PATH_SEP + OLAP_FOLDER + PATH_SEP + OLAP_REPORT_NAME,
				false,
				null,
				null,
				false,
				null,
				ExportResource.CATALOG_DIR_NAME, 
				ExportResource.CATALOG_FILE_NAME);
		
		exporter.process();
		
		
		deleteOlapConnectionSimpleResources();
		
		// junit asserts
		OlapUnit ou_null = (OlapUnit) repo.getResource(null, 
				PATH_SEP + OLAP_FOLDER + PATH_SEP + OLAP_REPORT_NAME);
		assertNull(ou_null);
		
		
		ImportResource importer = new ImportResource(repo,
				null,
				null,
				context, 
				ExportResource.CATALOG_DIR_NAME, 
				ExportResource.CATALOG_FILE_NAME, 
				"");
		
		importer.process();
		
		// junit asserts
		OlapUnit unit = (OlapUnit) repo.getResource(null, 
				PATH_SEP + OLAP_FOLDER + PATH_SEP + OLAP_REPORT_NAME);
		assertNotNull(unit);
		
		deleteOlapConnectionSimpleResources();
	}
		
	protected void createOlapConnectionSimpleResources() {
		
		Folder folder = new FolderImpl();
		folder.setName(OLAP_FOLDER);
		folder.setLabel(OLAP_FOLDER + LABEL);
		folder.setDescription(OLAP_FOLDER + DESC);
		folder.setParentFolder("/");
		repo.saveFolder(null, folder);
		
		FileResource schema = (FileResource) repo.newResource( null, FileResource.class );
        schema.setName("SugarCRMSchema");
        schema.setLabel("SugarCRM Opportunities DataMart");
        schema.setDescription("SugarCRM Opportunities Data Mart Schema");
        schema.setFileType(ResourceDescriptor.TYPE_MONDRIAN_SCHEMA);
        InputStream in = getClass().getResourceAsStream(sugarCRMSchemaURI);
        schema.readData(in);
        olapConn.saveResource( null, PATH_SEP + OLAP_FOLDER + PATH_SEP, schema );
		
        JdbcReportDataSource ds =
            (JdbcReportDataSource) repo.newResource( null, JdbcReportDataSource.class );
        ds.setName("SugarCRMDataSource");
        ds.setLabel("SugarCRM Data Source");
        ds.setDescription("SugarCRM Data Source");
        ds.setDriverClass(jdbcProps.getProperty("test.jdbc.driverClassName"));
        ds.setConnectionUrl(jdbcProps.getProperty("test.jdbc.url"));
        ds.setUsername(jdbcProps.getProperty("test.jdbc.username"));
        ds.setPassword(jdbcProps.getProperty("test.jdbc.password"));
        olapConn.saveResource( null, PATH_SEP + OLAP_FOLDER + PATH_SEP, ds );
        
        MondrianConnection mondConn = 
        	(MondrianConnection) repo.newResource( null, MondrianConnection.class );
        mondConn.setName("SugarCRM");
        mondConn.setLabel("SugarCRM OLAP Connection");
        mondConn.setDescription("SugarCRM OLAP Connection: only opportunities");
        mondConn.setSchemaReference(PATH_SEP + OLAP_FOLDER + PATH_SEP + "SugarCRMSchema");
        mondConn.setDataSourceReference(PATH_SEP + OLAP_FOLDER + PATH_SEP + "SugarCRMDataSource");
        olapConn.saveResource(null, PATH_SEP + OLAP_FOLDER + PATH_SEP, mondConn );
        
        XMLAConnection xmlaConn = (XMLAConnection) repo.newResource( null, XMLAConnection.class );
        xmlaConn.setName("SugarCRMXmlaConnection");
        xmlaConn.setLabel("SugarCRM XML/A Connection");
        xmlaConn.setDescription("SugarCRM XML/A Connection");
        xmlaConn.setCatalog("SugarCRM");
        xmlaConn.setDataSource("Provider=Mondrian;DataSource=SugarCRM;");
        xmlaConn.setURI("http://localhost:8080/jasperserver/xmla");
        xmlaConn.setUsername("tomcat"); 
        xmlaConn.setPassword("tomcat"); 
        olapConn.saveResource(null,  PATH_SEP + OLAP_FOLDER + PATH_SEP, xmlaConn );
        
        MondrianXMLADefinition def = 
        	(MondrianXMLADefinition) repo.newResource( null, MondrianXMLADefinition.class );
        def.setName("SugarCRMXmlaDefinition");
        def.setLabel("SugarCRM XMLA Connection");
        def.setDescription("SugarCRM XMLA Connection");
        def.setCatalog("SugarCRM");
        def.setMondrianConnectionReference(PATH_SEP + OLAP_FOLDER + PATH_SEP + "SugarCRM");

        olapConn.saveResource( null, PATH_SEP + OLAP_FOLDER + PATH_SEP, def );
        
        // OlapUnit
    	OlapUnit view = (OlapUnit) repo.newResource( null, OlapUnit.class );
    	view.setName(OLAP_REPORT_NAME);
    	view.setLabel("SugarCRM sample unit 1");
    	view.setDescription("SugarCRM Sample Olap Unit 1: Sales Performance by Industry/Account");
    	view.setOlapClientConnectionReference(PATH_SEP + OLAP_FOLDER + PATH_SEP + "SugarCRM");
    	view.setMdxQuery(SAMPLE_SUGAR_CRM_MDX_QUERY);
    	olapConn.saveResource(null, PATH_SEP + OLAP_FOLDER + PATH_SEP, view );
	}
	
	protected void deleteOlapConnectionSimpleResources() {
		
		repo.deleteFolder(null, PATH_SEP + OLAP_FOLDER);
	}
	
    
    public void setConnectionService(OlapConnectionService cs) {
        
    }
	
	protected Properties loadJdbcProps() throws IOException, FileNotFoundException {
		jdbcProps = new Properties();
		String jdbcPropFile = System.getProperty("test.hibernate.jdbc.properties");
		BufferedInputStream is = new BufferedInputStream(new FileInputStream(jdbcPropFile));
		jdbcProps.load(is);
		is.close();
		return jdbcProps;
	}
	
}
