/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;

/**
 * Implementation of TreeNode
 * @author asokolnikov
 *
 */
public class TreeNodeImpl implements TreeNode {
    
    protected String id;
    protected String label;
    protected String type;
    protected String uri;
    protected JSONObject extraProperty;
    
    protected List children = new ArrayList();
    
    protected TreeDataProvider dataProvider;
    
    public TreeNodeImpl(TreeDataProvider dataProvider, 
            String id, String label, String type, String uri) {
        
        this.dataProvider = dataProvider;
        this.id = id;
        this.label = label;
        this.type = type;
        this.uri = uri;
    }

    public TreeNodeImpl(TreeDataProvider dataProvider, 
            String id, String label, String type, String uri, JSONObject extraProperty) {
        this(dataProvider, id, label, type, uri);
        this.extraProperty = extraProperty;
    }
    
    public List getChildren() {
        return children;
    }

    public String getId() {
        return id;
    }

    public String getLabel() {
        return label;
    }

    public String getType() {
        return type;
    }

    public String getUriString() {
        return uri;
    }

    public JSONObject getExtraProperty() {
        return extraProperty;
    }

    public void setExtraProperty(JSONObject extraProperty) {
        this.extraProperty = extraProperty;
    }

    public String toJSONString() {
        StringBuffer sb = new StringBuffer();
        
        sb.append("{\"id\":\"").append(id).append("\",")
            .append("\"label\":\"").append(escape(label)).append("\",")
            .append("\"type\":\"").append(type).append("\",")
            .append("\"uri\":\"").append(uri).append("\"");
        
        if (extraProperty != null) {
            sb.append(",\"extra\":").append(extraProperty.toJSONString());
        }
        
        if (!children.isEmpty()) {
            sb.append(",\"children\":[");
            for (Iterator iter = children.iterator(); iter.hasNext(); ) {
                TreeNode child = (TreeNode) iter.next();
                sb.append(child.toJSONString());
                if (iter.hasNext()) {
                    sb.append(',');
                }
            }
            sb.append(']');
        }
        
        sb.append('}');
        
        return sb.toString();
    }
    
    protected String escape(String str) {
    	return (str == null) ? null : str.replace("\"", "\\\"");
    }

}
