/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 * Licensed under commercial JasperSoft Subscription License Agreement
 */

/////////////////////////////////////
// author: Angus Croll
// Generic AJAX utilities
/////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Constructor for AJAX request object.
// By sending itself as an argument to the reponse function we ensure
// that the xmlhttp response that we handle is the one that belongs to the request
///////////////////////////////////////////////////////////////////////////////////////
function AjaxRequester(url, params, postData) {
    this.url = url;
    this.params = params;
    this.xmlhttp = getXMLHTTP();
    var rsChangeFunction = this.processResponse(this);
    this.xmlhttp.onreadystatechange = rsChangeFunction;
    this.errorHandler = defaultErrorHandler;
    this.postData = postData;
}

//
// submits an ajax get request
//
AjaxRequester.prototype.doGet = function() {
    if (this.xmlhttp) {
        this.xmlhttp.open("GET",this.url,true);
        this.xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
                this.xmlhttp.setRequestHeader( "If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT" );
        this.xmlhttp.send(null);
        return true;
    }
    return false;
}

//
// submits an ajax post request
//
AjaxRequester.prototype.doPost = function() {
    if (this.xmlhttp) {
        this.xmlhttp.open("POST",this.url,true);
        this.xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
        this.xmlhttp.send(this.postData);
        return true;
    }
    return false;
}

//
// handles the ajax response from the specific requester instance
//
AjaxRequester.prototype.processResponse = function(requester) {
    return (function() {
    if (requester.xmlhttp.readyState==4) {
        handleResponse(requester, requester.params);
        }
    });
}


AjaxRequester.prototype.setErrorHandler = function(errorHandler) {
    this.errorHandler = errorHandler;
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// Ajax Requester: End
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
// Response Handling
///////////////////////////////////////////////////////////////////////////////////////////////////
//
//Generic handler for all ajax responses
//
function handleResponse(requester, params) {
    try {
        if (checkForErrors(requester))
            return;
        requester.responseHandler(requester, params);
    } finally {
        //reset waiting cursor
        if (requester.responseHandler != doNothing)
            ajaxRequestEnded();
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// Response Handler Functions
///////////////////////////////////////////////////////////////////////////////////////////////////
var targettedResponseHandler = function(requester, params) {
    var xmlhttp = requester.xmlhttp;

    //sanity check
    if (!xmlhttp.responseText) {
        window.status="server retrieval failed";
        return;
    }

    var fillLocation = params[0];
    var fromLocation = params[1];
    var postFillAction = params[2];
    var toLoc = document.getElementById(fillLocation);

    toLoc.innerHTML="";
    if (fromLocation) {
        //we only want part ofthe retrieved content so isolate it
        var fromSource = document.createElement("DIV");
        fromSource.id="temp";

        fromSource.innerHTML=xmlhttp.responseText;

        document.body.insertBefore(fromSource, document.body.firstChild);

        fromSource.style.display='none';
        var fromLoc = document.getElementById(fromLocation);

        document.body.removeChild(fromSource);

        if (toLoc.tagName=="TABLE") {
            copyTable(fromLoc,toLoc);
        } else {
            toLoc.appendChild(fromLoc);
        }

    } else {
        //we want all the retrieved content - throw it all in
        toLoc.innerHTML = xmlhttp.responseText;
    }
    if (postFillAction) {
        if (typeof(postFillAction) == 'string') {
            eval(postFillAction);
        } else {
            postFillAction();
        }
    }
}

var clobberingResponseHandler = function(requester, params) {
    document.body.innerHTML=    requester.xmlhttp.responseText;
}



////////////////////////////////////////////////////////////////////////////////
// Update API
////////////////////////////////////////////////////////////////////////////////

//send an ajax request with this URL and update the entire page with the response
function ajaxClobberredUpdate(url) {
    ajaxUpdate(url,clobberingResponseHandler);
}

//send an ajax request with this URL and update the targetContainer  with the sourceContainer container of the response DOM
//optionally execute the postFillAction
function ajaxTargettedUpdate(url,targetContainer,sourceContainer,postFillAction,errorHandler,postData) {
    ajaxUpdate(url,targettedResponseHandler,targetContainer,sourceContainer,postFillAction,errorHandler,postData);
}

//send an ajax request with this URL but don't return any content to the sender
function ajaxNonReturningUpdate(url,targetContainer,sourceContainer,postFillAction,errorHandler,postData) {
    ajaxUpdate(url,null, targetContainer,sourceContainer,postFillAction,errorHandler,postData);
}

//dummy response handler for non returning case
function doNothing() {
}

function ajaxUpdate(url,responseHandler,fillLocation,fromLocation,postFillAction,errorHandler,postData) {
  if (!responseHandler)
    responseHandler = doNothing; //non returning request
  if (responseHandler != doNothing)
    ajaxRequestStarted();
  var requester = new AjaxRequester(url, [fillLocation,fromLocation,postFillAction], postData);
  requester.responseHandler = responseHandler;
  if (errorHandler)
    requester.errorHandler = errorHandler;
  if (requester.xmlhttp) {
    if (postData) {
      requester.doPost();
    } else {
      requester.doGet();
    }
  }
}

function checkForErrors(requester) {
    var errorHandler = requester.errorHandler;
    return errorHandler(requester.xmlhttp);
}

var defaultErrorHandler = function() {
    return false;
}

function ajaxClobberedFormSubmit(form, url, extraPostData, targetContainer, sourceContainer, postFillAction, errorHandler)
{
  var postData = getPostData(form);
  postData = appendPostData(postData, extraPostData);
    ajaxUpdate(url, clobberingResponseHandler, targetContainer, sourceContainer, postFillAction, errorHandler, postData);
}

function ajaxTargettedFormSubmit(form, url, extraPostData, targetContainer, sourceContainer, postFillAction, errorHandler)
{
  var postData = getPostData(form);
  postData = appendPostData(postData, extraPostData);
    ajaxUpdate(url, targettedResponseHandler, targetContainer, sourceContainer, postFillAction, errorHandler, postData);
}

function getPostData(form)
{
  if (typeof form == 'string')
  {
    form = document.forms[form];
  }

  var data = "";
  for (var i = 0; i < form.elements.length; ++i)
  {
    data = appendFormInput(data, form.elements[i]);
  }

  return data;
}

function appendPostData(postData, extraPostData)
{
  for (name in extraPostData)
  {
    postData = appendFormValue(postData, name, extraPostData[name]);
  }
  return postData;
}

function appendFormInput(data, element)
{
  if (element.name)
  {
    var value;
    var append = false;
    switch (element.type)
    {
      case "checkbox":
      case "radio":
        append = element.checked;
        value = element.value;
        break;
      case "hidden":
      case "password":
      case "text":
      case "Textarea":
        append = true;
        value = element.value;
        break;
      case "select-one":
      case "select-multiple":
        value = new Array();
        for (var i = 0; i < element.options.length; ++i)
        {
          var option = element.options[i];
          if (option.selected)
          {
            append = true;
            value.push(option.value);
          }
        }
        break;
    }

    if (append)
    {
      if (value.pop)
      {
        while (value.length > 0)
        {
          data = appendFormValue(data, element.name, value.pop());
        }
      }
      else
      {
        data = appendFormValue(data, element.name, value);
      }
    }
  }

  return data;
}

function appendFormValue(data, name, value)
{
  if (data.length > 0)
  {
    data += "&";
  }
  data += name + "=" + encodeURIComponent(value);
  return data;
}

function baseErrorHandler(ajaxAgent)
{
  var sessionTimeout = ajaxAgent.getResponseHeader("LoginRequested");
  if (sessionTimeout)
  {
        var newloc ='.';
        document.location = newloc;
        return true;
    }

    var isErrorPage = ajaxAgent.getResponseHeader("JasperServerError");
    if (isErrorPage)
    {
      showErrorPopup(ajaxAgent);
      return true;
    }

    return false;
}

var ERROR_POPUP_DIV = "jsErrorPopup";
var ERROR_POPUP_CONTENTS = "errorPopupContents";
var ERROR_POPUP_BACK_BUTTON = "errorBack";
var ERROR_POPUP_CLOSE_BUTTON = "errorPopupCloseButton";

function showErrorPopup(ajaxAgent)
{
  var errorPopupContents = document.getElementById(ERROR_POPUP_CONTENTS);
  errorPopupContents.innerHTML = ajaxAgent.responseText;

  var backButton = document.getElementById(ERROR_POPUP_BACK_BUTTON);
  if (backButton)
  {
    backButton.style.visibility = "hidden";
  }

  var errorPopup = document.getElementById(ERROR_POPUP_DIV);
  centerLayer(errorPopup);
  pushOverlayObject("mainTable", "haze", 98);
  errorPopup.style.display = "block";
  focusOn(ERROR_POPUP_CLOSE_BUTTON);
}

function hideErrorPopup()
{
  popOverlayObject();
  var errorPopup = document.getElementById(ERROR_POPUP_DIV);
  errorPopup.style.display = "none";
}


////////////////////////////////////////////////////////////////////////////////
// XMLHTTP
////////////////////////////////////////////////////////////////////////////////
//
// standard function to obtain an xmlhttp instance regardless of platform
//
function getXMLHTTP() {
    var alerted;
    var xmlhttp;
    /*@cc_on @*/
    /*@if (@_jscript_version >= 5)
    // JScript gives us Conditional compilation, we can cope with old IE versions.
      try {
      xmlhttp=new ActiveXObject("Msxml2.XMLHTTP")
    } catch (e) {
        try {
            xmlhttp=new ActiveXObject("Microsoft.XMLHTTP")
        } catch (E) {
            alert("You must have Microsofts XML parsers available")
        }
    }
    @else
        alert("You must have JScript version 5 or above.")
        xmlhttp=false
        alerted=true
    @end @*/
    if (!xmlhttp && !alerted) {
    // Non ECMAScript Ed. 3 will error here (IE<5 ok), nothing I can
    // realistically do about it, blame the w3c or ECMA for not
    // having a working versioning capability in  <SCRIPT> or
    // ECMAScript.
        try {
            xmlhttp = new XMLHttpRequest();
        } catch (e) {
            alert("You need a browser which supports an XMLHttpRequest Object.\nMozilla build 0.9.5 has this Object and IE5 and above, others may do, I don't know, any info jim@jibbering.com")
        }
    }
    return xmlhttp
}

var ajaxRequestCount = 0;

function ajaxRequestStarted()
{
    ++ajaxRequestCount;
    document.body.style.cursor = "wait";
}

function ajaxRequestEnded()
{
    if (ajaxRequestCount <= 1)
    {
        document.body.style.cursor = "default";
        ajaxRequestCount = 0;
    }
    else
    {
        --ajaxRequestCount;
    }
}

