/**
* Original Author of this file: Martin Mouritzen. (martin@nano.dk)
*
*
* (Lack of) Documentation:
*
*
* If a finishedLoading method exists, it will be called when the tree is loaded.
* (good to display a div, etc.).
*
*
* You have to set the variable rootNode (as a TreeNode).
*
* You have to set a container element, this is the element in which the tree will be.
*
*
* TODO: 
* Save cookies better (only 1 cookie for each tree). Else the page will totally cookieclutter.
* 
* 
* //////////////////////////////////////
* 
* Changes made to the original version
*  - tree and treenode related methods and fields made instance methods and fields (were global)
*  - now you can have many trees on the same page independently
*  - trees and nodes maps intruduced to find trees and nodes by id
*  - nodes get autogenerated ids, unique over all nodes on the page
*  
*  temporarly changes
*  - tree visual state gets reset each time tree is rendered
*  - drag & drop does not work (was for IE only)
*/


/***********************************************************************
* Configuration variables.
************************************************************************/

// Should the rootNode be displayed.
//var showRootNode = true;

// Should the dashed lines between nodes be shown.
var showLines = true;

// Should the nodes be sorted? (You can either specify a number, then it will be sorted by that, else it will
// be sorted alphabetically (by name).
var sortNodes = true;

// This is IMPORTANT... use an unique id for each document you use the tree in. (else they'll get mixed up).
//var documentID = window.location.href;

// being read from cookie.
var nodesOpen = new Array();
// RootNode of the tree.
//var rootNode;

// Container to display the Tree in.
//var container;

// Shows/Hides subnodes on startup
var showAllNodesOnStartup = false;

// Is the roots dragable?
var dragable = false;


/************************************************************************
* The following is just instancevariables.
************************************************************************/
//var href = '';

// rootNodeCallBack name (if null, it's not selectable).
//var rootNodeCallBack = null;

// selectedNode
//var selectedNode = null; // !!!!

//var states = '';
//var statearray = new Array();

var treeNodeEdited = null; // !!!!

var editaborted = false;

var floatDragElement = null;
var colouredElement = null;
var draggedNodeID = null;
var lastDraggedOnNodeID = null;

// tree map, use to find/store trees, ex: trees['myId']
// Tree constructor registers the tree automatically in here
var trees = {};
// node index map, helps to find any node by id
// TreeNode constructor registers the node automatically in here
var nodes = {};


/**
 * The Tree Object
 *
 * @param id tree id
 * @param root Root Node
 * @param providerId Data Provider id
 * @param resourcePath server path to images (tricky)
 * @param bShowRoot true if you want to show tree root node, false otherwise
 */
function Tree(id, root, providerId, resourcePath, bShowRoot) {
    this.id = id;
    this.rootNode = root;
    if (this.rootNode) this.rootNode.treeId = id;
    this.providerId = providerId;
    this.resourcePath = resourcePath;
    this.bShowRoot = !!bShowRoot;
    this.statearray = new Array();

    this.selectedNode = null;

    // self-indexing
    trees[id] = this;
}

/**
 * global node id counter
 */
Tree.getNextId = function() {
    var nextId = 1; // private static var
    return function() {
        return nextId++;
    }
}();


/**
 * The TreeNode Object
 * @param name The title of this node
 * @param icon The icon if this node (Can also be an array with 2 elements, the first one will represent the closed state, and the next one the open state)
 * @param param A parameter, this can be pretty much anything. (eg. an array with information).
 * @param orderNumber an orderNumber If one is given the nodes will be sorted by this (else they'll be sorted alphabetically (If sorting is on).
 */
function TreeNode(name,icon,param,orderNumber) {
	this.id = Tree.getNextId();
	this.treeId = null; // tree sets it
	this.childs = new Array();
	this.name = (name == null ? 'unset name' : name);
	this.icon = (icon == null ? '' : icon);
	this.parent = null;
	this.handler = null;
	this.param = (param == null ? '' : param);
	this.orderNumber = (orderNumber == null ? -1 : orderNumber);
	this.isloaded = false;
	
	this.openeventlisteners = new Array();
	this.editeventlisteners = new Array();
	this.moveeventlisteners = new Array();
	this.haschilds = false;
	this.editable = false;
	this.linestring = '';
	
	this.nextSibling = null;
	this.prevSibling = null;
	
	//this.childsHasBeenFetched = false;

	this.getID = function() {
		return this.id;
	}
	this.getTreeId = function() {
		return this.treeId || (this.parent && this.parent.getTreeId());
	}
	this.setName = function(newname) {
		this.name = newname;
	}
	this.getName = function() {
		return this.name;
	}
	this.getParam = function() {
		return this.param;
	}
	this.setIcon = function(icon) {
		this.icon = icon;
	}
	this.getIcon = function() {
		if (typeof(this.icon) == 'object') {
			return this.icon[0];
		}
		return this.icon;
	}
	this.getOpenIcon = function() {
		if (typeof(this.icon) == 'object') {
			return this.icon[1];
		}
		return this.icon;
	}
	this.hasIcon = function () {
		return this.icon != '';
	}
	this.getOrderNumber = function() {
		return this.orderNumber;
	}
	this.addOpenEventListener = function(event) {
		this.openeventlisteners[this.openeventlisteners.length] = event;
	}
	this.gotOpenEventListeners = function() {
		return (this.openeventlisteners.length > 0);
	}
	this.addEditEventListener = function(event) {
		this.editeventlisteners[this.editeventlisteners.length] = event;
	}
	this.gotEditEventListeners = function() {
		return (this.editeventlisteners.length > 0);
	}
	this.addMoveEventListener = function(event) {
		this.moveeventlisteners[this.moveeventlisteners.length] = event;
	}
	this.gotMoveEventListeners = function() {
		return (this.moveeventlisteners.length > 0);
	}
	this.addChild = function(childNode) {
		var possiblePrevNode = this.childs[this.childs.length - 1]
		if (possiblePrevNode) {
			possiblePrevNode.nextSibling = childNode;
			childNode.prevSibling = possiblePrevNode;
			// alert(childNode.prevSibling);
		}

		this.childs[this.childs.length] = childNode;
		childNode.setParent(this);

		if (sortNodes) {
			function sortByOrder(a,b) {
				var order1 = a.getOrderNumber();
				var order2 = b.getOrderNumber();
				if (order1 == -1 || order2 == -1) {
					return a.getName().toLowerCase() > b.getName().toLowerCase() ? 1 : -1;
				}
				else {
					if (order1 == order2) {
						// If they got the same order number, then we'll sort by their title.
						return a.getName().toLowerCase() > b.getName().toLowerCase() ? 1 : -1;
					}
					else {
						return order1 - order2;
					}
				}
			}
			this.childs.sort(sortByOrder);
		}
	}
	this.removeChild = function(childNode) {
		var found = false;
		for (var i=0;i<this.childs.length;i++) {
			if (found) {
				this.childs[i] = this.childs[i + 1];
			}
			if (this.childs[i] == childNode) {
				if (i == (this.childs.length - 1)) {
					this.childs[i] = null;
				}
				else {
					this.childs[i] = this.childs[i + 1];
				}
				found = true;
			}
		}
		if (found) {
			this.childs.length = this.childs.length-1;
		}
	}
	this.resetChilds = function() {
		this.childs = new Array();
	}
	this.setHasChilds = function(hasChilds) {
		this.haschilds = hasChilds;
	}
	this.hasChilds = function() {
		if (this.haschilds == true) {
			return true;
		}
		return (this.childs.length > 0);
	}
	this.getChildCount = function() {
		return this.childs.length;
	}
	this.getFirstChild = function() {
		if (this.hasChilds()) {
			return this.childs[0];
		}
		return null;
	}
	this.gotHandler = function() {
		return this.handler != null;
	}
	this.setHandler = function(handler) {
		this.handler = handler;
	}
	this.getHandler = function() {
		return this.handler;
	}
	this.setParent = function(parent) {
		this.parent = parent;
	}
	this.getParent = function() {
		return this.parent;
	}
	this.getLineString = function() {
		return this.linestring;
	}
	this.setLineString = function(string) {
		this.linestring = string;
	}
	this.isEditable = function() {
		return this.editable;
	}
	this.setEditable = function(editable) {
		this.editable = editable;
	}
	this.isLoaded = function() {
		return !this.haschilds || this.isloaded;
	}
	this.setIsLoaded = function(b) {
		this.isloaded = b;
	}
	
	// self-indexing
	nodes[this.id] = this;
}
/*function getTreeNode(treeID, nodeID) {
	var tree = trees[treeID];
	if (tree == null)
		return null;
	return findNodeWithID(tree.rootNode,nodeID);
}
function findNodeWithID(node,nodeID) {
	if (node.getID() == nodeID) {
		return node;
	}
	else {
		if (node.hasChilds()) {
			for(var i=0;i<node.getChildCount();i++) {
				var value = findNodeWithID(node.childs[i],nodeID);
				if (value != false) {
					return value;
				}
			}
		}
		return false;
	}
}*/
function getTreeNode(nodeID) {
	return nodes[nodeID];
}
// !!!!
//function readStates() {
Tree.prototype.readStates = function () {

	//setCookie('tree' + documentID,'');
	//var states = getCookie('tree' + documentID);
	var states = getCookie('tree' + this.treeId);
	if (states != null) {
		var array = states.split(';');
		for(var i=0;i<array.length;i++) {
			var singlestate = array[i].split('|');
			this.statearray[i] = new Array();
			this.statearray[i]["key"] = singlestate[0];
			this.statearray[i]["state"]  = singlestate[1];
		}
	}
}
// !!!!
//function getState(nodeID) {
Tree.prototype.getState = function (nodeID) {
	var state;
	for(var i=0;i<this.statearray.length;i++) {
		if (this.statearray[i]["key"] == nodeID) {
			state = this.statearray[i]["state"];
			if (state == null || state == '') {
				state = 'closed';
			}
			return state;
		}
	}
	return "closed";
}
// !!!!
//function writeStates(nodeID,newstate) {
Tree.prototype.writeStates = function (nodeID,newstate) {
	//alert(nodeID);
	var str = '';
	var found = false;
	for(var i=0;i<this.statearray.length;i++) {
		if (this.statearray[i]["key"] == nodeID) {
			this.statearray[i]["state"] = newstate;
			found = true;
		}
		if (this.statearray[i]["state"] != null) {
			str += this.statearray[i]["key"] + '|' + this.statearray[i]["state"] + ';';
		}
	}
	if (found == false) {
		this.statearray[this.statearray.length] = new Array();
		this.statearray[this.statearray.length - 1]["key"] = nodeID;
		this.statearray[this.statearray.length - 1]["state"] = newstate;
		if (newstate != null) {
			str += nodeID + '|' + newstate + ';';
		}
	}
	//setCookie('tree' + documentID,str);
	setCookie('tree' + this.treeId,str);
}
Tree.prototype.resetStates = function () {
	this.statearray = new Array();
	setCookie('tree' + this.treeId,'');
}
//function showTree(path) {
Tree.prototype.renderTree = function() {
	this.readStates();
	
	//href = path;
	//window.focus();
	//window.onblur = blurSelection;
	//window.onfocus = focusSelection;
	var str = '';
	str = '<div id="node' + this.rootNode.getID() + '" class="treetitle" style="display:' + (this.bShowRoot == true ? 'block' : 'none') + '">';
	str += '<nobr>';
	if (this.rootNode.hasIcon()) {
		str += '<img src="' + this.rootNode.getIcon() + '" style="vertical-align:middle;">';
	}
	str += '<span style="vertical-align:middle;">&nbsp;' + this.rootNode.getName() + '</span>';
	str += '</nobr></div>';
	
	if (this.rootNode.hasChilds()) {
		for(i=0;i<this.rootNode.childs.length;i++) {
			//nodeContents = showNode(rootNode.childs[i],(i == (rootNode.getChildCount() -1)));
			nodeContents = this.rootNode.childs[i].showNode((i == (this.rootNode.getChildCount() -1)));
			str = str + nodeContents;
		}
	}
	//container.innerHTML = str;
	//if (window.finishedLoading) {
	//	finishedLoading();
	//}
	return str;
}
/**
* Shows the given node, and subnodes.
*/
//function showNode(treeNode,lastNode) {
TreeNode.prototype.showNode = function(lastNode) {
	var tree = trees[this.getTreeId()];
	var href = tree.resourcePath;

	linestring = this.getLineString();
	var state = tree.getState(this.getID());
	var str;
	str = '<div style="filter:alpha(opacity=100);" ondragenter="dragEnter(' + this.getID() + ');" ondragleave="dragLeave();" ondragstart="startDrag(' + this.getID() + ');" ondrag="dragMove();" ondragend="endDrag(' + this.getID() + ')" id="node' + this.getID() + '">';
	str += '<nobr>';
	for(var y=0;y<linestring.length;y++) {
		if (linestring.charAt(y) == 'I') {
			str += '<img src="' + href + 'images/' + (showLines ? 'line' : 'white') + '.gif" style="width:19px;height:20px;vertical-align:middle;">';
		}
		else if (linestring.charAt(y) == 'B') {
			str += '<img src="' + href + 'images/white.gif" style="width:19px;height:20px;vertical-align:middle;">';
		}
	}
	if (this.hasChilds()) {
		// If this is the first child of the rootNode, and showRootNode is false, we want to display a different icon.
		if (!tree.bShowRoot && (this.getParent() == tree.rootNode) && (this.getParent().getFirstChild() == this)) {
			if (!lastNode) {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (state == 'open' ? (showLines ? 'minus_no_root' : 'minus_nolines') : (showLines ? 'plus_no_root' : 'plus_nolines')) + '.gif" style="width:19px;height:20px;vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].handleNode();">';
			}
			else {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (state == 'open' ? 'minus_last' : 'plus_last') + '_no_root.gif" style="width:19px;height:20px;vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].handleNode();">';
			}
		}
		else {
			if (!lastNode) {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (state == 'open' ? (showLines ? 'minus' : 'minus_nolines') : (showLines ? 'plus' : 'plus_nolines')) + '.gif" style="width:19px;height:20px;vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].handleNode();">';
			}
			else {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (state == 'open' ? (showLines ? 'minus_last' : 'minus_nolines') : (showLines ? 'plus_last' : 'plus_nolines')) + '.gif" style="width:19px;height:20px;vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].handleNode();">';
			}
		}
	}
	else {
		// If this is the first child of the rootNode, and showRootNode is false, we want to display a different icon.
		if (!tree.bShowRoot && (this.getParent() == tree.rootNode) && (this.getParent().getFirstChild() == this)) {
			if (!lastNode) {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (showLines ? 't_no_root' : 'white') + '.gif" style="width:19px;height:20px;vertical-align:middle;">';
			}
			else {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/white.gif" style="width:19px;height:20px;vertical-align:middle;">';
			}
		}
		else {
			if (!lastNode) {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (showLines ? 't' : 'white') + '.gif" style="width:19px;height:20px;vertical-align:middle;">';
			}
			else {
				str += '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (showLines ? 'lastnode' : 'white') + '.gif" style="width:19px;height:20px;vertical-align:middle;">';
			}
		}
	}
	iconStartImage = this.getIcon();
	if (state != 'closed') {
		if (this.hasChilds()) {
			iconStartImage = this.getOpenIcon();
		}
	}
	
	str += '<img id="iconimage' + this.getID() + '" src="' + iconStartImage + '" style="vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].selectNode()">';
	str += '&nbsp;<span unselectable="ON" style="vertical-align:middle;" class="treetitle" ID="title' + this.getID() + '" OnDblClick="nodes[\'' + this.getID() + '\'].handleNode();" OnClick="nodes[\'' + this.getID() + '\'].selectNode()">';
	str += this.getName();
	str += '</span>';
	str += '</nobr>';
	str += '</div>';

	if (this.hasChilds()) {
		if (state == 'open') {
			str += '<div id="node' + this.getID() + 'sub" style="display:block;">';
			fireOpenEvent(this);
			// alert('openevent: ' + this.getName());
		}
		else {
			str += '<div id="node' + this.getID() + 'sub" style="display:' + (showAllNodesOnStartup == true ? 'block;' : 'none;') + ';">';
		}
		var subgroupstr = '';
		var newChar = '';

		if (!lastNode) {
			newChar = 'I';
		}
		else {
			newChar = 'B';
		}
		for(var z=0;z<this.getChildCount();z++) {
			this.childs[z].setLineString(linestring + newChar);
		}
		for(var z=0;z<this.getChildCount();z++) {
			subgroupstr += this.childs[z].showNode((z == (this.getChildCount() -1)));
		}
		str += subgroupstr;
		str += '</div>';
	}
	else {
		str += '<div id="node' + this.getID() + 'sub" style="display:none;">';
		str += '</div>';
	}
	return str;
}
/*
function mouseMove() {
	if (dragging) {
		alert('bob');
	}
}
function mouseUp() {
	if (dragging) {
		alert('dropped on something!');
	}
}
*/
//function startDrag(nodeID) {
TreeNode.prototype.startDrag = function() {

	if (!dragable) {
		return;
	}
	draggedNodeID = this.is;//nodeID;
	
	var srcObj = window.event.srcElement;
	while(srcObj.tagName != 'DIV') {
		srcObj = srcObj.parentElement;
	}
	floatDragElement = document.createElement('DIV');

	floatDragElement.innerHTML = srcObj.innerHTML;
	floatDragElement.childNodes[0].removeChild(floatDragElement.childNodes[0].childNodes[0]);
	
	document.body.appendChild(floatDragElement);
	floatDragElement.style.zIndex = 100;
	floatDragElement.style.position = 'absolute';
	floatDragElement.style.filter='progid:DXImageTransform.Microsoft.Alpha(1,opacity=60);';
}

function findSpanChild(element) {
	if (element.tagName == 'SPAN') {
		return element;
	}
	else {
		if (element.childNodes) {
			for(var i=0;i<element.childNodes.length;i++) {
				var value = findSpanChild(element.childNodes[i]);
				if (value != false) {
					return value;
				}
			}
			return false;
		}
	}
}

//function dragEnter(nodeID) {
TreeNode.prototype.dragEnter = function() {

	if (!dragable) {
		return;
	}
	lastDraggedOnNodeID = this.id;//nodeID;
	
	if (colouredElement) {
		findSpanChild(colouredElement).className = 'treetitle';
	}
	colouredElement = window.event.srcElement;
	while(colouredElement.tagName != 'DIV') {
		colouredElement = colouredElement.parentElement;
		if (colouredElement.tagName == 'BODY') {
			// Something gone seriously wrong.
			alert('Drag failure, reached <BODY>!');
			return;
		}
	}	
	findSpanChild(colouredElement).className = 'treetitleselectedfocused';
}
function dragLeave() {
	if (!dragable) {
		return;
	}
}

function endDrag(nodeID) {
	if (!dragable) {
		return;
	}
	if (lastDraggedOnNodeID != null) {
		fireMoveEvent(getTreeNode(lastDraggedOnNodeID),draggedNodeID,lastDraggedOnNodeID);
	}
}

function dragProceed() {
	if (!dragable) {
		return;
	}
	var dragged = getTreeNode(draggedNodeID);
	var newparent = getTreeNode(lastDraggedOnNodeID);

	var oldparent = dragged.getParent();
	
	oldparent.removeChild(dragged);
	newparent.addChild(dragged);
	
	oldparent.refreshNode();
	newparent.refreshNode();
	
	_dragClean()
}

function dragCancel() {
	if (!dragable) {
		return;
	}
	_dragClean()
}

/**
* Don't call this yourself.
*/
function _dragClean() {
	if (!dragable) {
		return;
	}
	if (colouredElement) {
		findSpanChild(colouredElement).className = 'treetitle';
	}
	
	floatDragElement.parentElement.removeChild(floatDragElement);
	floatDragElement = null;
	colouredElement = null;
	draggedNodeID = null;
	lastDraggedOnNodeID = null;
}

function dragMove() {
	if (!dragable) {
		return;
	}
	floatDragElement.style.top = window.event.clientY;
	floatDragElement.style.left = window.event.clientX;
}

function editEnded() {
	if (treeNodeEdited != null) {
		// treeNodeEdited.getID();
		var editTitle = document.getElementById('title' + treeNodeEdited.getID());
		var input = editTitle.childNodes[0];
	
		var newValue = input.value;
		
		if (newValue == treeNodeEdited.getName()) {
			editTitle.innerHTML = newValue;
			treeNodeEdited = null;
			return;
		}
	
		fireEditEvent(treeNodeEdited,newValue);
		
		if (!editaborted) {
			treeNodeEdited.setName(newValue);
			editTitle.innerHTML = newValue;
		}
	
		treeNodeEdited = null;
	}
}

//function selectNode(nodeID) {
TreeNode.prototype.selectNode = function(bSkipHandler) {

	var tree = trees[this.getTreeId()];

	if (tree.selectedNode != null) {
		if (tree.selectedNode == this.id) {
			if (this.isEditable()) {
				if (treeNodeEdited == this) {
					return;
				}
				treeNodeEdited = this;
				var editTitle = document.getElementById('title' + this.id);
				editTitle.className = 'editednode';
				

				editTitle.innerHTML = '<input type="text" onKeypress="if (event.keyCode == 13) { this.onblur = null; editEnded(); }" name="editednode" class="editednodeinput">';
				var input = editTitle.childNodes[0];
				input.value = this.getName();
				input.focus();
				input.select();
				input.onblur = editEnded;
			}
			return;
		}
		if (treeNodeEdited != null) {
			editEnded();
		}
		var oldNodeTitle = document.getElementById('title' + tree.selectedNode);
		oldNodeTitle.className = 'treetitle';
	}
	tree.selectedNode = this.id;
	var nodetitle = document.getElementById('title' + tree.selectedNode);
	nodetitle.className = 'treetitleselectedfocused';
	
	if (!bSkipHandler && this.gotHandler()) {
		this.getHandler()(getTreeNode(this.id));
	}
	/*else {
		standardClick(this);
	}*/
}

//function refreshNode(treeNode) {
TreeNode.prototype.refreshNode = function() {
	var tree = trees[this.getTreeId()];
	var href = tree.resourcePath;

	var submenu = document.getElementById('node' + this.getID() + 'sub');
	var str = '';
	for(var i=0;i<this.getChildCount();i++) {
		var parent = this.getParent();
		if (!parent) {
			this.childs[i].setLineString(this.getLineString() + 'B');
		}
		else {
			if (parent.childs[parent.childs.length - 1] == this) {
				this.childs[i].setLineString(this.getLineString() + 'B');
			}
			else {
				this.childs[i].setLineString(this.getLineString() + 'I');
			}
		}
		str += this.childs[i].showNode(i == (this.getChildCount() - 1));
	}
	var actionimage = document.getElementById('handler' + this.getID());
	if (this.getChildCount() == 0) {
		// TreeNode haven't got any children, make sure the right image is displayed.
		if (actionimage.src.indexOf('last') == -1) {
			actionimage.src = href + 'images/' + (showLines ? 't' : 'white') + '.gif';
		}
		else {
			actionimage.src = href + 'images/' + (showLines ? 'lastnode' : 'white') + '.gif';
		}
		actionimage.onclick = null;
		
		// Close the submenu
		if (submenu) {
			submenu.style.display = 'none';
		}
	}
	else {
		// We have children, make sure to display the + and - icon.
		if (actionimage.src.indexOf('plus') != -1) {
			// The TreeNode have already got children, and displays them.
		}
		else if (actionimage.src.indexOf('minus') != -1) {
			// The TreeNode have already got children, and displays them.
		}
		else {
			if (actionimage.src.indexOf('last') == -1) {
				actionimage.outerHTML = '<img id="handler' + this.getID() + '" src="' + href + 'images/' + (showLines ? 'plus' : 'plus_nolines') + '.gif" style="width:19px;height:20px;vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].handleNode();">';
			}
			else {
				actionimage.outerHTML = '<img id="handler' + this.getID() + '" src="' + href + 'images/plus_last.gif" style="width:19px;height:20px;vertical-align:middle;" OnClick="nodes[\'' + this.getID() + '\'].handleNode();">';
			}
		}
	}
	submenu.innerHTML = str;
}

//function handleNode(nodeID) {
TreeNode.prototype.handleNode = function () {
	//var treeNode = getTreeNode(nodeID);	
	var tree = trees[this.getTreeId()];
	var href = tree.resourcePath;

	if (!this.hasChilds()) { // No reason to handle a node without childs.
		return;
	}
	
	var submenu = document.getElementById('node' + this.getID() + 'sub');
	
	var iconimageholder = document.getElementById('iconimage' + this.getID());
	var actionimage = document.getElementById('handler' + this.getID());

	// This will be used if showRootNode is set to false.
	var firstChildOfRoot = false;
	if (actionimage.src.indexOf('_no_root') != -1) {
		firstChildOfRoot = true;
	}
	
	if (submenu.style.display == 'none') {
		tree.writeStates(this.getID(),'open');
		fireOpenEvent(this);
		submenu.style.display = 'block';

		iconimageholder.src = this.getOpenIcon();
	
		if (actionimage.src.indexOf('last') == -1) {
			actionimage.src = href + 'images/' + ((firstChildOfRoot) ? 'minus_no_root' : (showLines ? 'minus' : 'minus_nolines')) + '.gif';
		}
		else {
			actionimage.src = href + 'images/' + ((firstChildOfRoot) ? 'minus_last_no_root' : (showLines ? 'minus_last' : 'minus_nolines')) + '.gif';
		}
	}
	else {
		tree.writeStates(this.getID(),'closed');
		submenu.style.display = 'none';
		
		iconimageholder.src = this.getIcon();
		
		if (actionimage.src.indexOf('last') == -1) {
			actionimage.src = href + 'images/' + ((firstChildOfRoot) ? 'plus_no_root' : (showLines ? 'plus' : 'plus_nolines')) + '.gif';
		}
		else {
			actionimage.src = href + 'images/' + ((firstChildOfRoot) ? 'plus_last_no_root' : (showLines ? 'plus_last' : 'plus_nolines')) + '.gif';
		}
	}
}

function fireOpenEvent(treeNode) {
	if (treeNode.gotOpenEventListeners()) {
		for(var i=0;i<treeNode.openeventlisteners.length;i++) {
			treeNode.openeventlisteners[i](treeNode.getID());
		}
	}
}
function fireEditEvent(treeNode,newVal) {
	if (treeNode.gotEditEventListeners()) {
		for(var i=0;i<treeNode.editeventlisteners.length;i++) {
			treeNode.editeventlisteners[i](treeNode.getID(), escape(newVal));
		}
	}
}
function fireMoveEvent(treeNode,draggedNodeID,droppedOnNodeID) {
	if (treeNode.gotMoveEventListeners()) {
		for(var i=0;i<treeNode.moveeventlisteners.length;i++) {
			treeNode.moveeventlisteners[i](draggedNodeID, droppedOnNodeID);
		}
	}
}
/*function blurSelection() {
	if (selectedNode != null) {
		var oldNodeTitle = document.getElementById('title' + selectedNode);
		oldNodeTitle.className = 'treetitleselectedblured';
	}
}
function focusSelection() {
	if (selectedNode != null) {
		var oldNodeTitle = document.getElementById('title' + selectedNode);
		oldNodeTitle.className = 'treetitleselectedfocused';
	}
}*/
function getCookieVal (offset) {  
	var endstr = document.cookie.indexOf (";",offset);  
	if (endstr == -1) {
		endstr = document.cookie.length;
	}
	return unescape(document.cookie.substring(offset,endstr));
}
function getCookie (name) {  
	var arg = name + "=";
	var alen = arg.length;
	var clen = document.cookie.length;
	var i = 0;
	while (i < clen) {
		var j = i + alen;
		if (document.cookie.substring(i, j) == arg) {
			return getCookieVal(j);
		}
		i = document.cookie.indexOf(" ", i) + 1;
		if (i == 0) {
			break;
		}
	}
	return null;
}
function setCookie (name, value) {  
	var argv = setCookie.arguments;  
	var argc = setCookie.arguments.length;  
	var expires = (argc > 2) ? argv[2] : null;  
	var path = (argc > 3) ? argv[3] : null;  
	var domain = (argc > 4) ? argv[4] : null;  
	var secure = (argc > 5) ? argv[5] : false;  
	document.cookie = name + "=" + escape (value) + ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) + ((path == null) ? "" : ("; path=" + path)) + ((domain == null) ? "" : ("; domain=" + domain)) + ((secure == true) ? "; secure" : "");
}

/*function expandNode() {
	var state = getState(selectedNode);
	if (state == 'open') {
		var currentTreeNode = getTreeNode(selectedNode);
		if (currentTreeNode.hasChilds()) {
			currentTreeNode.childs[0].selectNode();
		}
	}
	else {
		getTreeNode(selectedNode).handleNode();
	}
}
function subtractNode() {
	var state = getState(selectedNode);
	if (state == 'closed') {
		var currentTreeNode = getTreeNode(selectedNode);
		var parent = currentTreeNode.getParent();
		if (parent != null && parent != rootNode) {
			parent.selectNode();
		}
	}
	else {
		getTreeNode(selectedNode).handleNode();
	}
}
function selectPrevNode() {
	var currentTreeNode = getTreeNode(selectedNode);
	if (currentTreeNode.prevSibling != null) {

		var state = getState(currentTreeNode.prevSibling.getID());

		if (state == 'open' && currentTreeNode.prevSibling.hasChilds()) {
			// We have to find the last open child of the previoussiblings childs.
			var current = currentTreeNode.prevSibling.childs[currentTreeNode.prevSibling.childs.length - 1];
			var currentstate = 'open';
			while (current.hasChilds() && (getState(current.getID()) == 'open')) {
				current = current.childs[current.childs.length - 1];
			}
			current.selectNode();
		}
		else {
			currentTreeNode.prevSibling.selectNode();
		}
	}
	else {
		if (currentTreeNode.getParent() != null && currentTreeNode.getParent() != rootNode) {
			currentTreeNode.getParent().selectNode();
		}
	}
}
function selectNextNode() {
	var currentTreeNode = getTreeNode(selectedNode);

	var state = getState(selectedNode);
	if (state == 'open' && currentTreeNode.hasChilds()) {
		currentTreeNode.childs[0].selectNode();
	}	
	else {
		if (currentTreeNode.nextSibling != null) {
			currentTreeNode.nextSibling.selectNode();
		}
		else {
			// Continue up the tree until we either hit null, or a parent which have a child.
			var parent = currentTreeNode;
			while ((parent = parent.getParent()) != rootNode) {
				if (parent.nextSibling != null) {
					parent.nextSibling.selectNode();
					break;
				}
			}
		}
	}
}
function keyDown(event) {
	if (window.event) {
		event = window.event;
	}
	if (event.keyCode == 38) { // Up
		selectPrevNode();
		return false;
	}
	else if (event.keyCode == 40) { // Down
		selectNextNode();
		return false;
	}
	else if (event.keyCode == 37) { // left
		subtractNode();
		return false;
	}
	else if (event.keyCode == 39) { // right
		expandNode();
		return false;
	}
}
document.onkeydown = keyDown; // !!!!
*/