/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.ws.axis2;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;


/**
 *
 * @author gtoffoli
 */
public class RepositoryHelper
 {
	protected static final Log log = LogFactory.getLog(RepositoryHelper.class);

    private EngineService engine;

    /**
     * Creates a new instance of RepositoryHelper
     */
    public RepositoryHelper(EngineService engine) {
    	this.engine = engine;
    }
    
    /**
     * Converts BigDecimal numbers to the the type they should be based on
     * what the JRParameters say.
     *
     * @todo add float and dobule
     *
     * @param reportUri the name of the report
     * @param currentParameters parameters to fic
     */
    public Map convertParameterValues(String reportUri, Map currentParameters)
    {
            Map parametersMap = new HashMap();

            JRReport report = engine.getMainJasperReport(null, reportUri);
            JRParameter[] parameters = report.getParameters();
            if (parameters != null)
            {
                    for(int i = 0; i < parameters.length; i++)
                    {
                            JRParameter parameter = parameters[i];
                            parametersMap.put(parameter.getName(), parameter);
                    }
            }

            
            for (Iterator i=currentParameters.keySet().iterator(); i.hasNext(); )
            {
                    String parameterName = ""+i.next();
                    
                    JRParameter parameter = (JRParameter)parametersMap.get(parameterName);
                    if (parameter != null)
                    {
                            Object value = currentParameters.get(parameterName);
                            if (value != null && value instanceof String)
                            {
                                value = stringToValue((String)value, parameter.getValueClass());
                            }
                            currentParameters.put(parameterName, value);
                    }
            }

            return currentParameters;
    }
    
    /**
     *  This method get a object and tries to convert it in a string
     *  Valid objects are:
     *    java.util.Date (converted in a string representing milliseconds)
     *    Number
     *    BigDecimal
     *    Byte
     *    Short
     *    Integer
     *    Long
     *    Float
     *    Double
     *    Boolean (will be the string true or false)
     *    String
     * 
     *  The default returned object is of type String
     * @param value The object to convert in a string
     * @return Return a string represeting the object
     */
    public String valueToString(Object value)
    {
        String str = (value == null) ? "" : ""+value;
        if (value != null && value instanceof java.util.Date)
        {
            str = "" + ((java.util.Date)value).getTime();
        }
        
        return str;
    }
    
    
    /**
     *  This method get a string and tries to convert the string into the requested object.
     *  Valid classes are:
     *    java.util.Date (the string is supposed to represent a number of milliseconds)
     *    Number
     *    BigDecimal
     *    Byte
     *    Short
     *    Integer
     *    Long
     *    Float
     *    Double
     *    Boolean
     *    String
     *    java.util.Locale
     * 
     *  The default returned object is of type String
     * @param str the string representing the value
     * @param clazz The class of the result (not garanteed)
     * @return return an Object hopefully of the requested class (or a String)
     * 
     */
    public Object stringToValue(String str, Class clazz)
    {
        Object value = str;
        if (value != null && java.util.Date.class.getName().equals(clazz.getName()))
        {

                value = new java.util.Date(Long.valueOf(value.toString()).longValue());
        }
        else if (value != null && Number.class.isAssignableFrom(clazz ))
        {
                value = new java.math.BigDecimal(value.toString());
                if (Byte.class.getName().equals(clazz.getName()))
                {
                        value = new Byte(((Number)value).byteValue());
                }
                else if (Short.class.getName().equals(clazz.getName()))
                {
                        value = new Short(((Number)value).shortValue());
                }
                else if (Integer.class.getName().equals(clazz.getName()))
                {
                        value = new Integer(((Number)value).intValue());
                }
                else if (Long.class.getName().equals(clazz.getName()))
                {
                        value = new Long(((Number)value).longValue());
                }
                else if (Float.class.getName().equals(clazz.getName()))
                {
                        value = new Float(((Number)value).floatValue());
                }
                else if (Double.class.getName().equals(clazz.getName()))
                {
                        value = new Double(((Double)value).longValue());
                }
        }
        else if (value != null && Boolean.class.getName().equals(clazz.getName()))
        {
                value = Boolean.valueOf(value.toString());
        }
        else if (value != null && Locale.class.getName().equals(clazz.getName()))
        {
        	value = LocaleHelper.getInstance().getLocale(str);
        }
        return value;
    }
    
    
}
