/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2;

import java.util.HashMap;
import java.util.Map;

import javax.activation.DataSource;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ResultAttachments.java 9304 2007-08-02 16:59:49Z lucian $
 */
public class ResultAttachments {

	private boolean encapsulationDime;
	private Map attachmentsData = new HashMap();
	
	public void addAttachment(String name, DataSource dataSource) {
		attachmentsData.put(name, dataSource);
	}
	
	public Map getAttachmentsData() {
		return attachmentsData;
	}
	
	public boolean isEncapsulationDime() {
		return encapsulationDime;
	}
	
	public void setEncapsulationDime(boolean encapsulationDime) {
		this.encapsulationDime = encapsulationDime;
	}

}
