/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.ws.axis2;

/**
 *
 * @author gtoffoli
 */
public class WSException extends java.lang.Exception {
    
    public static final int NO_ERROR = 0;
    public static final int GENERAL_ERROR = 1;
    public static final int GENERAL_ERROR2 = 2;
    public static final int REFERENCED_RESOURCE_NOT_FOUND = 3;
    public static final int EXPORT_ERROR = 4;
    public static final int FILL_ERROR = 5;
    public static final int GENERAL_REQUEST_ERROR = 6;
    
    private int errorCode = 0;
    
    /** Creates a new instance of WSException */
    public WSException(int code, String message) {
        super(message);
        this.errorCode = code;
    }
    
    public WSException(Exception e) {
    	this(GENERAL_ERROR, e.getMessage());
    }

    public int getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }
    
}
