/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2.repository;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceDataSource;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.WSException;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ContentResourceHandler.java 9948 2007-09-07 12:52:21Z lucian $
 */
public class ContentResourceHandler extends RepositoryResourceHandler {

	public Class getResourceType() {
		return ContentResource.class;
	}

	protected void doDescribe(Resource resource, ResourceDescriptor descriptor,
			Map arguments, RepositoryServiceContext serviceContext)
			throws WSException {
		ContentResource contentRes = (ContentResource) resource;
		descriptor.setWsType(ResourceDescriptor.TYPE_CONTENT_RESOURCE);
		descriptor.setResourceProperty(ResourceDescriptor.PROP_CONTENT_RESOURCE_TYPE, 
				contentRes.getFileType());
	}

	protected void updateResource(Resource resource,
			ResourceDescriptor descriptor,
			RepositoryServiceContext serviceContext) throws WSException {
		// TODO implement?
	}

	public void getAttachments(Resource resource, Map arguments,
			ResourceDescriptor descriptor, ResultAttachments attachments,
			RepositoryServiceContext serviceContext) {
		super.getAttachments(resource, arguments, descriptor, attachments,
				serviceContext);

		ContentResource contentRes = (ContentResource) resource;

		if (arguments.containsKey(Argument.NO_RESOURCE_DATA_ATTACHMENT)) {
			descriptor.setHasData(false);
		} else {
			// Retrieve resource data...
			descriptor.setHasData(true);

			addMainAttachment(descriptor, attachments, serviceContext);

			if (!arguments.containsKey(Argument.NO_SUBRESOURCE_DATA_ATTACHMENTS)) {
				addSubAttachments(contentRes, attachments, serviceContext);
			}
		}
	}

	protected void addMainAttachment(ResourceDescriptor descriptor,
			ResultAttachments attachments,
			RepositoryServiceContext serviceContext) {
		FileResourceData fileData = serviceContext.getRepository()
				.getContentResourceData(null, descriptor.getUriString());
		ResourceDataSource attachmentSource = new ResourceDataSource("",
				fileData);
		attachments.addAttachment("attachment", attachmentSource);
	}

	protected void addSubAttachments(ContentResource contentRes,
			ResultAttachments attachments,
			RepositoryServiceContext serviceContext) {
		if (contentRes.getFileType().equals(ContentResource.TYPE_HTML)) {
			List resources = contentRes.getResources();
			if (resources != null && !resources.isEmpty()) {
				for (Iterator it = resources.iterator(); it.hasNext();) {
					ContentResource subResource = (ContentResource) it.next();
					FileResourceData subData = serviceContext.getRepository()
							.getContentResourceData(null,
									subResource.getURIString());
					ResourceDataSource subAttachment = new ResourceDataSource(
							"", subData);
					attachments.addAttachment(subResource.getName(),
							subAttachment);
				}
			}
		}
	}

}
