/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2.repository;

import java.util.Map;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.WSException;

/**
 * @author gtoffoli
 * @version $Id: FolderHandler.java 9354 2007-08-06 14:47:57Z lucian $
 */
public class FolderHandler implements ResourceHandler {

	public Class getResourceType() {
		return Folder.class;
	}

	public ResourceDescriptor describe(Resource resource, Map arguments,
			RepositoryServiceContext serviceContext) {
		Folder folder = (Folder) resource;
		
		ResourceDescriptor descriptor = new ResourceDescriptor();
		descriptor.setWsType(ResourceDescriptor.TYPE_FOLDER);
		descriptor.setHasData(false);
		descriptor.setUriString(folder.getURIString());
		descriptor.setDescription(folder.getDescription());
		descriptor.setLabel(folder.getLabel());
		descriptor.setName(folder.getName());
		descriptor.setResourceType(folder.getResourceType());
		descriptor.setParentFolder(folder.getParentFolder());
		descriptor.setVersion(folder.getVersion());
		descriptor.setCreationDate(folder.getCreationDate());

		return descriptor;
	}

	public void put(ServiceRequest request) throws WSException {
		ResourceDescriptor descriptor = request.getRequestDescriptor();
		RepositoryService repository = request.getContext().getRepository();
		if (descriptor.getIsNew()) {
            Folder folder = new FolderImpl();
            folder.setName( descriptor.getName() );
            folder.setLabel( descriptor.getLabel() );
            folder.setDescription( descriptor.getDescription());
            folder.setParentFolder(descriptor.getParentFolder());
            folder.setVersion(Resource.VERSION_NEW);
            repository.saveFolder(null, folder);
            request.getResult().getResourceDescriptors().add(
            		request.getContext().createResourceDescriptor(folder.getURIString()));
		} else {
            Folder res = repository.getFolder(null, descriptor.getUriString());
            
            if (res != null)
            {
                if (res.getLabel() == null || !res.getLabel().equals( descriptor.getLabel()))
                {
                    res.setLabel( descriptor.getLabel() );
                }

                if (res.getDescription() == null ||  !res.getDescription().equals( descriptor.getDescription()))
                {
                    res.setDescription( descriptor.getDescription());
                }
                
                repository.saveFolder(null, res);
                request.getResult().addResourceDescriptor(
                		request.getContext().createResourceDescriptor(res));
            }
            else
            {
            	request.getResult().setReturnCode(2);
            	request.getResult().setMessage(request.getContext().getMessage("webservices.error.folderNotFound", null));
            }
		}
	}

	public void getAttachments(Resource resource, Map arguments,
			ResourceDescriptor descriptor,
			ResultAttachments attachments, RepositoryServiceContext serviceContext) {
		// nothing
	}

	public void delete(ResourceDescriptor descriptor,
			RepositoryServiceContext serviceContext) throws WSException {
        serviceContext.getRepository().deleteFolder(null, descriptor.getUriString());
	}
	
	
}
