/*
 // * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

import javax.naming.Context;
import javax.naming.InitialContext;

import net.sf.jasperreports.engine.JRParameter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.WSException;

/**
 * @author gtoffoli
 * @version $Id: InputControlHandler.java 9304 2007-08-02 16:59:49Z lucian $
 */
public class InputControlHandler extends RepositoryResourceHandler {

	public Class getResourceType() {
		return InputControl.class;
	}

	protected static final Log log = LogFactory
			.getLog(InputControlHandler.class);

	protected void doDescribe(Resource resource, ResourceDescriptor descriptor,
			Map arguments, RepositoryServiceContext serviceContext) throws WSException {
		InputControl fileResource = (InputControl) resource;
		descriptor.setWsType(ResourceDescriptor.TYPE_INPUT_CONTROL);
		descriptor.setHasData(false);
		descriptor.setIsReference(false);

		descriptor.setMandatory(fileResource.isMandatory());
		descriptor.setReadOnly(fileResource.isReadOnly());

		descriptor.setControlType(fileResource.getType());

		ResourceReference childReference = null;
		if (descriptor.getControlType() == ResourceDescriptor.IC_TYPE_SINGLE_VALUE) {
			childReference = fileResource.getDataType();
		} else if (descriptor.getControlType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_LIST_OF_VALUES
				|| descriptor.getControlType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_LIST_OF_VALUES_RADIO
				|| descriptor.getControlType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_LIST_OF_VALUES
				|| descriptor.getControlType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_LIST_OF_VALUES_CHECKBOX) {
			childReference = fileResource.getListOfValues();
		} else if (descriptor.getControlType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_QUERY
				|| descriptor.getControlType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_QUERY_RADIO
				|| descriptor.getControlType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_QUERY
				|| descriptor.getControlType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_QUERY_CHECKBOX) {
			log.info("Adding query and columns: "
					+ fileResource.getQueryValueColumn());
			childReference = fileResource.getQuery();
			descriptor.setQueryValueColumn(fileResource.getQueryValueColumn());
			descriptor.setQueryVisibleColumns(fileResource
					.getQueryVisibleColumns());
		}

		if (childReference != null) {
			ResourceDescriptor childRd = null;

			if (childReference.isLocal()) {
				childRd = serviceContext
						.createResourceDescriptor(childReference
								.getLocalResource());
			} else {
				// childRd =
				// getResourceDescriptor(childReference.getReferenceLookup().getURIString());
				childRd = new ResourceDescriptor();
				childRd.setWsType(ResourceDescriptor.TYPE_REFERENCE);
				childRd.setReferenceUri(childReference.getReferenceURI());
			}

			if (childRd != null) {
				descriptor.getChildren().add(childRd);
			}
		}

		if (arguments != null
				&& arguments.containsKey(Argument.IC_GET_QUERY_DATA)) {
			// get the datasource against wich get the query data...
			String dsUri = (String) arguments.get(Argument.IC_GET_QUERY_DATA);

			java.util.List data = getInputControlItems(fileResource, dsUri,
					serviceContext);

			descriptor.setQueryData(data);
		}
	}

	/*
	 * execute a query against a named datasource to get the data for an
	 * InputControl. Returns a list of InputControlQueryDataRow
	 * 
	 */
	protected java.util.List getInputControlItems(InputControl control,
			String datasourceUri, RepositoryServiceContext serviceContext)
			throws JSException {

		java.util.List list = new java.util.ArrayList();
		Connection connection = null;
		Query query = null;
		ResourceReference queryRef = control.getQuery();
		if (queryRef.isLocal())
			query = (Query) queryRef.getLocalResource();
		else
			query = (Query) serviceContext.getRepository().getResource(null,
					queryRef.getReferenceURI());

		// FIXME use EngineService.executeQuery

		// if (datasourceUri == null) return list;

		Resource dataSource = null;

		if (datasourceUri != null && datasourceUri.trim().length() > 0) {
			dataSource = serviceContext.getRepository().getResource(null,
					datasourceUri);
		} else {
			ResourceReference rf = query.getDataSource();
			if (rf.isLocal()) {
				dataSource = rf.getLocalResource();
			} else {
				dataSource = serviceContext.getRepository().getResource(
						null, rf.getReferenceURI());
			}
		}

		if (dataSource == null) {
			// Unable to find the resource datasourceUri
			log.error("Unable to find the datasource " + datasourceUri);
		}

		try {
			if (dataSource instanceof JdbcReportDataSource) {
				HashMap paramValues = new HashMap();

				serviceContext.getEngine().createDataSourceService(
						(ReportDataSource) dataSource)
						.setReportParameterValues(paramValues);
				connection = (Connection) paramValues
						.get(JRParameter.REPORT_CONNECTION);
			} else if (dataSource instanceof JndiJdbcReportDataSource) {
				JndiJdbcReportDataSource jndiDs = (JndiJdbcReportDataSource) dataSource;

				Context ctx = new InitialContext();
				javax.sql.DataSource sqlDs = (javax.sql.DataSource) ctx
						.lookup("java:comp/env/" + jndiDs.getJndiName());
				connection = sqlDs.getConnection();
			}

		} catch (Exception ex) {
			log.error(ex);
			throw new JSException(ex);
		}

		if (connection != null) {
			PreparedStatement st = null;
			ResultSet rs = null;

			try {

				st = connection.prepareStatement(query.getSql());

				rs = st.executeQuery();

				while (rs.next()) {

					InputControlQueryDataRow ic = new InputControlQueryDataRow();

					Object valueColumn = rs.getObject(control
							.getQueryValueColumn());
					String[] queryVisibleColumns = control
							.getQueryVisibleColumns();
					String[] visibleColumnsValues = new String[queryVisibleColumns.length];
					for (int i = 0; i < visibleColumnsValues.length; i++)
						visibleColumnsValues[i] = rs
								.getString(queryVisibleColumns[i]);
					// StringBuffer visibleColumns = new
					// StringBuffer(visibleColumnsValues[0] != null ?
					// visibleColumnsValues[0] : "");
					for (int i = 0; i < visibleColumnsValues.length; i++)
						ic
								.getColumnValues()
								.add(
										visibleColumnsValues[i] != null ? visibleColumnsValues[i]
												: "");

					ic.setValue(valueColumn);
					list.add(ic);

				}
			} catch (Throwable ex) {
				log.error(ex);
				throw new JSException(ex);

			} finally {
				if (rs != null)
					try {
						rs.close();
					} catch (Exception e) {
					}
				if (st != null)
					try {
						st.close();
					} catch (Exception e) {
					}
				try {
					connection.close();
				} catch (Exception e) {
				}
			}
		}
		return list;
	}

	protected void updateResource(Resource resource,
			ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
		InputControl inputControl = (InputControl) resource;

		inputControl.setMandatory(descriptor.isMandatory());
		inputControl.setReadOnly(descriptor.isReadOnly());
		inputControl.setType(descriptor.getControlType());

		// Look in children...
		if (inputControl.getType() == ResourceDescriptor.IC_TYPE_SINGLE_VALUE) {
			// We have to set the datatype...
			if (descriptor.getChildren().size() == 0) {
				throw new WSException(WSException.GENERAL_ERROR2,
						serviceContext.getMessage(
								"webservices.error.missingDataType", null));
			}
			ResourceDescriptor rd = (ResourceDescriptor) descriptor
					.getChildren().get(0);
			if (rd.getWsType().equals(ResourceDescriptor.TYPE_REFERENCE)) {
				inputControl.setDataTypeReference(rd.getReferenceUri());
			} else {
				DataType dataType = (DataType) toChildResource(rd, serviceContext);
				inputControl.setDataType(dataType);
			}
		}
		// Look in children...
		else if (inputControl.getType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_LIST_OF_VALUES
				|| inputControl.getType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_LIST_OF_VALUES_RADIO
				|| inputControl.getType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_LIST_OF_VALUES
				|| inputControl.getType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_LIST_OF_VALUES_CHECKBOX) {

			// We have to set the datatype...
			if (descriptor.getChildren().size() == 0) {
				throw new WSException(WSException.GENERAL_ERROR2,
						serviceContext.getMessage(
								"webservices.error.missingLOV", null));
			}
			ResourceDescriptor rd = (ResourceDescriptor) descriptor
					.getChildren().get(0);
			if (rd.getWsType().equals(ResourceDescriptor.TYPE_REFERENCE)) {
				inputControl.setListOfValuesReference(rd.getReferenceUri());
			} else {
				ListOfValues lovResource = (ListOfValues) toChildResource(rd, serviceContext);
				inputControl.setListOfValues(lovResource);
			}
		} else if (inputControl.getType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_QUERY
				|| inputControl.getType() == ResourceDescriptor.IC_TYPE_SINGLE_SELECT_QUERY_RADIO
				|| inputControl.getType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_QUERY
				|| inputControl.getType() == ResourceDescriptor.IC_TYPE_MULTI_SELECT_QUERY_CHECKBOX) {

			// We have to set the datatype...
			if (descriptor.getChildren().size() == 0) {
				throw new WSException(WSException.GENERAL_ERROR2,
						serviceContext.getMessage(
								"webservices.error.missingQuery", null));
			}
			ResourceDescriptor rd = (ResourceDescriptor) descriptor
					.getChildren().get(0);

			inputControl.setQueryValueColumn(descriptor.getQueryValueColumn());
			String[] visibleColumns = descriptor.getQueryVisibleColumns();

			// remove all old visible columns first...
			String[] oldColumns = inputControl.getQueryVisibleColumns();
			if (oldColumns != null) {
				for (int i = 0; i < oldColumns.length; ++i) {
					inputControl.removeQueryVisibleColumn(oldColumns[i]);
				}
			}

			for (int i = 0; i < visibleColumns.length; ++i) {
				inputControl.addQueryVisibleColumn(visibleColumns[i]);
			}

			if (rd.getWsType().equals(ResourceDescriptor.TYPE_REFERENCE)) {
				inputControl.setQueryReference(rd.getReferenceUri());
			} else {
				Query queryResource = (Query) toChildResource(rd, serviceContext);
				inputControl.setQuery(queryResource);
			}
		}
	}

}
