-- Copyright (C) 2005 - 2006 JasperSoft Corporation. All rights reserved.
-- http://www.jaspersoft.com.
-- Licensed under commercial JasperSoft Subscription License Agreement

-- $Id: jasperserverCreateDefaultSecurity-oracle.sql,v 1.1 2006/11/03 12:01:58 pieter Exp $
        

INSERT INTO JIRole (id, rolename,externallyDefined) VALUES (nextval('hibernate_sequence'), 'ROLE_USER',false);
INSERT INTO JIRole (id, rolename,externallyDefined) VALUES (nextval('hibernate_sequence'), 'ROLE_ADMINISTRATOR',false);
INSERT INTO JIRole (id, rolename,externallyDefined) VALUES (nextval('hibernate_sequence'), 'ROLE_ANONYMOUS',false);

INSERT INTO JIUser (id, username,fullname,emailAddress,password,externallyDefined,enabled) VALUES
 (nextval('hibernate_sequence'),'anonymousUser','Anonymous User',NULL,'',false,true);
 
INSERT INTO JIUserRole (userId,roleId)
 select u.id, r.id from JIUser u, JIRole r where u.username = 'anonymousUser' and r.roleName = 'ROLE_ANONYMOUS';

INSERT INTO JIUser (id, username,fullname,emailAddress,password,externallyDefined,enabled) VALUES
 (nextval('hibernate_sequence'), 'jasperadmin','Jasper Administrator',NULL,'password',false,true);

INSERT INTO JIUserRole (userId,roleId)
select u.id, r.id from JIUser u, JIRole r where u.username = 'jasperadmin' and r.roleName = 'ROLE_ADMINISTRATOR';

INSERT INTO JIUserRole (userId,roleId)
select u.id, r.id from JIUser u, JIRole r where u.username = 'jasperadmin' and r.roleName = 'ROLE_USER';

INSERT INTO JIResourceFolder (id,version,uri,hidden,name,label,description,parent_folder,creation_date) VALUES 
 (nextval('hibernate_sequence'),0,'/',false,'/','root','Root of the folder hierarchy',NULL,current_date);

INSERT INTO JIObjectPermission (id, uri,recipientobjectclass,permissionMask,recipientobjectid)
select nextval('hibernate_sequence'), 'repo:/','com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole', 1, r.id
from JIRole r where rolename = 'ROLE_ADMINISTRATOR';

INSERT INTO JIObjectPermission (id, uri,recipientobjectclass,permissionMask,recipientobjectid)
select nextval('hibernate_sequence'), 'repo:/','com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole', 2, r.id
from JIRole r where rolename = 'ROLE_USER';
