/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.util.ArrayList;

public class PdfPTable
implements Element {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentRowIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("The widths array in PdfPTable constructor can not be null.");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The widths array in PdfPTable constructor can not have zero length.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of columns in PdfPTable constructor must be greater than zero.");
        }
        this.relativeWidths = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.relativeWidths[n2] = 1.0f;
            ++n2;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(PdfPTable pdfPTable) {
        this.relativeWidths = new float[pdfPTable.relativeWidths.length];
        this.absoluteWidths = new float[pdfPTable.relativeWidths.length];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.relativeWidths.length);
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.relativeWidths.length);
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = pdfPTable.currentRowIdx;
        this.tableEvent = pdfPTable.tableEvent;
        this.runDirection = pdfPTable.runDirection;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        int n = 0;
        while (n < this.currentRow.length) {
            if (pdfPTable.currentRow[n] == null) break;
            this.currentRow[n] = new PdfPCell(pdfPTable.currentRow[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < pdfPTable.rows.size()) {
            this.rows.add(new PdfPRow((PdfPRow)pdfPTable.rows.get(n2)));
            ++n2;
        }
    }

    public void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            fArray[n] = nArray[n];
            ++n;
        }
        this.setWidths(fArray);
    }

    private void calculateWidths() {
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f = 0.0f;
        int n = 0;
        while (n < this.absoluteWidths.length) {
            f += this.relativeWidths[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.absoluteWidths.length) {
            this.absoluteWidths[n2] = this.totalWidth * this.relativeWidths[n2] / f;
            ++n2;
        }
    }

    public void setTotalWidth(float f) {
        if (this.totalWidth == f) {
            return;
        }
        this.totalWidth = f;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    void calculateHeights() {
        if (this.totalWidth <= 0.0f) {
            return;
        }
        this.totalHeight = 0.0f;
        int n = 0;
        while (n < this.rows.size()) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
            pdfPRow.setWidths(this.absoluteWidths);
            this.totalHeight += pdfPRow.getMaxHeights();
            ++n;
        }
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        int n;
        PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
        int n2 = pdfPCell2.getColspan();
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2, this.currentRow.length - this.currentRowIdx);
        pdfPCell2.setColspan(n2);
        if (n2 != 1) {
            this.isColspan = true;
        }
        if ((n = pdfPCell2.getRunDirection()) == 0) {
            pdfPCell2.setRunDirection(this.runDirection);
        }
        this.currentRow[this.currentRowIdx] = pdfPCell2;
        this.currentRowIdx += n2;
        if (this.currentRowIdx >= this.currentRow.length) {
            Object object;
            if (this.runDirection == 3) {
                object = new PdfPCell[this.absoluteWidths.length];
                int n3 = this.currentRow.length;
                int n4 = 0;
                while (n4 < this.currentRow.length) {
                    PdfPCell pdfPCell3 = this.currentRow[n4];
                    int n5 = pdfPCell3.getColspan();
                    object[n3 -= n5] = pdfPCell3;
                    n4 += n5 - 1;
                    ++n4;
                }
                this.currentRow = object;
            }
            object = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                ((PdfPRow)object).setWidths(this.absoluteWidths);
                this.totalHeight += ((PdfPRow)object).getMaxHeights();
            }
            this.rows.add(object);
            this.currentRow = new PdfPCell[this.absoluteWidths.length];
            this.currentRowIdx = 0;
        }
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.setTable(pdfPTable);
        this.addCell(this.defaultCell);
        this.defaultCell.setTable(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        this.addCell(this.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        Object object;
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException("The table width must be greater than zero.");
        }
        int n3 = this.rows.size();
        if (n2 < 0) {
            n2 = n3;
        }
        if (n >= n3 || n >= n2) {
            return f2;
        }
        n2 = Math.min(n2, n3);
        float f3 = f2;
        int n4 = n;
        while (n4 < n2) {
            object = (PdfPRow)this.rows.get(n4);
            ((PdfPRow)object).writeCells(f, f2, pdfContentByteArray);
            f2 -= ((PdfPRow)object).getMaxHeights();
            ++n4;
        }
        if (this.tableEvent != null) {
            object = new float[n2 - n + 1];
            object[0] = f3;
            int n5 = n;
            while (n5 < n2) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(n5);
                object[n5 - n + 1] = object[n5 - n] - pdfPRow.getMaxHeights();
                ++n5;
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(f, n, n2, false), (float[])object, 0, n, pdfContentByteArray);
        }
        return f2;
    }

    public float writeSelectedRows(int n, int n2, float f, float f2, PdfContentByte pdfContentByte) {
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        float f3 = this.writeSelectedRows(n, n2, f, f2, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        return f3;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n) {
        if (this.totalWidth <= 0.0f || n < 0 || n >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
        return pdfPRow.getMaxHeights();
    }

    public float getHeaderHeight() {
        float f = 0.0f;
        int n = Math.min(this.rows.size(), this.headerRows);
        int n2 = 0;
        while (n2 < n) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
            f += pdfPRow.getMaxHeights();
            ++n2;
        }
        return f;
    }

    public boolean deleteRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n);
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n) {
        if (n < 0) {
            n = 0;
        }
        this.headerRows = n;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public int type() {
        return 23;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f) {
        this.widthPercentage = f;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    PdfPRow getRow(int n) {
        return (PdfPRow)this.rows.get(n);
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        this.tableEvent = pdfPTableEvent;
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float f, int n, int n2, boolean bl) {
        float[][] fArrayArray = new float[(bl ? this.headerRows : 0) + n2 - n][];
        if (this.isColspan) {
            int n3 = 0;
            if (bl) {
                int n4 = 0;
                while (n4 < this.headerRows) {
                    fArrayArray[n3++] = ((PdfPRow)this.rows.get(n4)).getEventWidth(f);
                    ++n4;
                }
            }
            while (n < n2) {
                fArrayArray[n3++] = ((PdfPRow)this.rows.get(n)).getEventWidth(f);
                ++n;
            }
        } else {
            float[] fArray = new float[this.absoluteWidths.length + 1];
            fArray[0] = f;
            int n5 = 0;
            while (n5 < this.absoluteWidths.length) {
                fArray[n5 + 1] = fArray[n5] + this.absoluteWidths[n5];
                ++n5;
            }
            int n6 = 0;
            while (n6 < fArrayArray.length) {
                fArrayArray[n6] = fArray;
                ++n6;
            }
        }
        return fArrayArray;
    }

    public boolean getSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public void setSkipFirstHeader(boolean bl) {
        this.skipFirstHeader = bl;
    }

    public void setRunDirection(int n) {
        if (n < 0 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }
}

