/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.axis.AxisConstants;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotNotCompatibleException;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ObjectUtils;

public abstract class Axis
implements AxisConstants,
Serializable {
    private boolean visible;
    private String label;
    private Font labelFont;
    private transient Paint labelPaint;
    private Insets labelInsets;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private transient Paint tickLabelPaint;
    private Insets tickLabelInsets;
    private boolean tickMarksVisible;
    private float tickMarkInsideLength;
    private float tickMarkOutsideLength;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint;
    private transient List ticks;
    private transient Plot plot;
    private double fixedDimension;
    private transient EventListenerList listenerList;
    static /* synthetic */ Class class$org$jfree$chart$event$AxisChangeListener;

    protected Axis(String string) {
        this.label = string;
        this.visible = true;
        this.labelFont = AxisConstants.DEFAULT_AXIS_LABEL_FONT;
        this.labelPaint = AxisConstants.DEFAULT_AXIS_LABEL_PAINT;
        this.labelInsets = AxisConstants.DEFAULT_AXIS_LABEL_INSETS;
        this.tickLabelsVisible = true;
        this.tickLabelFont = AxisConstants.DEFAULT_TICK_LABEL_FONT;
        this.tickLabelPaint = AxisConstants.DEFAULT_TICK_LABEL_PAINT;
        this.tickLabelInsets = AxisConstants.DEFAULT_TICK_LABEL_INSETS;
        this.tickMarksVisible = true;
        this.tickMarkStroke = AxisConstants.DEFAULT_TICK_MARK_STROKE;
        this.tickMarkPaint = AxisConstants.DEFAULT_TICK_MARK_PAINT;
        this.tickMarkInsideLength = 0.0f;
        this.tickMarkOutsideLength = 2.0f;
        this.plot = null;
        this.ticks = new ArrayList();
        this.listenerList = new EventListenerList();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        if (string2 != null) {
            if (!string2.equals(string)) {
                this.label = string;
                this.notifyListeners(new AxisChangeEvent(this));
            }
        } else if (string != null) {
            this.label = string;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setLabelFont(...): null not permitted.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (bl != this.tickLabelsVisible) {
            this.tickLabelsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setTickLabelFont(...): null not permitted.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickLabelPaint(...): null not permitted.");
        }
        if (!this.tickLabelPaint.equals(paint)) {
            this.tickLabelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Axis.setTickLabelInsets(...): null not permitted.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean bl) {
        if (bl != this.tickMarksVisible) {
            this.tickMarksVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public float getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(float f) {
        this.tickMarkInsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(float f) {
        this.tickMarkOutsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Axis.setTickMarkStroke(...): null not permitted.");
        }
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickMarkPaint(...): null not permitted.");
        }
        if (!this.tickMarkPaint.equals(paint)) {
            this.tickMarkPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public List getTicks() {
        return this.ticks;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) throws PlotNotCompatibleException {
        if (!this.isCompatiblePlot(plot) && plot != null) {
            throw new PlotNotCompatibleException("Axis.setPlot(...): plot not compatible with axis.");
        }
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double d) {
        this.fixedDimension = d;
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, Rectangle2D var3, int var4);

    public abstract void refreshTicks(Graphics2D var1, Rectangle2D var2, Rectangle2D var3, int var4);

    public abstract void configure();

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
            if (!(rectangle2D2.getWidth() > d)) continue;
            d = rectangle2D2.getWidth();
        }
        return d;
    }

    protected abstract boolean isCompatiblePlot(Plot var1);

    public void addChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$AxisChangeListener == null ? (class$org$jfree$chart$event$AxisChangeListener = Axis.class$("org.jfree.chart.event.AxisChangeListener")) : class$org$jfree$chart$event$AxisChangeListener, axisChangeListener);
    }

    public void removeChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$AxisChangeListener == null ? (class$org$jfree$chart$event$AxisChangeListener = Axis.class$("org.jfree.chart.event.AxisChangeListener")) : class$org$jfree$chart$event$AxisChangeListener, axisChangeListener);
    }

    protected void notifyListeners(AxisChangeEvent axisChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$jfree$chart$event$AxisChangeListener == null ? Axis.class$("org.jfree.chart.event.AxisChangeListener") : class$org$jfree$chart$event$AxisChangeListener)) {
                ((AxisChangeListener)objectArray[n + 1]).axisChanged(axisChangeEvent);
            }
            n -= 2;
        }
    }

    protected double drawHorizontalLabel(String string, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n, double d) {
        if (string == null || string.equals("")) {
            return d;
        }
        Font font = this.getLabelFont();
        Insets insets = this.getLabelInsets();
        graphics2D.setFont(font);
        graphics2D.setPaint(this.getLabelPaint());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        d = n == 0 ? d + (double)insets.top + (double)lineMetrics.getAscent() : d - (double)insets.bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
        float f = 0.0f;
        int n2 = 0;
        switch (n2) {
            case 2: {
                f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0);
                break;
            }
            case 4: {
                f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - rectangle2D3.getWidth());
                break;
            }
            default: {
                f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            }
        }
        float f2 = (float)d;
        graphics2D.drawString(string, f, f2);
        d = n == 0 ? d + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading() + (double)insets.bottom : d - (double)insets.top - (double)lineMetrics.getAscent();
        return d;
    }

    protected void drawVerticalLabel(String string, boolean bl, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (string != null && !string.equals("")) {
            Font font = this.getLabelFont();
            Insets insets = this.getLabelInsets();
            graphics2D.setFont(font);
            graphics2D.setPaint(this.getLabelPaint());
            Rectangle2D rectangle2D3 = font.getStringBounds(string, graphics2D.getFontRenderContext());
            if (n == 3) {
                if (bl) {
                    double d = rectangle2D.getX() + (double)insets.left + rectangle2D3.getHeight();
                    double d2 = rectangle2D.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                    RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d), (float)((float)d2), (double)-1.5707963267948966);
                } else {
                    double d = rectangle2D.getX() + (double)insets.left;
                    double d3 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle2D3.getHeight() / 2.0;
                    graphics2D.drawString(string, (float)d, (float)d3);
                }
            } else if (bl) {
                double d = rectangle2D.getMaxX() - (double)insets.right - rectangle2D3.getHeight();
                double d4 = rectangle2D.getMinY() + rectangle2D2.getHeight() / 2.0 - rectangle2D3.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d), (float)((float)d4), (double)1.5707963267948966);
            } else {
                double d = rectangle2D.getMaxX() - (double)insets.right - rectangle2D3.getWidth();
                double d5 = rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0 + rectangle2D3.getHeight() / 2.0;
                graphics2D.drawString(string, (float)d, (float)d5);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Axis) {
            Axis axis = (Axis)object;
            boolean bl = this.visible == axis.visible;
            boolean bl2 = ObjectUtils.equalOrBothNull((Object)this.label, (Object)axis.label);
            boolean bl3 = ObjectUtils.equalOrBothNull((Object)this.labelFont, (Object)axis.labelFont);
            boolean bl4 = ObjectUtils.equalOrBothNull((Object)this.labelPaint, (Object)axis.labelPaint);
            boolean bl5 = ObjectUtils.equalOrBothNull((Object)this.labelInsets, (Object)axis.labelInsets);
            boolean bl6 = this.tickLabelsVisible == axis.tickLabelsVisible;
            boolean bl7 = ObjectUtils.equalOrBothNull((Object)this.tickLabelFont, (Object)axis.tickLabelFont);
            boolean bl8 = ObjectUtils.equalOrBothNull((Object)this.tickLabelPaint, (Object)axis.tickLabelPaint);
            boolean bl9 = ObjectUtils.equalOrBothNull((Object)this.tickLabelInsets, (Object)axis.tickLabelInsets);
            boolean bl10 = this.tickMarksVisible == axis.tickMarksVisible;
            boolean bl11 = this.tickMarkInsideLength == axis.tickMarkInsideLength;
            boolean bl12 = this.tickMarkOutsideLength == axis.tickMarkOutsideLength;
            boolean bl13 = ObjectUtils.equalOrBothNull((Object)this.tickMarkPaint, (Object)axis.tickMarkPaint);
            boolean bl14 = ObjectUtils.equalOrBothNull((Object)this.tickMarkStroke, (Object)axis.tickMarkStroke);
            boolean bl15 = this.fixedDimension == axis.fixedDimension;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.labelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.tickLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.tickMarkStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.tickMarkPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.labelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.tickMarkStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.tickMarkPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.listenerList = new EventListenerList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

