/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.data.Range;

public abstract class NumberAxis
extends ValueAxis
implements Serializable {
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    private boolean autoRangeIncludesZero = true;
    private boolean autoRangeStickyZero = true;
    private NumberTickUnit tickUnit = DEFAULT_TICK_UNIT;
    private NumberFormat numberFormatOverride = null;

    protected NumberAxis(String string) {
        super(string, NumberAxis.createStandardTickUnits());
    }

    public boolean autoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl) {
        if (this.autoRangeIncludesZero != bl) {
            this.autoRangeIncludesZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl) {
        if (this.autoRangeStickyZero != bl) {
            this.autoRangeStickyZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double calculateLowestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.getRange().getLowerBound() / d);
        return d2 * d;
    }

    public double calculateHighestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.floor(this.getRange().getUpperBound() / d);
        return d2 * d;
    }

    public int calculateVisibleTickCount() {
        double d = this.getTickUnit().getSize();
        Range range = this.getRange();
        return (int)(Math.floor(range.getUpperBound() / d) - Math.ceil(range.getLowerBound() / d) + 1.0);
    }

    public static TickUnits createStandardTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(1.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(1.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(1.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.001, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.01, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.1, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E-7, new DecimalFormat("0.00000000")));
        tickUnits.add(new NumberTickUnit(2.5E-6, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(2.5E-5, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(2.5E-4, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(0.0025, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.025, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.25, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(2.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(25.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(250.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2500.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(25000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(250000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2500000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(5.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(5.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(5.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.005, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.05, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,###,###,##0")));
        return tickUnits;
    }

    public static TickUnits createIntegerTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(20.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(200.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(20000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(200000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,##0")));
        return tickUnits;
    }

    public static TickUnits createStandardTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.001, numberFormat));
        tickUnits.add(new NumberTickUnit(0.01, numberFormat));
        tickUnits.add(new NumberTickUnit(0.1, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.0025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.25, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5, numberFormat));
        tickUnits.add(new NumberTickUnit(25.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(25000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.005, numberFormat));
        tickUnits.add(new NumberTickUnit(0.05, numberFormat));
        tickUnits.add(new NumberTickUnit(0.5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        return tickUnits;
    }

    public static TickUnits createIntegerTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E10, numberFormat));
        return tickUnits;
    }
}

