/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.VerticalAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.HorizontalCategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.CategoryDataset;

public class VerticalCategoryAxis
extends CategoryAxis
implements VerticalAxis,
Serializable {
    public static final boolean DEFAULT_VERTICAL_LABEL = true;
    private boolean verticalLabel = true;

    public VerticalCategoryAxis(String string) {
        super(string);
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean bl) {
        if (this.verticalLabel != bl) {
            this.verticalLabel = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D) {
        double d = rectangle2D.getMinY() + rectangle2D.getHeight() * this.getLowerMargin();
        double d2 = this.calculateCategoryHeight(n2, rectangle2D);
        double d3 = this.calculateCategoryGapHeight(n2, rectangle2D);
        return d += (double)n * (d2 + d3);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D) {
        return this.getCategoryStart(n, n2, rectangle2D) + this.calculateCategoryHeight(n2, rectangle2D) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D) {
        return this.getCategoryStart(n, n2, rectangle2D) + this.calculateCategoryHeight(n2, rectangle2D);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (!this.isVisible()) {
            return;
        }
        this.drawVerticalLabel(this.getLabel(), this.isVerticalLabel(), graphics2D, rectangle2D, rectangle2D2, n);
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            graphics2D.setPaint(this.getTickLabelPaint());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n2 = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            Iterator iterator = categoryDataset.getColumnKeys().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                f = n == 3 ? (float)(rectangle2D2.getX() - (double)this.getTickLabelInsets().right - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxX() + (double)this.getTickLabelInsets().left);
                f2 = (float)(this.getCategoryMiddle(n2, categoryDataset.getColumnCount(), rectangle2D2) - (double)lineMetrics.getStrikethroughOffset() + 0.5);
                Tick tick = new Tick(e, string, f, f2);
                this.getTicks().add(tick);
                ++n2;
            }
        }
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        Cloneable cloneable;
        if (!this.isVisible()) {
            return 0.0;
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            cloneable = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = insets.left + insets.right;
            d = this.verticalLabel ? (d += ((RectangularShape)cloneable).getHeight()) : (d += ((RectangularShape)cloneable).getWidth());
        }
        cloneable = this.getTickLabelInsets();
        double d2 = ((Insets)cloneable).left + ((Insets)cloneable).right;
        if (this.isTickLabelsVisible()) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d2 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return d + d2;
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        Cloneable cloneable;
        if (!this.isVisible()) {
            return 0.0;
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            cloneable = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d2 = insets.left + insets.right;
            d2 = this.verticalLabel ? (d2 += ((RectangularShape)cloneable).getHeight()) : (d2 += ((RectangularShape)cloneable).getWidth());
        }
        cloneable = this.getTickLabelInsets();
        double d3 = ((Insets)cloneable).left + ((Insets)cloneable).right;
        if (this.isTickLabelsVisible()) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d3 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return d2 + d3;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalCategoryPlot;
    }

    public void configure() {
    }

    private double calculateCategoryHeight(int n, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (n > 1) {
            d = rectangle2D.getHeight() * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d /= (double)n;
        } else {
            d = rectangle2D.getHeight() * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d;
    }

    private double calculateCategoryGapHeight(int n, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (n > 1) {
            d = rectangle2D.getHeight() * this.getCategoryMargin() / (double)(n - 1);
        }
        return d;
    }
}

