/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.needle;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.needle.MeterNeedle;

public class ArrowNeedle
extends MeterNeedle
implements Serializable {
    private boolean isArrowAtTop = true;

    public ArrowNeedle(boolean bl) {
        this.isArrowAtTop = bl;
    }

    protected void drawNeedle(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d) {
        Line2D.Float float_ = new Line2D.Float();
        Shape shape = null;
        float f = (float)(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0);
        float f2 = (float)rectangle2D.getMinY();
        float f3 = (float)rectangle2D.getMaxY();
        ((Line2D)float_).setLine(f, f2, f, f3);
        GeneralPath generalPath = new GeneralPath();
        if (this.isArrowAtTop) {
            generalPath.moveTo(f, f2);
            f2 += (float)(4 * this.getSize());
        } else {
            generalPath.moveTo(f, f3);
            f2 = f3 - (float)(4 * this.getSize());
        }
        generalPath.lineTo(f + (float)this.getSize(), f2);
        generalPath.lineTo(f - (float)this.getSize(), f2);
        generalPath.closePath();
        if (point2D != null && d != 0.0) {
            this.getTransform().setToRotation(d, point2D.getX(), point2D.getY());
            shape = this.getTransform().createTransformedShape(float_);
        } else {
            shape = float_;
        }
        this.defaultDisplay(graphics2D, shape);
        shape = point2D != null && d != 0.0 ? this.getTransform().createTransformedShape(generalPath) : generalPath;
        this.defaultDisplay(graphics2D, shape);
    }
}

