/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ClipPath;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.Marker;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.AxisNotCompatibleException;
import org.jfree.chart.axis.ColorBarAxis;
import org.jfree.chart.axis.HorizontalAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.VerticalAxis;
import org.jfree.chart.entity.ContourEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.ContourValuePlot;
import org.jfree.chart.plot.HorizontalValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotNotCompatibleException;
import org.jfree.chart.plot.VerticalValuePlot;
import org.jfree.chart.tooltips.ContourToolTipGenerator;
import org.jfree.chart.tooltips.StandardContourToolTipGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.ContourDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultContourDataset;
import org.jfree.data.Range;

public class ContourPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot,
ContourValuePlot,
PropertyChangeListener,
Serializable {
    protected static final Insets DEFAULT_INSETS = new Insets(2, 2, 100, 10);
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private NumberAxis colorBar = null;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private List domainMarkers;
    private List rangeMarkers;
    private List annotations;
    private ContourToolTipGenerator toolTipGenerator;
    private XYURLGenerator urlGenerator;
    private boolean renderAsPoints = false;
    private double ptSizePct = 0.05;
    private transient ClipPath clipPath = null;
    private transient Paint missingPaint = null;

    public ContourPlot(ContourDataset contourDataset, ValueAxis valueAxis, ValueAxis valueAxis2, NumberAxis numberAxis) {
        super(contourDataset);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.colorBar = numberAxis;
        if (numberAxis != null) {
            numberAxis.setPlot(this);
            numberAxis.addChangeListener(this);
        }
        this.toolTipGenerator = new StandardContourToolTipGenerator();
    }

    public ContourDataset getContourDataset() {
        return (ContourDataset)this.getDataset();
    }

    public ValueAxis getDomainAxis() {
        ValueAxis valueAxis = this.domainAxis;
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setDomainAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueAxis getRangeAxis() {
        ValueAxis valueAxis = this.rangeAxis;
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setColorBarAxis(NumberAxis numberAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleColorBarAxis(numberAxis)) {
            if (numberAxis != null) {
                try {
                    numberAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setColorBarAxis(...): plot not compatible with axis.");
                }
                numberAxis.addChangeListener(this);
            }
            if (this.colorBar != null) {
                this.colorBar.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setColorBarAxis(...): axis not compatible with plot.");
        }
        this.colorBar = numberAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        if (this.domainMarkers == null) {
            this.domainMarkers = new ArrayList();
        }
        this.domainMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers() {
        if (this.domainMarkers != null) {
            this.domainMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addRangeMarker(Marker marker) {
        if (this.rangeMarkers == null) {
            this.rangeMarkers = new ArrayList();
        }
        this.rangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.rangeMarkers != null) {
            this.rangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addAnnotation(Annotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCompatibleDomainAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof HorizontalAxis;
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof VerticalAxis;
    }

    public boolean isCompatibleColorBarAxis(NumberAxis numberAxis) {
        if (numberAxis == null) {
            return true;
        }
        return numberAxis instanceof ColorBarAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Iterator iterator;
        Shape shape;
        Object object;
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        double d = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
            d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D, 1);
        }
        double d2 = 0.0;
        if (this.rangeAxis != null) {
            object = (VerticalAxis)((Object)this.rangeAxis);
            d2 = object.reserveWidth(graphics2D, this, rectangle2D, 3, d, 1);
        }
        object = new Rectangle2D.Double(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.colorBar != null) {
            Object object2;
            if (this.colorBar instanceof VerticalAxis) {
                object2 = (VerticalAxis)((Object)this.colorBar);
                d4 = object2.reserveWidth(graphics2D, this, (Rectangle2D)object, 3);
            } else {
                object2 = (HorizontalAxis)((Object)this.colorBar);
                d3 = object2.reserveHeight(graphics2D, this, (Rectangle2D)object, 1);
            }
        }
        object = new Rectangle2D.Double(((RectangularShape)object).getX(), ((RectangularShape)object).getY(), ((RectangularShape)object).getWidth() - d4, ((RectangularShape)object).getHeight() - d3);
        if (this.getDataAreaRatio() != 0.0) {
            double d5 = this.getDataAreaRatio();
            shape = (Rectangle2D)((RectangularShape)object).clone();
            double d6 = shape.getHeight();
            double d7 = shape.getWidth();
            if (d5 > 0.0) {
                if (d7 * d5 <= d6) {
                    d6 = d5 * d7;
                } else {
                    d7 = d6 / d5;
                }
            } else {
                d5 *= -1.0;
                double d8 = this.getDomainAxis().getRange().getLength();
                double d9 = this.getRangeAxis().getRange().getLength();
                double d10 = d9 / d8;
                d5 = d10 * d5;
                if (d7 * d5 <= d6) {
                    d6 = d5 * d7;
                } else {
                    d7 = d6 / d5;
                }
            }
            ((Rectangle2D)object).setRect(shape.getX() + shape.getWidth() / 2.0 - d7 / 2.0, shape.getY(), d7, d6);
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea((Rectangle2D)object);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getDomainAxis().getAnchorValue());
        crosshairInfo.setAnchorY(this.getRangeAxis().getAnchorValue());
        this.drawBackground(graphics2D, (Rectangle2D)object);
        Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)object).getX() - d2, ((RectangularShape)object).getY(), ((RectangularShape)object).getWidth() + d2, ((RectangularShape)object).getHeight() + d);
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, double_, (Rectangle2D)object, 1);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(graphics2D, double_, (Rectangle2D)object, 3);
        }
        if (this.colorBar != null) {
            if (this.colorBar instanceof VerticalAxis) {
                this.colorBar.draw(graphics2D, double_, new Rectangle2D.Double(((RectangularShape)object).getX(), ((RectangularShape)object).getY(), ((RectangularShape)object).getWidth() + (double)insets.right, ((RectangularShape)object).getHeight()), 3);
            } else {
                this.colorBar.draw(graphics2D, double_, new Rectangle2D.Double(((RectangularShape)object).getX(), ((RectangularShape)object).getY(), ((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight() + d), 1);
            }
        }
        shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip((Shape)object);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.render(graphics2D, (Rectangle2D)object, chartRenderingInfo, crosshairInfo);
        if (this.domainMarkers != null) {
            iterator = this.domainMarkers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.drawDomainMarker(graphics2D, this, this.getDomainAxis(), marker, (Rectangle2D)object);
            }
        }
        if (this.rangeMarkers != null) {
            iterator = this.rangeMarkers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, (Rectangle2D)object);
            }
        }
        if (this.annotations != null) {
            iterator = this.annotations.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof XYAnnotation)) continue;
                XYAnnotation xYAnnotation = (XYAnnotation)annotation;
                xYAnnotation.draw(graphics2D, (Rectangle2D)object, this.getDomainAxis(), this.getRangeAxis());
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, (Rectangle2D)object);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        ContourDataset contourDataset = this.getContourDataset();
        if (contourDataset != null) {
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            ColorBarAxis colorBarAxis = (ColorBarAxis)((Object)this.getColorBarValueAxis());
            if (this.clipPath != null) {
                GeneralPath generalPath = this.getClipPath().draw(graphics2D, rectangle2D, valueAxis, valueAxis2);
                if (this.clipPath.isClip()) {
                    graphics2D.clip(generalPath);
                }
            }
            if (this.renderAsPoints) {
                this.pointRenderer(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, colorBarAxis, contourDataset, crosshairInfo);
            } else {
                this.contourRenderer(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, colorBarAxis, contourDataset, crosshairInfo);
            }
            this.setDomainCrosshairValue(crosshairInfo.getCrosshairX(), false);
            if (this.isDomainCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, this.getDomainCrosshairValue(), this.getDomainCrosshairStroke(), this.getDomainCrosshairPaint());
            }
            this.setRangeCrosshairValue(crosshairInfo.getCrosshairY(), false);
            if (this.isRangeCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
            }
        } else if (this.clipPath != null) {
            GeneralPath generalPath = this.getClipPath().draw(graphics2D, rectangle2D, this.domainAxis, this.rangeAxis);
        }
    }

    public void contourRenderer(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, ContourPlot contourPlot, ValueAxis valueAxis, ValueAxis valueAxis2, ColorBarAxis colorBarAxis, ContourDataset contourDataset, CrosshairInfo crosshairInfo) {
        Rectangle2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        Shape shape = graphics2D.getClip();
        Rectangle2D.Double double_2 = null;
        double_2 = new Rectangle2D.Double();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Number[] numberArray = contourDataset.getXValues();
        Number[] numberArray2 = contourDataset.getYValues();
        Number[] numberArray3 = contourDataset.getZValues();
        double[] dArray = new double[numberArray.length];
        double[] dArray2 = new double[numberArray2.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = numberArray[n].doubleValue();
            dArray2[n] = numberArray2[n].doubleValue();
            ++n;
        }
        int[] nArray = ((DefaultContourDataset)contourDataset).indexX();
        int[] nArray2 = ((DefaultContourDataset)contourDataset).getXIndices();
        boolean bl = ((NumberAxis)valueAxis2).isInverted();
        boolean bl2 = false;
        if (valueAxis instanceof NumberAxis) {
            bl2 = ((NumberAxis)valueAxis).isInverted();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n2 = nArray[nArray.length - 1];
        int n3 = 0;
        while (n3 < dArray.length) {
            block21: {
                block22: {
                    int n4;
                    block20: {
                        n4 = nArray[n3];
                        if (nArray2[n4] != n3) break block20;
                        if (n4 == 0) {
                            d2 = d = valueAxis.translateValueToJava2D(dArray[n3], rectangle2D);
                            d3 = valueAxis.translateValueToJava2D(dArray[nArray2[n4 + 1]], rectangle2D);
                            d4 = Math.abs(0.5 * (d - d2));
                            d5 = Math.abs(0.5 * (d - d3));
                        } else if (n4 == n2) {
                            d = valueAxis.translateValueToJava2D(dArray[n3], rectangle2D);
                            d2 = valueAxis.translateValueToJava2D(dArray[nArray2[n4 - 1]], rectangle2D);
                            d3 = d;
                            d4 = Math.abs(0.5 * (d - d2));
                            d5 = Math.abs(0.5 * (d - d3));
                        } else {
                            d = valueAxis.translateValueToJava2D(dArray[n3], rectangle2D);
                            d3 = valueAxis.translateValueToJava2D(dArray[nArray2[n4 + 1]], rectangle2D);
                            d4 = d5;
                            d5 = Math.abs(0.5 * (d - d3));
                        }
                        d = bl2 ? (d -= d5) : (d -= d4);
                        d6 = d4 + d5;
                        d8 = d7 = valueAxis2.translateValueToJava2D(dArray2[n3], rectangle2D);
                        if (n3 + 1 == dArray2.length) break block21;
                        d9 = valueAxis2.translateValueToJava2D(dArray2[n3 + 1], rectangle2D);
                        d10 = Math.abs(0.5 * (d7 - d8));
                        d11 = Math.abs(0.5 * (d7 - d9));
                        break block22;
                    }
                    if (n4 < nArray2.length - 1 && nArray2[n4 + 1] - 1 == n3 || n3 == dArray.length - 1) {
                        d7 = valueAxis2.translateValueToJava2D(dArray2[n3], rectangle2D);
                        d8 = valueAxis2.translateValueToJava2D(dArray2[n3 - 1], rectangle2D);
                        d9 = d7;
                        d10 = Math.abs(0.5 * (d7 - d8));
                        d11 = Math.abs(0.5 * (d7 - d9));
                    } else {
                        d7 = valueAxis2.translateValueToJava2D(dArray2[n3], rectangle2D);
                        d9 = valueAxis2.translateValueToJava2D(dArray2[n3 + 1], rectangle2D);
                        d10 = d11;
                        d11 = Math.abs(0.5 * (d7 - d9));
                    }
                }
                d7 = bl ? (d7 -= d10) : (d7 -= d11);
                d12 = d10 + d11;
                double_2.setRect(d, d7, d6, d12);
                if (numberArray3[n3] != null) {
                    graphics2D.setPaint(colorBarAxis.getPaint(numberArray3[n3].doubleValue()));
                    graphics2D.fill(double_2);
                } else if (this.missingPaint != null) {
                    graphics2D.setPaint(this.missingPaint);
                    graphics2D.fill(double_2);
                }
                double_ = double_2;
                if (entityCollection != null) {
                    String string = "";
                    if (this.getToolTipGenerator() != null) {
                        string = this.toolTipGenerator.generateToolTip(contourDataset, n3);
                    }
                    Shape shape2 = graphics2D.getClip();
                    String string2 = null;
                    ContourEntity contourEntity = new ContourEntity((Rectangle2D.Double)double_.clone(), string, string2);
                    contourEntity.setIndex(n3);
                    entityCollection.addEntity(contourEntity);
                }
                if (contourPlot.isDomainCrosshairLockedOnData()) {
                    if (contourPlot.isRangeCrosshairLockedOnData()) {
                        crosshairInfo.updateCrosshairPoint(d, d7);
                    } else {
                        crosshairInfo.updateCrosshairX(d);
                    }
                } else if (contourPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairY(d7);
                }
            }
            ++n3;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public void pointRenderer(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, ContourPlot contourPlot, ValueAxis valueAxis, ValueAxis valueAxis2, ColorBarAxis colorBarAxis, ContourDataset contourDataset, CrosshairInfo crosshairInfo) {
        Ellipse2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        Ellipse2D.Double double_2 = new Ellipse2D.Double();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Number[] numberArray = contourDataset.getXValues();
        Number[] numberArray2 = contourDataset.getYValues();
        Number[] numberArray3 = contourDataset.getZValues();
        double[] dArray = new double[numberArray.length];
        double[] dArray2 = new double[numberArray2.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = numberArray[n].doubleValue();
            dArray2[n] = numberArray2[n].doubleValue();
            ++n;
        }
        int[] nArray = ((DefaultContourDataset)contourDataset).indexX();
        int[] nArray2 = ((DefaultContourDataset)contourDataset).getXIndices();
        boolean bl = ((NumberAxis)valueAxis2).isInverted();
        boolean bl2 = false;
        if (valueAxis instanceof NumberAxis) {
            bl2 = ((NumberAxis)valueAxis).isInverted();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = rectangle2D.getWidth() * this.ptSizePct;
        int n2 = 0;
        while (n2 < dArray.length) {
            d = valueAxis.translateValueToJava2D(dArray[n2], rectangle2D) - 0.5 * d5;
            d3 = valueAxis2.translateValueToJava2D(dArray2[n2], rectangle2D) - 0.5 * d5;
            d2 = d5;
            d4 = d5;
            ((RectangularShape)double_2).setFrame(d, d3, d2, d4);
            if (numberArray3[n2] != null) {
                graphics2D.setPaint(colorBarAxis.getPaint(numberArray3[n2].doubleValue()));
                graphics2D.fill(double_2);
            } else if (this.missingPaint != null) {
                graphics2D.setPaint(this.missingPaint);
                graphics2D.fill(double_2);
            }
            double_ = double_2;
            if (entityCollection != null) {
                String string = "";
                if (this.getToolTipGenerator() != null) {
                    string = this.toolTipGenerator.generateToolTip(contourDataset, n2);
                }
                String string2 = null;
                ContourEntity contourEntity = new ContourEntity((RectangularShape)double_.clone(), string, string2);
                contourEntity.setIndex(n2);
                entityCollection.addEntity(contourEntity);
            }
            if (contourPlot.isDomainCrosshairLockedOnData()) {
                if (contourPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d, d3);
                } else {
                    crosshairInfo.updateCrosshairX(d);
                }
            } else if (contourPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d3);
            }
            ++n2;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
    }

    public void zoom(double d) {
        if (d > 0.0) {
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
            ValueAxis valueAxis2 = this.getRangeAxis();
            d2 = valueAxis2.getMaximumAxisValue() - valueAxis2.getMinimumAxisValue();
            d3 = d2 * d;
            valueAxis2.setAnchoredRange(d3);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return "Contour Plot";
    }

    public Range getHorizontalDataRange(ValueAxis valueAxis) {
        Range range = null;
        Dataset dataset = this.getDataset();
        if (dataset != null) {
            range = DatasetUtilities.getDomainExtent(dataset);
        }
        return range;
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        Range range = null;
        Dataset dataset = this.getDataset();
        if (dataset != null) {
            range = DatasetUtilities.getRangeExtent(dataset);
        }
        return range;
    }

    public Range getContourDataRange() {
        Range range = null;
        ContourDataset contourDataset = (ContourDataset)this.getDataset();
        if (contourDataset != null) {
            Range range2 = this.getHorizontalValueAxis().getRange();
            Range range3 = this.getVerticalValueAxis().getRange();
            range = this.visibleRange(contourDataset, range2, range3);
        }
        return range;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.colorBar != null) {
            this.colorBar.configure();
        }
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }

    public HorizontalAxis getHorizontalAxis() {
        return (HorizontalAxis)((Object)this.getDomainAxis());
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getDomainAxis();
    }

    public VerticalAxis getVerticalAxis() {
        return (VerticalAxis)((Object)this.getRangeAxis());
    }

    public ValueAxis getColorBarValueAxis() {
        return this.colorBar;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.getRangeAxis();
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl) {
        if (this.domainCrosshairLockedOnData != bl) {
            this.domainCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d) {
        this.setDomainCrosshairValue(d, true);
    }

    public void setDomainCrosshairValue(double d, boolean bl) {
        this.domainCrosshairValue = d;
        if (this.isDomainCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        this.domainCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        this.domainCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ContourToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(ContourToolTipGenerator contourToolTipGenerator) {
        ContourToolTipGenerator contourToolTipGenerator2 = this.toolTipGenerator;
        this.toolTipGenerator = contourToolTipGenerator;
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        XYURLGenerator xYURLGenerator2 = this.urlGenerator;
        this.urlGenerator = xYURLGenerator;
    }

    public void drawDomainMarker(Graphics2D graphics2D, ContourPlot contourPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, ContourPlot contourPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public ClipPath getClipPath() {
        return this.clipPath;
    }

    public void setClipPath(ClipPath clipPath) {
        this.clipPath = clipPath;
    }

    public double getPtSizePct() {
        return this.ptSizePct;
    }

    public boolean isRenderAsPoints() {
        return this.renderAsPoints;
    }

    public void setPtSizePct(double d) {
        this.ptSizePct = d;
    }

    public void setRenderAsPoints(boolean bl) {
        this.renderAsPoints = bl;
    }

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        Object object = axisChangeEvent.getSource();
        if (object.equals(this.rangeAxis) || object.equals(this.domainAxis)) {
            ColorBarAxis colorBarAxis = (ColorBarAxis)((Object)this.colorBar);
            if (this.colorBar.isAutoRange()) {
                colorBarAxis.doAutoRange();
            }
        }
        super.axisChanged(axisChangeEvent);
    }

    public Range visibleRange(ContourDataset contourDataset, Range range, Range range2) {
        Range range3 = null;
        range3 = ((DefaultContourDataset)contourDataset).getZValueRange(range, range2);
        return range3;
    }

    public Paint getMissingPaint() {
        return this.missingPaint;
    }

    public void setMissingPaint(Paint paint) {
        this.missingPaint = paint;
    }
}

