/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.HorizontalCategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.VerticalNumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.VerticalCategoryPlot;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Range;

public class OverlaidVerticalCategoryPlot
extends VerticalCategoryPlot
implements Serializable {
    private List subplots = new ArrayList();

    public OverlaidVerticalCategoryPlot(String string, String string2) {
        this(new HorizontalCategoryAxis(string), new VerticalNumberAxis(string2));
    }

    public OverlaidVerticalCategoryPlot(CategoryAxis categoryAxis, ValueAxis valueAxis) {
        super(null, categoryAxis, valueAxis, new LineAndShapeRenderer());
    }

    public void add(VerticalCategoryPlot verticalCategoryPlot) {
        ValueAxis valueAxis;
        verticalCategoryPlot.setParent(this);
        verticalCategoryPlot.setDomainAxis(null);
        verticalCategoryPlot.setRangeAxis(null);
        this.subplots.add(verticalCategoryPlot);
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            categoryAxis.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
    }

    public CategoryDataset getCategoryDataset() {
        CategoryDataset categoryDataset = null;
        if (this.subplots.size() > 0) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(0);
            categoryDataset = categoryPlot.getCategoryDataset();
        }
        return categoryDataset;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
            verticalCategoryPlot.render(graphics2D, rectangle2D, chartRenderingInfo);
        }
    }

    public String getPlotType() {
        return "Overlaid Vertical Category Plot";
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
                range = Range.combine(range, verticalCategoryPlot.getVerticalDataRange(valueAxis));
            }
        }
        return range;
    }
}

