/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.DefaultDrawingSupplier;
import org.jfree.chart.renderer.DrawingSupplier;
import org.jfree.chart.renderer.PaintTable;
import org.jfree.chart.renderer.StrokeTable;
import org.jfree.chart.tooltips.PieToolTipGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.CategoryToPieDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtils;

public class PiePlot
extends Plot
implements Serializable {
    public static final int CLOCKWISE = -1;
    public static final int ANTICLOCKWISE = 1;
    public static final int NO_LABELS = 0;
    public static final int NAME_LABELS = 1;
    public static final int VALUE_LABELS = 2;
    public static final int PERCENT_LABELS = 3;
    public static final int NAME_AND_VALUE_LABELS = 4;
    public static final int NAME_AND_PERCENT_LABELS = 5;
    public static final int VALUE_AND_PERCENT_LABELS = 6;
    public static final int PER_ROW = 0;
    public static final int PER_COLUMN = 1;
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_RADIUS = 1.0;
    public static final double MAX_RADIUS = 1.0;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final int DEFAULT_DIRECTION = -1;
    public static final int DEFAULT_SECTION_LABEL_TYPE = 1;
    public static final Font DEFAULT_SECTION_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_SECTION_LABEL_PAINT = Color.black;
    public static final double DEFAULT_SECTION_LABEL_GAP = 0.1;
    public static final double MAX_SECTION_LABEL_GAP = 0.3;
    public static final NumberFormat DEFAULT_VALUE_FORMATTER = NumberFormat.getNumberInstance();
    public static final NumberFormat DEFAULT_PERCENT_FORMATTER = NumberFormat.getPercentInstance();
    public static final Font DEFAULT_SERIES_LABEL_FONT = new Font("SansSerif", 0, 12);
    public static final Paint DEFAULT_SERIES_LABEL_PAINT = Color.black;
    public static final boolean DEFAULT_SHOW_SERIES_LABELS = true;
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private double interiorGap;
    private boolean circular;
    private double radius;
    private double startAngle;
    private int direction;
    private int sectionLabelType;
    private Font sectionLabelFont;
    private transient Paint sectionLabelPaint;
    private double sectionLabelGap;
    private double[] explodePercentages;
    private NumberFormat valueFormatter;
    private NumberFormat percentFormatter;
    private PieToolTipGenerator toolTipGenerator;
    private PieURLGenerator urlGenerator;
    private boolean showSeriesLabels = true;
    private Font seriesLabelFont = DEFAULT_SERIES_LABEL_FONT;
    private transient Paint seriesLabelPaint = DEFAULT_SERIES_LABEL_PAINT;
    private DrawingSupplier supplier;
    private boolean paintTableActive;
    private PaintTable paintTable;
    private transient Paint defaultPaint;
    private boolean outlinePaintTableActive;
    private PaintTable outlinePaintTable;
    private transient Paint defaultOutlinePaint;
    private boolean outlineStrokeTableActive;
    private StrokeTable outlineStrokeTable;
    private transient Stroke defaultOutlineStroke;
    private int extractType;
    private double minimumArcAngleToDraw;

    public PiePlot(PieDataset pieDataset) {
        super(pieDataset);
        this.initialise();
    }

    public PiePlot(CategoryDataset categoryDataset, int n) {
        super(categoryDataset);
        this.initialise();
        this.extractType = n;
    }

    private void initialise() {
        this.interiorGap = 0.25;
        this.circular = true;
        this.radius = 1.0;
        this.startAngle = 90.0;
        this.direction = -1;
        this.sectionLabelType = 1;
        this.sectionLabelFont = DEFAULT_SECTION_LABEL_FONT;
        this.sectionLabelPaint = DEFAULT_SECTION_LABEL_PAINT;
        this.sectionLabelGap = 0.1;
        this.valueFormatter = DEFAULT_VALUE_FORMATTER;
        this.percentFormatter = DEFAULT_PERCENT_FORMATTER;
        this.toolTipGenerator = null;
        this.urlGenerator = null;
        this.supplier = new DefaultDrawingSupplier();
        this.paintTableActive = true;
        this.paintTable = new PaintTable();
        this.defaultPaint = null;
        this.outlinePaintTableActive = false;
        this.outlinePaintTable = null;
        this.defaultOutlinePaint = Color.lightGray;
        this.outlineStrokeTableActive = false;
        this.outlineStrokeTable = null;
        this.defaultOutlineStroke = new BasicStroke(1.0f);
        this.minimumArcAngleToDraw = 1.0E-5;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        if (n != -1 && n != 1) {
            throw new IllegalArgumentException("PiePlot.setDirection(int): invalid direction.");
        }
        this.direction = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("PiePlot.setInteriorGapPercent(double): percentage outside valid range.");
        }
        if (this.interiorGap != d) {
            this.interiorGap = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        if (this.circular != bl) {
            this.circular = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    protected void setCircularAttribute(boolean bl) {
        this.circular = bl;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("PiePlot.setRadiusPercent(double): percentage outside valid range.");
        }
        if (this.radius != d) {
            this.radius = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getExplodePercent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("PiePlot.getExplodePercent(int): section outside valid range.");
        }
        double d = 0.0;
        if (this.explodePercentages != null && n < this.explodePercentages.length) {
            d = this.explodePercentages[n];
        }
        return d;
    }

    public void setExplodePercent(int n, double d) {
        if (n < 0 || n >= this.getPieDataset().getKeys().size()) {
            throw new IllegalArgumentException("PiePlot.setExplodePercent(int, double): section outside valid range.");
        }
        if (this.explodePercentages != null) {
            if (n < this.explodePercentages.length) {
                this.explodePercentages[n] = d;
            } else {
                double[] dArray = new double[n + 1];
                int n2 = 0;
                while (n2 < this.explodePercentages.length) {
                    dArray[n2] = this.explodePercentages[n2];
                    ++n2;
                }
                this.explodePercentages = dArray;
                this.explodePercentages[n] = d;
            }
        } else {
            this.explodePercentages = new double[this.getPieDataset().getKeys().size()];
            this.explodePercentages[n] = d;
        }
    }

    public int getSectionLabelType() {
        return this.sectionLabelType;
    }

    public void setSectionLabelType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelType(int): unrecognised type.");
        }
        if (this.sectionLabelType != n) {
            this.sectionLabelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getSectionLabelFont() {
        return this.sectionLabelFont;
    }

    public void setSectionLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelFont(...): null font not allowed.");
        }
        if (!this.sectionLabelFont.equals(font)) {
            this.sectionLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSectionLabelPaint() {
        return this.sectionLabelPaint;
    }

    public void setSectionLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelPaint(...): null paint not allowed.");
        }
        if (!this.sectionLabelPaint.equals(paint)) {
            this.sectionLabelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getSectionLabelGap() {
        return this.sectionLabelGap;
    }

    public void setSectionLabelGap(double d) {
        if (d < 0.0 || d > 0.3) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelGapPercent(double): percentage outside valid range.");
        }
        if (this.sectionLabelGap != d) {
            this.sectionLabelGap = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setValueFormatString(String string) {
        this.valueFormatter = new DecimalFormat(string);
    }

    public void setValueFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            return;
        }
        this.valueFormatter = numberFormat;
    }

    public void setPercentFormatString(String string) {
        this.percentFormatter = new DecimalFormat(string);
    }

    public void setPercentFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            return;
        }
        this.percentFormatter = numberFormat;
    }

    public PieDataset getPieDataset() {
        return (PieDataset)this.getDataset();
    }

    public boolean getShowSeriesLabels() {
        return this.showSeriesLabels;
    }

    public void setShowSeriesLabels(boolean bl) {
        if (this.showSeriesLabels != bl) {
            this.showSeriesLabels = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getSeriesLabelFont() {
        return this.seriesLabelFont;
    }

    public void setSeriesLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("PiePlot.setSeriesLabelFont(...): null font not allowed.");
        }
        if (!this.seriesLabelFont.equals(font)) {
            this.seriesLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSeriesLabelPaint() {
        return this.seriesLabelPaint;
    }

    public void setSeriesLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("PiePlot.setSeriesLabelPaint(...): null paint not allowed.");
        }
        if (!this.seriesLabelPaint.equals(paint)) {
            this.seriesLabelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Collection getKeys() {
        return this.getPieDataset().getKeys();
    }

    public boolean isPaintTableActive() {
        return this.paintTableActive;
    }

    public void setPaintTableActive(boolean bl) {
        if (this.paintTableActive != bl) {
            this.paintTableActive = bl;
            if (bl && this.paintTable == null) {
                this.paintTable = new PaintTable();
            }
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getPaint(int n) {
        Paint paint = null;
        if (this.paintTableActive) {
            paint = this.paintTable.getPaint(0, n);
            if (paint == null) {
                paint = this.supplier.getNextPaint();
                this.paintTable.setPaint(0, n, paint);
            }
        } else {
            paint = this.defaultPaint;
        }
        return paint;
    }

    public void setPaint(int n, Paint paint) {
        this.paintTable.setPaint(0, n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public void setDefaultPaint(Paint paint) {
        this.defaultPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isOutlinePaintTableActive() {
        return this.outlinePaintTableActive;
    }

    public void setOutlinePaintTableActive(boolean bl) {
        if (this.outlinePaintTableActive != bl) {
            this.outlinePaintTableActive = bl;
            if (bl && this.outlinePaintTable == null) {
                this.outlinePaintTable = new PaintTable();
            }
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint(int n) {
        Paint paint = null;
        if (this.outlinePaintTableActive) {
            paint = this.outlinePaintTable.getPaint(0, n);
            if (paint == null) {
                paint = this.supplier.getNextOutlinePaint();
                this.outlinePaintTable.setPaint(0, n, paint);
            }
        } else {
            paint = this.defaultOutlinePaint;
        }
        return paint;
    }

    public void setOutlinePaint(int n, Paint paint) {
        this.outlinePaintTable.setPaint(0, n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDefaultOutlinePaint() {
        return this.defaultOutlinePaint;
    }

    public void setDefaultOutlinePaint(Paint paint) {
        this.defaultOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isOutlineStrokeTableActive() {
        return this.outlineStrokeTableActive;
    }

    public void setOutlineStrokeTableActive(boolean bl) {
        if (this.outlineStrokeTableActive != bl) {
            this.outlineStrokeTableActive = bl;
            if (bl && this.outlineStrokeTable == null) {
                this.outlineStrokeTable = new StrokeTable();
            }
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getOutlineStroke(int n) {
        Stroke stroke = null;
        if (this.outlineStrokeTableActive) {
            stroke = this.outlineStrokeTable.getStroke(0, n);
            if (stroke == null) {
                stroke = this.supplier.getNextOutlineStroke();
                this.outlineStrokeTable.setStroke(0, n, stroke);
            }
        } else {
            stroke = this.defaultOutlineStroke;
        }
        return stroke;
    }

    public void setOutlineStroke(int n, Stroke stroke) {
        this.outlineStrokeTable.setStroke(0, n, stroke);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDefaultOutlineStroke() {
        return this.defaultOutlineStroke;
    }

    public void setDefaultOutlineStroke(Stroke stroke) {
        this.defaultOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double d) {
        this.minimumArcAngleToDraw = d;
    }

    public LegendItemCollection getLegendItems() {
        Dataset dataset;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        List list = null;
        Dataset dataset2 = this.getDataset();
        if (dataset2 instanceof PieDataset) {
            dataset = (PieDataset)dataset2;
            list = dataset.getKeys();
        } else if (dataset2 instanceof CategoryDataset) {
            dataset = (CategoryDataset)dataset2;
            if (this.extractType == 0) {
                list = dataset.getColumnKeys();
            } else if (this.extractType == 1) {
                list = dataset.getRowKeys();
            }
        }
        if (list != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next().toString();
                Shape shape = null;
                Paint paint = this.getPaint(n);
                Paint paint2 = this.getOutlinePaint(n);
                Stroke stroke = this.getOutlineStroke(n);
                LegendItem legendItem = new LegendItem(string, string2, shape, paint, paint2, stroke);
                legendItemCollection.add(legendItem);
                ++n;
            }
        }
        return legendItemCollection;
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator pieToolTipGenerator) {
        this.toolTipGenerator = pieToolTipGenerator;
    }

    public PieURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(PieURLGenerator pieURLGenerator) {
        this.urlGenerator = pieURLGenerator;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Insets insets = this.getInsets();
        if (insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
            chartRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        Dataset dataset = this.getDataset();
        if (dataset instanceof PieDataset) {
            PieDataset pieDataset = (PieDataset)dataset;
            this.drawPie(graphics2D, rectangle2D, chartRenderingInfo, 0, pieDataset, null);
        } else if (dataset instanceof CategoryDataset) {
            int n;
            int n2;
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            int n3 = 0;
            n3 = this.extractType == 0 ? categoryDataset.getRowCount() : categoryDataset.getColumnCount();
            int n4 = (int)Math.ceil(Math.sqrt(n3));
            if (n4 > (n2 = (int)Math.ceil((double)n3 / (double)n4)) && rectangle2D.getWidth() < rectangle2D.getHeight()) {
                n = n4;
                n4 = n2;
                n2 = n;
            }
            n = graphics2D.getFontMetrics(this.seriesLabelFont).getHeight() * 2;
            int n5 = (int)rectangle2D.getX();
            int n6 = (int)rectangle2D.getY();
            int n7 = (int)rectangle2D.getWidth() / n4;
            int n8 = (int)rectangle2D.getHeight() / n2;
            int n9 = 0;
            int n10 = 0;
            int n11 = n2 * n4 - n3;
            int n12 = 0;
            Rectangle rectangle = new Rectangle();
            int n13 = 0;
            while (n13 < n3) {
                rectangle.setBounds(n5 + n12 + n7 * n10, n6 + n8 * n9, n7, n8 - n);
                CategoryToPieDataset categoryToPieDataset = new CategoryToPieDataset(categoryDataset, this.extractType, n13);
                String string = null;
                string = this.extractType == 0 ? categoryDataset.getRowKey(n13).toString() : categoryDataset.getColumnKey(n13).toString();
                this.drawPie(graphics2D, rectangle, chartRenderingInfo, n13, categoryToPieDataset, string);
                if (++n10 == n4) {
                    n10 = 0;
                    if (++n9 == n2 - 1 && n11 != 0) {
                        n12 = n11 * n7 / 2;
                    }
                }
                ++n13;
            }
        }
        graphics2D.clip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    private void drawPie(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, int n, PieDataset pieDataset, String string) {
        double d = rectangle2D.getWidth() * this.interiorGap;
        double d2 = rectangle2D.getHeight() * this.interiorGap;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2;
        if (this.circular) {
            double d7 = Math.min(d5, d6) / 2.0;
            d3 = (d3 + d3 + d5) / 2.0 - d7;
            d4 = (d4 + d4 + d6) / 2.0 - d7;
            d5 = 2.0 * d7;
            d6 = 2.0 * d7;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        double d8 = (1.0 - this.radius) * d5;
        double d9 = (1.0 - this.radius) * d6;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d3 + d8 / 2.0, d4 + d9 / 2.0, d5 - d8, d6 - d9);
        if (pieDataset != null && pieDataset.getKeys().size() > 0) {
            Object object;
            List list = pieDataset.getKeys();
            double d10 = DatasetUtilities.getPieDatasetTotal(pieDataset);
            double d11 = 0.0;
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                double d12;
                object = (Comparable)iterator.next();
                Number number = pieDataset.getValue((Comparable)object);
                if (number != null && (d12 = number.doubleValue()) > 0.0) {
                    double d13 = this.startAngle + (double)this.direction * (d11 * 360.0) / d10;
                    double d14 = this.startAngle + (double)this.direction * (d11 + d12) * 360.0 / d10;
                    d11 += d12;
                    double d15 = d14 - d13;
                    if (Math.abs(d15) > this.minimumArcAngleToDraw) {
                        EntityCollection entityCollection;
                        Rectangle2D rectangle2D2 = this.getArcBounds(double_2, double_, d13, d14 - d13, this.getExplodePercent(n2));
                        Arc2D.Double double_3 = new Arc2D.Double(rectangle2D2, d13, d14 - d13, 2);
                        Paint paint = this.getPaint(n2);
                        Paint paint2 = this.getOutlinePaint(n2);
                        Stroke stroke = this.getOutlineStroke(n2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(double_3);
                        graphics2D.setStroke(stroke);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(double_3);
                        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
                            String string2 = null;
                            if (this.toolTipGenerator != null) {
                                string2 = this.toolTipGenerator.generateToolTip(pieDataset, (Comparable)object, n);
                            }
                            String string3 = null;
                            if (this.urlGenerator != null) {
                                string3 = this.urlGenerator.generateURL(pieDataset, (Comparable)object, n);
                            }
                            PieSectionEntity pieSectionEntity = new PieSectionEntity(n, n2, (Comparable)object, double_3, string2, string3);
                            entityCollection.addEntity(pieSectionEntity);
                        }
                    }
                    if (this.sectionLabelType != 0) {
                        this.drawLabel(graphics2D, double_2, double_, pieDataset, d12, n2, d13, d14 - d13);
                    }
                }
                ++n2;
            }
            if (string != null) {
                graphics2D.setPaint(this.seriesLabelPaint);
                graphics2D.setFont(this.seriesLabelFont);
                object = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                double d16 = d3 + d5 / 2.0 - ((RectangularShape)object).getWidth() / 2.0;
                double d17 = d4 + d6 + 2.0 * ((RectangularShape)object).getHeight();
                graphics2D.drawString(string, (int)d16, (int)d17);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawLabel(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PieDataset pieDataset, double d, int n, double d2, double d3) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        String string = "";
        if (this.sectionLabelType == 1) {
            string = pieDataset.getKey(n).toString();
        } else if (this.sectionLabelType == 2) {
            string = this.valueFormatter.format(d);
        } else if (this.sectionLabelType == 3) {
            string = this.percentFormatter.format(d3 / 360.0 * (double)this.direction);
        } else if (this.sectionLabelType == 4) {
            string = pieDataset.getKey(n).toString() + " (" + this.valueFormatter.format(d) + ")";
        } else if (this.sectionLabelType == 5) {
            string = pieDataset.getKey(n).toString() + " (" + this.percentFormatter.format(d3 / 360.0 * (double)this.direction) + ")";
        } else if (this.sectionLabelType == 6) {
            string = this.valueFormatter.format(d) + " (" + this.percentFormatter.format(d3 / 360.0 * (double)this.direction) + ")";
        }
        Rectangle2D rectangle2D3 = this.sectionLabelFont.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = this.sectionLabelFont.getLineMetrics(string, fontRenderContext);
        double d4 = lineMetrics.getAscent();
        Point2D point2D = this.calculateLabelLocation(rectangle2D3, d4, rectangle2D, rectangle2D2, d2, d3, this.getExplodePercent(n));
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setPaint(this.sectionLabelPaint);
        graphics2D.setFont(this.sectionLabelFont);
        graphics2D.drawString(string, (float)point2D.getX(), (float)point2D.getY());
        graphics2D.setComposite(composite);
    }

    public String getPlotType() {
        return "Pie Plot";
    }

    public void zoom(double d) {
    }

    protected Rectangle2D getArcBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2, double d3) {
        if (d3 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d, d2 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d, d2 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d4 = (point2D.getX() - point2D2.getX()) * d3;
        double d5 = (point2D.getY() - point2D2.getY()) * d3;
        return new Rectangle2D.Double(rectangle2D.getX() - d4, rectangle2D.getY() - d5, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected Point2D calculateLabelLocation(Rectangle2D rectangle2D, double d, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, double d2, double d3, double d4) {
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, d3 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, d2, d3 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d5 = (point2D.getX() - point2D2.getX()) * d4;
        double d6 = (point2D.getY() - point2D2.getY()) * d4;
        double d7 = point2D.getX() - (d5 -= (point2D.getX() - rectangle2D2.getCenterX()) * this.sectionLabelGap);
        double d8 = point2D.getY() - (d6 -= (point2D.getY() - rectangle2D2.getCenterY()) * this.sectionLabelGap);
        if (d7 <= rectangle2D2.getCenterX()) {
            d7 -= rectangle2D.getWidth();
        }
        if (d8 > rectangle2D2.getCenterY()) {
            d8 += d;
        }
        return new Point2D.Double(d7, d8);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof PiePlot) {
            PiePlot piePlot = (PiePlot)object;
            boolean bl = this.interiorGap == piePlot.interiorGap;
            boolean bl2 = this.circular == piePlot.circular;
            boolean bl3 = this.radius == piePlot.radius;
            boolean bl4 = this.startAngle == piePlot.startAngle;
            boolean bl5 = this.direction == piePlot.direction;
            boolean bl6 = this.sectionLabelType == piePlot.sectionLabelType;
            boolean bl7 = ObjectUtils.equalOrBothNull((Object)this.sectionLabelFont, (Object)piePlot.sectionLabelFont);
            boolean bl8 = ObjectUtils.equalOrBothNull((Object)this.sectionLabelPaint, (Object)piePlot.sectionLabelPaint);
            boolean bl9 = this.sectionLabelGap == piePlot.sectionLabelGap;
            boolean bl10 = ObjectUtils.equalOrBothNull((Object)this.explodePercentages, (Object)piePlot.explodePercentages);
            boolean bl11 = ObjectUtils.equalOrBothNull((Object)this.valueFormatter, (Object)piePlot.valueFormatter);
            boolean bl12 = ObjectUtils.equalOrBothNull((Object)this.percentFormatter, (Object)piePlot.percentFormatter);
            boolean bl13 = ObjectUtils.equalOrBothNull((Object)this.toolTipGenerator, (Object)piePlot.toolTipGenerator);
            boolean bl14 = ObjectUtils.equalOrBothNull((Object)this.urlGenerator, (Object)piePlot.urlGenerator);
            boolean bl15 = this.showSeriesLabels == piePlot.showSeriesLabels;
            boolean bl16 = ObjectUtils.equalOrBothNull((Object)this.seriesLabelFont, (Object)piePlot.seriesLabelFont);
            boolean bl17 = ObjectUtils.equalOrBothNull((Object)this.seriesLabelPaint, (Object)piePlot.seriesLabelPaint);
            boolean bl18 = ObjectUtils.equalOrBothNull((Object)this.supplier, (Object)piePlot.supplier);
            boolean bl19 = this.paintTableActive == piePlot.paintTableActive;
            boolean bl20 = ObjectUtils.equalOrBothNull((Object)this.paintTable, (Object)piePlot.paintTable);
            boolean bl21 = ObjectUtils.equalOrBothNull((Object)this.defaultPaint, (Object)piePlot.defaultPaint);
            boolean bl22 = this.outlinePaintTableActive == piePlot.outlinePaintTableActive;
            boolean bl23 = ObjectUtils.equalOrBothNull((Object)this.outlinePaintTable, (Object)piePlot.outlinePaintTable);
            boolean bl24 = ObjectUtils.equalOrBothNull((Object)this.defaultOutlinePaint, (Object)piePlot.defaultOutlinePaint);
            boolean bl25 = this.outlineStrokeTableActive == piePlot.outlineStrokeTableActive;
            boolean bl26 = ObjectUtils.equalOrBothNull((Object)this.outlineStrokeTable, (Object)piePlot.outlineStrokeTable);
            boolean bl27 = ObjectUtils.equalOrBothNull((Object)this.defaultOutlineStroke, (Object)piePlot.defaultOutlineStroke);
            boolean bl28 = this.extractType == piePlot.extractType;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.sectionLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.seriesLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.defaultPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.defaultOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.defaultOutlineStroke, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.sectionLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.seriesLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.defaultPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.defaultOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.defaultOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
    }
}

