/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;

public class StrokeTable
implements Serializable {
    private int rows = 0;
    private int columns = 0;
    private transient Stroke[][] data = new Stroke[0][0];

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public Stroke getStroke(int n, int n2) {
        Stroke[] strokeArray;
        Stroke stroke = null;
        if (n < this.data.length && n2 < (strokeArray = this.data[n]).length) {
            stroke = strokeArray[n2];
        }
        return stroke;
    }

    public void setStroke(int n, int n2, Stroke stroke) {
        int n3;
        Stroke[][] strokeArrayArray;
        if (n >= this.data.length) {
            strokeArrayArray = new Stroke[n + 1][];
            int n4 = 0;
            while (n4 < this.data.length) {
                strokeArrayArray[n4] = this.data[n4];
                ++n4;
            }
            n3 = this.data.length;
            while (n3 <= n) {
                strokeArrayArray[n3] = new Stroke[0];
                ++n3;
            }
            this.data = strokeArrayArray;
        }
        if (n2 >= (strokeArrayArray = this.data[n]).length) {
            Stroke[] strokeArray = new Stroke[n2 + 1];
            n3 = 0;
            while (n3 < strokeArrayArray.length) {
                strokeArray[n3] = strokeArrayArray[n3];
                ++n3;
            }
            strokeArray[n2] = stroke;
            this.data[n] = strokeArray;
        } else {
            strokeArrayArray[n2] = stroke;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof StrokeTable) {
            StrokeTable strokeTable = (StrokeTable)object;
            boolean bl = this.rows == strokeTable.getRowCount() && this.columns == strokeTable.getColumnCount();
            int n = 0;
            while (n < this.rows) {
                int n2 = this.data[n].length;
                int n3 = 0;
                while (n3 < n2) {
                    bl = bl && this.data[n][n3].equals(strokeTable.getStroke(n, n3));
                    ++n3;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < this.rows) {
            int n2 = this.data[n].length;
            objectOutputStream.writeInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                SerialUtilities.writeStroke((Stroke)this.data[n][n3], (ObjectOutputStream)objectOutputStream);
                ++n3;
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new Stroke[this.rows][this.columns];
        int n = 0;
        while (n < this.rows) {
            int n2 = objectInputStream.readInt();
            int n3 = 0;
            while (n3 < n2) {
                Stroke stroke;
                this.data[n][n3] = stroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
                ++n3;
            }
            ++n;
        }
    }
}

