/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.tooltips;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.tooltips.CategoryToolTipGenerator;
import org.jfree.data.CategoryDataset;

public class StandardCategoryToolTipGenerator
implements CategoryToolTipGenerator,
Serializable {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public StandardCategoryToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardCategoryToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public StandardCategoryToolTipGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
        String string = "";
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            Comparable comparable = categoryDataset.getRowKey(n);
            if (comparable != null) {
                string = string + comparable.toString() + ", ";
            }
            Comparable comparable2 = categoryDataset.getColumnKey(n2);
            String string2 = comparable2.toString();
            String string3 = null;
            if (this.numberFormat != null) {
                string3 = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string3 = this.dateFormat.format(number);
            }
            string = string + string2 + " = " + string3;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardCategoryToolTipGenerator) {
            StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = (StandardCategoryToolTipGenerator)object;
            if (this.dateFormat != null) {
                return this.dateFormat.equals(standardCategoryToolTipGenerator.dateFormat);
            }
            return this.numberFormat.equals(standardCategoryToolTipGenerator.numberFormat);
        }
        return false;
    }
}

