/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.tooltips;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.tooltips.PieToolTipGenerator;
import org.jfree.data.PieDataset;

public class StandardPieToolTipGenerator
implements PieToolTipGenerator,
Serializable {
    private NumberFormat numberFormat;

    public StandardPieToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardPieToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String generateToolTip(PieDataset pieDataset, Comparable comparable, int n) {
        String string = null;
        Number number = pieDataset.getValue(comparable);
        if (number != null) {
            String string2 = comparable.toString();
            string = string2 + " = " + this.numberFormat.format(number);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardPieToolTipGenerator) {
            StandardPieToolTipGenerator standardPieToolTipGenerator = (StandardPieToolTipGenerator)object;
            if (this.numberFormat == null) {
                return standardPieToolTipGenerator.getNumberFormat() == null;
            }
            return this.numberFormat.equals(standardPieToolTipGenerator.getNumberFormat());
        }
        return false;
    }
}

