/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.tooltips;

import java.io.Serializable;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;
import org.jfree.data.time.TimeSeriesCollection;

public class SymbolicXYToolTipGenerator
implements XYToolTipGenerator,
Serializable {
    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string;
        Object object;
        String string2;
        if (xYDataset instanceof YisSymbolic) {
            string2 = ((YisSymbolic)((Object)xYDataset)).getYSymbolicValue(n, n2);
        } else {
            object = xYDataset.getYValue(n, n2);
            string2 = Double.toString(SymbolicXYToolTipGenerator.round(((Number)object).doubleValue(), 2));
        }
        if (xYDataset instanceof XisSymbolic) {
            string = ((XisSymbolic)((Object)xYDataset)).getXSymbolicValue(n, n2);
        } else if (xYDataset instanceof TimeSeriesCollection) {
            object = ((TimeSeriesCollection)xYDataset).getSeries(n).getTimePeriod(n2);
            string = object.toString();
        } else {
            object = xYDataset.getXValue(n, n2);
            string = Double.toString(SymbolicXYToolTipGenerator.round(((Number)object).doubleValue(), 2));
        }
        return "X: " + string + ", Y: " + string2;
    }

    private static double round(double d, int n) {
        if (n <= 0) {
            return Math.floor(d + 0.5);
        }
        double d2 = Math.pow(10.0, n);
        double d3 = Math.floor(d * d2 + 0.5);
        return d3 / d2;
    }
}

