/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class MovingAverage {
    public static TimeSeries createMovingAverage(TimeSeries timeSeries, String string, int n, int n2) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 1.");
        }
        TimeSeries timeSeries2 = new TimeSeries(string, timeSeries.getTimePeriodClass());
        if (timeSeries.getItemCount() > 0) {
            long l = timeSeries.getDataPair(0).getPeriod().getSerialIndex() + (long)n2;
            int n3 = timeSeries.getItemCount() - 1;
            while (n3 >= 0) {
                TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataPair(n3);
                RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
                long l2 = regularTimePeriod.getSerialIndex();
                Number number = timeSeriesDataItem.getValue();
                if (l2 >= l) {
                    int n4 = 0;
                    double d = 0.0;
                    long l3 = regularTimePeriod.getSerialIndex() - (long)n;
                    int n5 = 0;
                    boolean bl = false;
                    while (n5 < n && !bl) {
                        if (n3 - n5 >= 0) {
                            TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getDataPair(n3 - n5);
                            RegularTimePeriod regularTimePeriod2 = timeSeriesDataItem2.getPeriod();
                            Number number2 = timeSeriesDataItem2.getValue();
                            long l4 = regularTimePeriod2.getSerialIndex();
                            if (l4 > l3) {
                                if (number2 != null) {
                                    d += number2.doubleValue();
                                    ++n4;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        ++n5;
                    }
                    if (n4 > 0) {
                        timeSeries2.add(regularTimePeriod, d / (double)n4);
                    } else {
                        timeSeries2.add(regularTimePeriod, null);
                    }
                }
                --n3;
            }
        }
        return timeSeries2;
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, long l, long l2) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        int n = 0;
        while (n < xYDataset.getSeriesCount()) {
            XYSeries xYSeries = MovingAverage.createMovingAverage(xYDataset, n, xYDataset.getSeriesName(n) + string, l, l2);
            xYSeriesCollection.addSeries(xYSeries);
            ++n;
        }
        return xYSeriesCollection;
    }

    public static XYSeries createMovingAverage(XYDataset xYDataset, int n, String string, long l, long l2) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source (XYDataset).");
        }
        if (l < 1L) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodMilliseconds must be greater than or equal to 1.");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : skipMilliseconds must be greater than or equal to 0.");
        }
        XYSeries xYSeries = new XYSeries(string);
        if (xYDataset.getItemCount(n) > 0) {
            double d = xYDataset.getXValue(n, 0).doubleValue() + (double)l2;
            int n2 = xYDataset.getItemCount(n) - 1;
            while (n2 >= 0) {
                double d2 = xYDataset.getXValue(n, n2).doubleValue();
                double d3 = xYDataset.getYValue(n, n2).doubleValue();
                if (d2 >= d) {
                    int n3 = 0;
                    double d4 = 0.0;
                    double d5 = d2 - (double)l;
                    int n4 = 0;
                    boolean bl = false;
                    while (!bl) {
                        if (n2 - n4 >= 0) {
                            double d6 = xYDataset.getXValue(n, n2 - n4).doubleValue();
                            Number number = xYDataset.getYValue(n, n2 - n4);
                            if (d6 > d5) {
                                if (number != null) {
                                    d4 += number.doubleValue();
                                    ++n3;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        ++n4;
                    }
                    if (n3 > 0) {
                        xYSeries.add(d2, d4 / (double)n3);
                    } else {
                        xYSeries.add(d2, (Number)null);
                    }
                }
                --n2;
            }
        }
        return xYSeries;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries timeSeries, String string, int n) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 2.");
        }
        TimeSeries timeSeries2 = new TimeSeries(string, timeSeries.getTimePeriodClass());
        double d = 0.0;
        int n2 = 0;
        while (n2 < timeSeries.getItemCount()) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataPair(n2);
            RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
            d += timeSeriesDataItem.getValue().doubleValue();
            if (n2 > n - 1) {
                TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getDataPair(n2 - n);
                timeSeries2.add(regularTimePeriod, (d -= timeSeriesDataItem2.getValue().doubleValue()) / (double)n);
            } else if (n2 == n - 1) {
                timeSeries2.add(regularTimePeriod, d / (double)n);
            }
            ++n2;
        }
        return timeSeries2;
    }
}

