/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class DatRecord
extends Record {
    public static final short sid = 4195;
    private short field_1_options;
    private BitField horizontalBorder = new BitField(1);
    private BitField verticalBorder = new BitField(2);
    private BitField border = new BitField(4);
    private BitField showSeriesKey = new BitField(8);

    public DatRecord() {
    }

    public DatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4195) {
            throw new RecordFormatException("Not a Dat record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_options = LittleEndian.getShort(data, 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Dat]\n");
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )\n");
        buffer.append("         .horizontalBorder         = ").append(this.isHorizontalBorder()).append('\n');
        buffer.append("         .verticalBorder           = ").append(this.isVerticalBorder()).append('\n');
        buffer.append("         .border                   = ").append(this.isBorder()).append('\n');
        buffer.append("         .showSeriesKey            = ").append(this.isShowSeriesKey()).append('\n');
        buffer.append("[/Dat]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4195);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4195;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public void setOptions(short field_1_options) {
        this.field_1_options = field_1_options;
    }

    public void setHorizontalBorder(boolean value) {
        this.field_1_options = this.horizontalBorder.setShortBoolean(this.field_1_options, value);
    }

    public boolean isHorizontalBorder() {
        return this.horizontalBorder.isSet(this.field_1_options);
    }

    public void setVerticalBorder(boolean value) {
        this.field_1_options = this.verticalBorder.setShortBoolean(this.field_1_options, value);
    }

    public boolean isVerticalBorder() {
        return this.verticalBorder.isSet(this.field_1_options);
    }

    public void setBorder(boolean value) {
        this.field_1_options = this.border.setShortBoolean(this.field_1_options, value);
    }

    public boolean isBorder() {
        return this.border.isSet(this.field_1_options);
    }

    public void setShowSeriesKey(boolean value) {
        this.field_1_options = this.showSeriesKey.setShortBoolean(this.field_1_options, value);
    }

    public boolean isShowSeriesKey() {
        return this.showSeriesKey.isSet(this.field_1_options);
    }
}

