/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.ValueReferencePtg;

public class FormulaParser {
    private String formulaString;
    private int pointer = 0;
    private Stack operationsList = new Stack();
    private Stack operandsList = new Stack();
    private List result = new ArrayList();
    private int numParen;
    private static char TAB = (char)9;
    private static char CR = (char)10;
    private char Look;

    public FormulaParser(String formula) {
        this.formulaString = formula;
        this.pointer = 0;
    }

    private void GetChar() {
        this.Look = this.formulaString.charAt(this.pointer++);
        System.out.println("Got char: " + this.Look);
    }

    private void Error(String s) {
        System.out.println("Error: " + s);
    }

    private void Abort(String s) {
        this.Error(s);
        throw new RuntimeException("Cannot Parse, sorry");
    }

    private void Expected(String s) {
        this.Abort(s + " Expected");
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c);
    }

    private boolean IsDigit(char c) {
        System.out.println("Checking digit for" + c);
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c);
    }

    private boolean IsAddop(char c) {
        return c == '+' || c == '-';
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (this.IsWhite(this.Look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.Look != x) {
            this.Expected("" + x + "");
        } else {
            this.GetChar();
            this.SkipWhite();
        }
    }

    private String GetName() {
        String Token = "";
        if (!this.IsAlpha(this.Look)) {
            this.Expected("Name");
        }
        while (this.IsAlNum(this.Look)) {
            Token = Token + Character.toUpperCase(this.Look);
            this.GetChar();
        }
        this.SkipWhite();
        return Token;
    }

    private String GetNum() {
        String Value = "";
        if (!this.IsDigit(this.Look)) {
            this.Expected("Integer");
        }
        while (this.IsDigit(this.Look)) {
            Value = Value + this.Look;
            this.GetChar();
        }
        this.SkipWhite();
        return Value;
    }

    private void Emit(String s) {
        System.out.print(TAB + s);
    }

    private void EmitLn(String s) {
        this.Emit(s);
        System.out.println();
    }

    private void Ident() {
        String Name = this.GetName();
        if (this.Look == '(') {
            this.Match('(');
            this.Match(')');
        } else {
            boolean cellRef = true;
            if (cellRef) {
                this.operationsList.add(new ValueReferencePtg());
            }
        }
    }

    private void Factor() {
        if (this.Look == '(') {
            this.Match('(');
            this.operationsList.add(new ParenthesisPtg());
            this.Expression();
            this.Match(')');
            this.operationsList.add(new ParenthesisPtg());
            return;
        }
        if (this.IsAlpha(this.Look)) {
            this.Ident();
        } else {
            IntPtg p = new IntPtg();
            p.setValue(Short.parseShort(this.GetNum()));
            this.operandsList.add(p);
        }
    }

    private void Multiply() {
        this.Match('*');
        this.Factor();
        this.operationsList.add(new MultiplyPtg());
    }

    private void Divide() {
        this.Match('/');
        this.Factor();
        this.operationsList.add(new DividePtg());
    }

    private void Term() {
        this.Factor();
        while (this.Look == '*' || this.Look == '/') {
            if (this.Look == '*') {
                this.Multiply();
            }
            if (this.Look != '/') continue;
            this.Divide();
        }
    }

    private void Add() {
        this.Match('+');
        this.Term();
        this.operationsList.add(new AddPtg());
    }

    private void Subtract() {
        this.Match('-');
        this.Term();
        this.operationsList.add(new SubtractPtg());
    }

    private void Expression() {
        if (this.IsAddop(this.Look)) {
            this.EmitLn("CLR D0");
        } else {
            this.Term();
        }
        while (this.IsAddop(this.Look)) {
            this.EmitLn("MOVE D0,-(SP)");
            if (this.Look == '+') {
                this.Add();
            }
            if (this.Look != '-') continue;
            this.Subtract();
        }
    }

    private void Init() {
        this.GetChar();
        this.SkipWhite();
    }

    public void parse() {
        this.Init();
        this.Expression();
        this.tokenToRPN();
    }

    private void tokenToRPN() {
        int numOper = 0;
        int numOnStack = 0;
        this.result.add(this.operandsList.pop());
        ++numOnStack;
        while (!this.operationsList.isEmpty()) {
            OperationPtg op = (OperationPtg)this.operationsList.pop();
            if (op instanceof ParenthesisPtg) {
                // empty if block
            }
            numOper = op.getNumberOfOperands();
            while (numOper > 0) {
                if (numOnStack == 0) {
                    this.result.add(this.operandsList.pop());
                } else {
                    --numOnStack;
                }
                --numOper;
            }
            this.result.add(op);
            ++numOnStack;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.result.size()) {
            buf.append(((Ptg)this.result.get(i)).toFormulaString());
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] argv) {
        FormulaParser fp = new FormulaParser(argv[0] + ";");
        fp.parse();
        System.out.println(fp.toString());
    }
}

