/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.BlockWritable;

public class PropertyBlock
extends BigBlock {
    private static final int _properties_per_block = 4;
    private Property[] _properties = new Property[4];

    private PropertyBlock(Property[] properties, int offset) {
        int j = 0;
        while (j < 4) {
            this._properties[j] = properties[j + offset];
            ++j;
        }
    }

    public static BlockWritable[] createPropertyBlockArray(List properties) {
        int block_count = (properties.size() + 4 - 1) / 4;
        Property[] to_be_written = new Property[block_count * 4];
        System.arraycopy(properties.toArray(new Property[0]), 0, to_be_written, 0, properties.size());
        int j = properties.size();
        while (j < to_be_written.length) {
            to_be_written[j] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
            ++j;
        }
        BlockWritable[] rvalue = new BlockWritable[block_count];
        int j2 = 0;
        while (j2 < block_count) {
            rvalue[j2] = new PropertyBlock(to_be_written, j2 * 4);
            ++j2;
        }
        return rvalue;
    }

    void writeData(OutputStream stream) throws IOException {
        int j = 0;
        while (j < 4) {
            this._properties[j].writeData(stream);
            ++j;
        }
    }
}

