/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHBlock;
import bsh.BSHFormalParameters;
import bsh.BSHReturnType;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHMethodDeclaration
extends SimpleNode {
    String name;
    BSHFormalParameters params;
    BSHBlock block;
    Object returnType;
    Modifiers modifiers;
    int numThrows = 0;

    BSHMethodDeclaration(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.block == null) {
            this.evalNodes(callStack, interpreter);
        }
        NameSpace nameSpace = callStack.top();
        BshMethod bshMethod = new BshMethod(this, nameSpace, this.modifiers);
        try {
            nameSpace.setMethod(this.name, bshMethod);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
        return Primitive.VOID;
    }

    private void evalNodes(CallStack callStack, Interpreter interpreter) throws EvalError {
        Node node = this.jjtGetChild(0);
        int n = 1;
        if (node instanceof BSHReturnType) {
            this.returnType = ((BSHReturnType)node).getReturnType(callStack, interpreter);
            this.params = (BSHFormalParameters)this.jjtGetChild(1);
            this.block = (BSHBlock)this.jjtGetChild(2 + this.numThrows);
            ++n;
        } else {
            this.params = (BSHFormalParameters)this.jjtGetChild(0);
            this.block = (BSHBlock)this.jjtGetChild(1 + this.numThrows);
        }
        int n2 = n;
        while (n2 < this.numThrows + n) {
            ((BSHAmbiguousName)this.jjtGetChild(n2)).toClass(callStack, interpreter);
            ++n2;
        }
        this.params.eval(callStack, interpreter);
        if (interpreter.getStrictJava()) {
            int n3 = 0;
            while (n3 < this.params.argTypes.length) {
                if (this.params.argTypes[n3] == null) {
                    throw new EvalError("(Strict Java Mode) Undeclared argument type, parameter: " + this.params.argNames[n3] + " in method: " + this.name, this, null);
                }
                ++n3;
            }
            if (this.returnType == null) {
                throw new EvalError("(Strict Java Mode) Undeclared return type for method: " + this.name, this, null);
            }
        }
    }

    public String toString() {
        return "MethodDeclaration: " + this.name;
    }
}

