/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.Size2D;
import org.jfree.ui.Spacer;
import org.jfree.util.ObjectUtils;

public class TextBox
implements Serializable {
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(1.0f);
    private Spacer interiorGap = new Spacer(1, 3.0, 1.0, 3.0, 1.0);
    private transient Paint backgroundPaint = new Color(255, 255, 192);
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 2.0;
    private double shadowYOffset = 2.0;
    private TextBlock textBlock;

    public TextBox() {
        this((TextBlock)null);
    }

    public TextBox(String text) {
        this((TextBlock)null);
        if (text != null) {
            this.textBlock = new TextBlock();
            this.textBlock.addLine(text, new Font("SansSerif", 0, 10), Color.black);
        }
    }

    public TextBox(TextBlock block) {
        this.textBlock = block;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public Spacer getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(Spacer gap) {
        this.interiorGap = gap;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public TextBlock getTextBlock() {
        return this.textBlock;
    }

    public void setTextBlock(TextBlock block) {
        this.textBlock = block;
    }

    public void draw(Graphics2D g2, float x, float y, RectangleAnchor anchor) {
        Size2D d1 = this.textBlock.calculateDimensions(g2);
        double w = this.interiorGap.getAdjustedWidth(d1.getWidth());
        double h = this.interiorGap.getAdjustedHeight(d1.getHeight());
        Size2D d2 = new Size2D(w, h);
        Rectangle2D bounds = RectangleAnchor.createRectangle(d2, x, y, anchor);
        if (this.shadowPaint != null) {
            Rectangle2D.Double shadow = new Rectangle2D.Double(bounds.getX() + this.shadowXOffset, bounds.getY() + this.shadowYOffset, bounds.getWidth(), bounds.getHeight());
            g2.setPaint(this.shadowPaint);
            g2.fill(shadow);
        }
        if (this.backgroundPaint != null) {
            g2.setPaint(this.backgroundPaint);
            g2.fill(bounds);
        }
        if (this.outlinePaint != null && this.outlineStroke != null) {
            g2.setPaint(this.outlinePaint);
            g2.setStroke(this.outlineStroke);
            g2.draw(bounds);
        }
        this.textBlock.draw(g2, (float)bounds.getCenterX(), (float)bounds.getCenterY(), TextBlockAnchor.CENTER);
    }

    public double getHeight(Graphics2D g2) {
        Size2D d = this.textBlock.calculateDimensions(g2);
        return this.interiorGap.getAdjustedHeight(d.getHeight());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextBox) {
            TextBox tb = (TextBox)obj;
            boolean b0 = ObjectUtils.equal(this.outlinePaint, tb.outlinePaint);
            boolean b1 = ObjectUtils.equal(this.outlineStroke, tb.outlineStroke);
            boolean b2 = ObjectUtils.equal(this.interiorGap, tb.interiorGap);
            boolean b3 = ObjectUtils.equal(this.backgroundPaint, tb.backgroundPaint);
            boolean b4 = ObjectUtils.equal(this.shadowPaint, tb.shadowPaint);
            boolean b5 = this.shadowXOffset == tb.shadowXOffset;
            boolean b6 = this.shadowYOffset == tb.shadowYOffset;
            boolean b7 = ObjectUtils.equal(this.textBlock, tb.textBlock);
            return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.outlinePaint, stream);
        SerialUtilities.writeStroke(this.outlineStroke, stream);
        SerialUtilities.writePaint(this.backgroundPaint, stream);
        SerialUtilities.writePaint(this.shadowPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.outlinePaint = SerialUtilities.readPaint(stream);
        this.outlineStroke = SerialUtilities.readStroke(stream);
        this.backgroundPaint = SerialUtilities.readPaint(stream);
        this.shadowPaint = SerialUtilities.readPaint(stream);
    }
}

