/*
 * Created on 09/05/2004
 *
 */
package it.businesslogic.ireport.chart;

import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

/**
 * This class store the chart build information.
 *  
 * @author Egon
 *
 */
public final class IReportChartProperties {

	public static final String CHART_LEGEND_POSITION_NORTH 	= "north";
	public static final String CHART_LEGEND_POSITION_SOUTH 	= "south";
	public static final String CHART_LEGEND_POSITION_EAST 		= "east";
	public static final String CHART_LEGEND_POSITION_WEST  	= "west";
	public static final String CHART_LEGEND_POSITION_NORTHEAST 	= "northeast";
	public static final String CHART_LEGEND_POSITION_NORTHWEST 	= "northwest";
	public static final String CHART_LEGEND_POSITION_SOUTHEAST 	= "southeast";
	public static final String CHART_LEGEND_POSITION_SOUTHWEST 	= "southwest";
	
	public static final String CHART_DATASOURCE_SERIES_ROWS 	= "rows";
	public static final String CHART_DATASOURCE_SERIES_COLUMNS 	= "columns";
	
	public static final String CHART_TYPE_ORIENTATION_VERTICAL 		= "vertical";
	public static final String CHART_TYPE_ORIENTATION_HORIZONTAL 	= "horizontal";

	private static final int DATASOURCE_FIELD_NAME_INDEX	 	= 0;
	private static final int DATASOURCE_FIELD_LABEL_INDEX	 	= 1;
	private static final int DATASOURCE_FIELD_COLOR_INDEX	 	= 2;
	private static final int DATASOURCE_FIELD_IMAGE_INDEX	 	= 3;
	private static final int DATASOURCE_FIELD_SYMBOL_INDEX	 	= 4;
	private static final int DATASOURCE_FIELD_ATTRIBUTE_COUNT 	= 5;
	
																		//class - see getChartPropertyObject()
	private static final String CHARTS_FACTORY 		= "chartFactory";	//String
	private static final String CHARTS_NAME		 	= "name";			//String
	private static final String CHARTS_DESCRIPTION 	= "description";	//String
	private static final String CHARTS_TITLE		 	= "title";			//String
	private static final String CHARTS_TITLE_COLOR	 	= "titleColor";		//java.awt.Color
	private static final String CHARTS_WIDTH	 		= "width";			//Integer
	private static final String CHARTS_HEIGHT 			= "height";			//Integer
	private static final String CHARTS_BACKGROUND_COLOR	 	= "backgroundColor";	//java.awt.Color
	private static final String CHARTS_LEGEND				= "showLegend";			//Boolean
	private static final String CHARTS_COUNT 				= "chartCount";			//Integer
	private static final String CHART_ID		 			= "id";					//String
	private static final String CHART_TYPE		 			= "type";				//Integer
	private static final String CHART_HORIZONTAL_ORIENTATION	= "horizontalOrientation";			//Boolean
	private static final String CHART_FOREGROUND_COLOR	 		= "foregroundColor";			//java.awt.Color
	private static final String CHART_DATASOURCE_NAME	 		= "dataSourceName"; 		//String
	private static final String CHART_DATASOURCE_FIELD_NAME	 	= "dataSourceFieldName";	//String
	private static final String CHART_DATASOURCE_FIELD_LABEL 	= "dataSourceFieldLabel";	//String
	private static final String CHART_DATASOURCE_FIELD_COLOR 	= "dataSourceFieldColor";	//java.awt.Color
	private static final String CHART_DATASOURCE_FIELD_IMAGE 	= "dataSourceFieldImage";	//String
	private static final String CHART_DATASOURCE_FIELD_SYMBOL 	= "dataSourceFieldSymbol";	//String
	private static final String CHART_DATASOURCE_FIELD_COUNT 	= "dataSourceFieldCount";	//Integer

	protected String name;
	protected String factory;
	protected int width;
	protected int height;
	protected int count;
	
	protected Vector ids = new Vector();
	protected Vector types = new Vector();
	protected Vector orientation = new Vector();
	protected Vector background = new Vector();
	
	protected Vector titleText = new Vector();
	protected Vector titleFont = new Vector();
	protected Vector titleColor = new Vector();
	
	protected Vector xAxisTitleText = new Vector();
	protected Vector yAxisTitleText = new Vector();
	protected Vector zAxisTitleText = new Vector();
	
	protected Vector xAxisTitleFont = new Vector();
	protected Vector yAxisTitleFont = new Vector();
	protected Vector zAxisTitleFont = new Vector();
	
	protected Vector xAxisTitleColor = new Vector();
	protected Vector yAxisTitleColor = new Vector();
	protected Vector zAxisTitleColor = new Vector();
	
	protected Vector legendVisible = new Vector();
	protected Vector legendPosition = new Vector();
	
	protected Vector xAxisGridVisible = new Vector();
	protected Vector yAxisGridVisible = new Vector();
	protected Vector zAxisGridVisible = new Vector();

	protected Vector datasouceName = new Vector();
	protected Vector datasouceSeries = new Vector();

	protected Vector datasouceFieldCount = new Vector();//contains object array
	protected Vector datasouceFields = new Vector();//contains object array



	/**
	 * 
	 */
	public IReportChartProperties() {
		super();
		
		setCount(1);
	}


	public void setFactory(String chartFactory){
		factory = chartFactory;
	} 	
	
	public String getFactory(){
		return factory;
	}

	public void setName(String chartName){
		name = chartName;
	} 	
	
	public String getName(){
		return name;
	}

	public void setWidth(int width){
		this.width = width;
	} 	
	
	public int getWidth(){
		return width;
	}

	public void setHeight(int height){
		this.height = height;
	} 	
	
	public int getHeight(){
		return height;
	}

	public void setCount(int count){
		
		//never < 1
		if(count < 1){
			return;
		}
		
		this.count = count;
		
		ids.setSize(count);
		types.setSize(count);
		orientation.setSize(count);
		background.setSize(count);
	
		titleText.setSize(count);
		titleFont.setSize(count);
		titleColor.setSize(count);
	
		xAxisTitleText.setSize(count);
		yAxisTitleText.setSize(count);
		zAxisTitleText.setSize(count);
	
		xAxisTitleFont.setSize(count);
		yAxisTitleFont.setSize(count);
		zAxisTitleFont.setSize(count);
	
		xAxisTitleColor.setSize(count);
		yAxisTitleColor.setSize(count);
		zAxisTitleColor.setSize(count);
	
		legendVisible.setSize(count);
		legendPosition.setSize(count);

		xAxisGridVisible.setSize(count);
		yAxisGridVisible.setSize(count);
		zAxisGridVisible.setSize(count);

		datasouceName.setSize(count);
		datasouceSeries.setSize(count);

		datasouceFieldCount.setSize(count);
		datasouceFields.setSize(count);
		
		Object row;
		for(int i = 0; i < count; i++){
			
			row = datasouceFields.elementAt(i);
			if(!(row instanceof Vector)){
				datasouceFields.setElementAt(new Vector(), i);
			}
		}
	} 	
	
	public int getCount(){
		return count;
	}


	public void setID(int index, String id){
		ids.setElementAt(id, index);
	} 	
	
	public String getID(int index){
		return (String) ids.elementAt(index);
	}

	public void setType(int index, int type){
		types.setElementAt(new Integer(type), index);
	} 	
	
	public int getType(int index){
		Integer i = (Integer) types.elementAt(index);
		
		return i != null ? i.intValue() : 0;
	}

	public void setChartTypeOrientation(int index, String value){
		orientation.setElementAt(value, index);
	} 	
	
	public String getChartTypeOrientation(int index){
		return (String) orientation.elementAt(index);
	}
	
	public void setBackground(int index, Color color){
		background.setElementAt(color, index);
	} 	
	
	public Color getBackground(int index){
		return (Color) background.elementAt(index);
	}

	public void setTitle(int index, String title){
		titleText.setElementAt(title, index);
	} 	
	
	public String getTitle(int index){
		return (String) titleText.elementAt(index);
	}

	public void setTitleColor(int index, Color color){
		titleColor.setElementAt(color, index);
	} 	
	
	public Color getTitleColor(int index){
		return (Color) titleColor.elementAt(index);
	}

	public void setTitleFont(int index, Font font){
		titleFont.setElementAt(font, index);
	} 	
	
	public Font getTitleFont(int index){
		return (Font) titleFont.elementAt(index);
	}

	public void setLegendVisible(int index, boolean visible){
		legendVisible.setElementAt(new Boolean(visible), index);
	} 	
	
	public boolean isLegendVisible(int index){
		
		Boolean value = (Boolean) legendVisible.elementAt(index);
		return value != null ? value.booleanValue() : false;
	}

	public void setLegendPosition(int index, String position){
		legendPosition.setElementAt(position, index);
	} 	
	
	public String getLegendPosition(int index){
		return (String) legendPosition.elementAt(index);
	}

	public void setXAxisGridVisible(int index, boolean visible){
		xAxisGridVisible.setElementAt(new Boolean(visible), index);
	} 	
	
	public boolean isXAxisGridVisible(int index){
		
		Boolean value = (Boolean) xAxisGridVisible.elementAt(index);
		return value != null ? value.booleanValue() : false;
	}

	public void setYAxisGridVisible(int index, boolean visible){
		yAxisGridVisible.setElementAt(new Boolean(visible), index);
	} 	
	
	public boolean isYAxisGridVisible(int index){
		
		Boolean value = (Boolean) yAxisGridVisible.elementAt(index);
		return value != null ? value.booleanValue() : false;
	}

	public void setZAxisGridVisible(int index, boolean visible){
		zAxisGridVisible.setElementAt(new Boolean(visible), index);
	} 	
	
	public boolean isZAxisGridVisible(int index){
		
		Boolean value = (Boolean) zAxisGridVisible.elementAt(index);
		return value != null ? value.booleanValue() : false;
	}

	public void setDatasourceName(int index, String name){
		datasouceName.setElementAt(name, index);
	} 	
	
	public String getDatasourceName(int index){
		return (String) datasouceName.elementAt(index);
	}

	public void setDatasourceSeries(int index, String series){
		datasouceSeries.setElementAt(series, index);
	} 	
	
	public String getDatasourceSeries(int index){
		return (String) datasouceSeries.elementAt(index);
	}

	public void setDatasourceFieldCount(int index, int count){
		datasouceFieldCount.setElementAt(new Integer(count), index);
		
		Vector fields = (Vector) datasouceFields.elementAt(index);
		fields.setSize(count);
	}

	public int getDatasourceFieldCount(int index){
		Integer value = (Integer) datasouceFieldCount.elementAt(index);
		return value != null ? value.intValue() : 0;
	}

	private Object getDatasourceFieldValue(int chartIndex, int fieldIndex, int i){

		Vector chartFields = (Vector) datasouceFields.elementAt(chartIndex);
		Object values = chartFields.elementAt(fieldIndex);
		
		if(values instanceof Object[]){
			return ((Object[]) values)[i];			
		}else{
			return null;
		}
	}

	public String getDatasourceFieldName(int chartIndex, int fieldIndex){
		return (String) getDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_NAME_INDEX);
	}

	public String getDatasourceFieldLabel(int chartIndex, int fieldIndex){
		return (String) getDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_LABEL_INDEX);
	}

	public Color getDatasourceFieldColor(int chartIndex, int fieldIndex){
		return (Color) getDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_COLOR_INDEX);
	}

	public String getDatasourceFieldImage(int chartIndex, int fieldIndex){
		return (String) getDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_IMAGE_INDEX);
	}

	public String getDatasourceFieldSymbol(int chartIndex, int fieldIndex){
		return (String) getDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_SYMBOL_INDEX);
	}
	

	private void setDatasourceFieldValue(int chartIndex, int fieldIndex, int i, Object value){

		Vector chartFields = (Vector) datasouceFields.elementAt(chartIndex);
		Object values = chartFields.elementAt(fieldIndex);
		
		
		if(values instanceof Object[]){
			((Object[]) values)[i] = value;			
		}else{
			values = new Object[DATASOURCE_FIELD_ATTRIBUTE_COUNT];
			((Object[]) values)[i] = value;			
		}
	}

	public void setDatasourceFieldName(int chartIndex, int fieldIndex, String name){
		setDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_NAME_INDEX, name);
	}

	public void setDatasourceFieldLabel(int chartIndex, int fieldIndex, String label){
		setDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_LABEL_INDEX, label);
	}

	public void setDatasourceFieldImage(int chartIndex, int fieldIndex, String image){
		setDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_IMAGE_INDEX, image);
	}

	public void setDatasourceFieldSymbol(int chartIndex, int fieldIndex, String symbol){
		setDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_SYMBOL_INDEX, symbol);
	}

	public void setDatasourceFieldColor(int chartIndex, int fieldIndex, Color color){
		setDatasourceFieldValue(chartIndex, fieldIndex, DATASOURCE_FIELD_COLOR_INDEX, color);
	}


	public void setXAxisTitle(int index, String title){
		xAxisTitleText.setElementAt(title, index);
	} 	
	
	public String getXAxisTitle(int index){
		return (String) xAxisTitleText.elementAt(index);
	}

	public void setXAxisTitleColor(int index, Color color){
		xAxisTitleColor.setElementAt(color, index);
	} 	
	
	public Color getXAxisTitleColor(int index){
		return (Color) xAxisTitleColor.elementAt(index);
	}

	public void setXAxisTitleFont(int index, Font font){
		xAxisTitleFont.setElementAt(font, index);
	} 	
	
	public Font getXAxisTitleFont(int index){
		return (Font) xAxisTitleFont.elementAt(index);
	}


	public void setYAxisTitle(int index, String title){
		yAxisTitleText.setElementAt(title, index);
	} 	
	
	public String getYAxisTitle(int index){
		return (String) yAxisTitleText.elementAt(index);
	}

	public void setYAxisTitleColor(int index, Color color){
		yAxisTitleColor.setElementAt(color, index);
	} 	
	
	public Color getYAxisTitleColor(int index){
		return (Color) yAxisTitleColor.elementAt(index);
	}

	public void setYAxisTitleFont(int index, Font font){
		yAxisTitleFont.setElementAt(font, index);
	} 	
	
	public Font getYAxisTitleFont(int index){
		return (Font) yAxisTitleFont.elementAt(index);
	}


	public void setZAxisTitle(int index, String title){
		zAxisTitleText.setElementAt(title, index);
	} 	
	
	public String getZAxisTitle(int index){
		return (String) zAxisTitleText.elementAt(index);
	}

	public void setZAxisTitleColor(int index, Color color){
		zAxisTitleColor.setElementAt(color, index);
	} 	
	
	public Color getZAxisTitleColor(int index){
		return (Color) zAxisTitleColor.elementAt(index);
	}

	public void setZAxisTitleFont(int index, Font font){
		zAxisTitleFont.setElementAt(font, index);
	} 	
	
	public Font getZAxisTitleFont(int index){
		return (Font) zAxisTitleFont.elementAt(index);
	}






	/**
	 * Create a instance of IReportChartProperties from the text encoded form.
	 * 
	 * @param encodedChartProperties Chart properties encoded.
	 * @return IReportChartProperties instance. 
	 */
	public static IReportChartProperties getInstanceFromXMLPCData(String xmlPCDataEncoded){
		
		IReportChartProperties chartProp = new IReportChartProperties(); 
//		chartProp.chartProperties = convertXMLPCData2Properties(xmlPCDataEncoded);
		
		return chartProp;
	}

	public static IReportChartProperties getInstanceFromXMLFile(String xmlFileName) {
		return null;
	}

	/**
	 * Write charts properties in a XML file. 
	 * 
	 * @param xmlFileName The XML file name.
	 */
	public void writeToXMLFile(String xmlFileName){
		//no implemented yet
	}

}
