/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.util.Log;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.Parser;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParserFrontend {
    private Parser defaulthandler;
    private SAXParserFactory factory;
    private EntityResolver entityResolver;
    private boolean validateDTD;

    protected ParserFrontend(Parser parser) {
        if (parser == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = parser;
    }

    public boolean isValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean validateDTD) {
        this.validateDTD = validateDTD;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            if (this.isValidateDTD()) {
                try {
                    this.factory.setValidating(true);
                }
                catch (Exception ex) {
                    Log.debug("The parser will not validate the xml document.", ex);
                }
            }
        }
        return this.factory.newSAXParser();
    }

    public void setDefaultHandler(Parser handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = handler;
    }

    public Parser getDefaultHandler() {
        return this.defaulthandler;
    }

    protected Parser createDefaultHandler(URL contentBase) {
        Parser handler = this.getDefaultHandler().getInstance();
        if (contentBase != null) {
            handler.setConfigProperty("content-base", contentBase.toExternalForm());
        }
        return handler;
    }

    protected Object parse(InputSource input, URL contentBase) throws ElementDefinitionException {
        try {
            SAXParser parser = this.getParser();
            XMLReader reader = parser.getXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/validation", this.isValidateDTD());
            }
            catch (SAXException se) {
                Log.debug("The XMLReader will not validate the xml document.", se);
            }
            Parser handler = this.createDefaultHandler(contentBase);
            this.configureReader(reader, handler);
            try {
                reader.setContentHandler(handler);
                reader.setDTDHandler(handler);
                reader.setEntityResolver(this.getEntityResolver());
                reader.setErrorHandler(handler);
                reader.parse(input);
                return handler.getResult();
            }
            catch (IOException e) {
                throw new ElementDefinitionException(e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ElementDefinitionException(e);
        }
        catch (SAXException e) {
            throw new ElementDefinitionException(e);
        }
    }

    protected void configureReader(XMLReader reader, Parser handler) {
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler.getCommentHandler());
        }
        catch (SAXException se) {
            Log.debug("Comments are not supported by this SAX implementation.");
        }
    }

    public Object parse(URL file, URL contentBase) throws ElementDefinitionException, IOException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        BufferedInputStream bin = new BufferedInputStream(file.openStream());
        InputSource in = new InputSource(bin);
        in.setSystemId(file.toString());
        Object result = this.parse(in, contentBase);
        bin.close();
        return result;
    }
}

