/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.ReportElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

public class LineReportElement
extends GraphicReportElement {
    public String direction;

    public LineReportElement(int x, int y, int width, int height) {
        this(x, y, width, height, "TopDown");
    }

    public LineReportElement(int x, int y, int width, int height, String direction) {
        super(x, y, width, height);
        this.graphicElementPen = "Thin";
        this.bgcolor = Color.WHITE;
        this.fgcolor = Color.BLACK;
        this.direction = direction;
        this.setKey("line");
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        Stroke stroke;
        this.zoom_factor = zoom_factor;
        Point a = new Point(this.getZoomedDim(this.position.x - 10) + 10 - x_shift_origin, this.getZoomedDim(this.position.y - 10) + 10 - y_shift_origin);
        Point b = new Point(this.getZoomedDim(this.position.x + this.width - 10) + 10 - x_shift_origin, this.getZoomedDim(this.position.y + this.height - 10) + 10 - y_shift_origin);
        if (!this.direction.equalsIgnoreCase("TopDown")) {
            b.y = this.getZoomedDim(this.position.y - 10) + 10 - y_shift_origin;
            a.y = this.getZoomedDim(this.position.y + this.height - 10) + 10 - y_shift_origin;
        }
        if ((stroke = this.getPenStroke(this.getGraphicElementPen(), zoom_factor)) != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(stroke);
            g.setColor(this.fgcolor);
            g.drawLine(a.x, a.y, b.x, b.y);
            g.setStroke(oldStroke);
        }
    }

    public ReportElement cloneMe() {
        LineReportElement newReportElement = new LineReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof LineReportElement && source instanceof LineReportElement) {
            ((LineReportElement)destination).setDirection(new String(((LineReportElement)source).getDirection()));
        }
    }
}

