/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRField;
import it.businesslogic.ireport.connection.FieldNode;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JRXMLDataSource
implements JRDataSource {
    private FieldNode rootFieldNode = null;
    private String rowPath = "/";
    private FieldNode actualPath = null;

    public JRXMLDataSource(String uri, String rowPath) {
        this.rowPath = rowPath;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(uri);
            this.build(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JRXMLDataSource(File file, String rowPath) {
        this.rowPath = rowPath;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(file);
            this.build(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JRXMLDataSource(InputStream is, String rowPath) {
        this.rowPath = rowPath;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(is);
            this.build(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JRXMLDataSource(FieldNode rootFieldNode, String rowPath) {
        this.rowPath = rowPath;
        this.rootFieldNode = rootFieldNode;
    }

    private void build(Document doc) throws Exception {
        Element element = doc.getDocumentElement();
        this.rootFieldNode = this.createNode(element, null);
    }

    private FieldNode createNode(Node element, FieldNode parent) throws Exception {
        FieldNode cn = new FieldNode(element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            cn.getAttributes().setProperty(node.getNodeName(), node.getNodeValue());
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                this.createNode(node, cn);
                continue;
            }
            if (node.getNodeType() != 4 && node.getNodeType() != 3) continue;
            cn.setValue(node.getNodeValue());
        }
        if (parent != null) {
            parent.getChildren().add(cn);
        } else {
            parent = cn;
        }
        return parent;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String path = jRField.getDescription();
        Object val = this.getPathValue(this.rootFieldNode, path);
        return val;
    }

    public boolean next() throws JRException {
        return this.rootFieldNode.next(this.rowPath);
    }

    public String getActualPath() {
        String childPath = this.rowPath;
        childPath = this.rowPath.substring(this.rootFieldNode.getName().length() + 1);
        return this.rootFieldNode.getName() + "::" + this.rootFieldNode.getChildsPath(this.rowPath);
    }

    public static void main(String[] argv) {
        JRXMLDataSource ds = new JRXMLDataSource("C:\\test_ireport.xml", "/addressbook/address/ciccio");
        try {
            System.out.println("starting");
            while (ds.next()) {
                System.out.println(ds.getActualPath());
            }
            System.out.println("finishing");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object getPathValue(FieldNode startingNode, String path) {
        String tag = "";
        if (path == null) {
            return startingNode.getValue();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String sub_path = "";
        if (path.indexOf("+") >= 0) {
            sub_path = path.substring(path.indexOf("+") + 1);
            path = path.substring(0, path.indexOf("+") + 1);
        }
        if (path.indexOf("/") < 0) {
            if (path.indexOf("@") >= 0) {
                tag = path.substring(path.indexOf("@") + 1);
                return startingNode.getAttribute(tag);
            }
            if (path.indexOf("*") >= 0) {
                String childName = path.substring(path.indexOf("*") + 1);
                FieldNode fn = new FieldNode(startingNode.getName());
                fn.setAttributes(startingNode.getAttributes());
                fn.setChildren(startingNode.getChilddren(childName));
                return new JRXMLDataSource(fn, "/" + startingNode.getName() + "/" + childName);
            }
            if (path.indexOf("+") >= 0) {
                String childToTake = sub_path;
                childToTake = JRXMLDataSource.getNextNodeName(sub_path);
                return this.getSubPathValue(startingNode.getChild(childToTake), sub_path);
            }
            return startingNode.getValue();
        }
        path = path.substring(path.indexOf("/") + 1);
        path = path + sub_path;
        return this.getPathValue(startingNode.getNextChild(), path);
    }

    private Object getSubPathValue(FieldNode startingNode, String path) {
        String tag = "";
        if (path == null) {
            return startingNode.getValue() + "[" + path + "]";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.indexOf("/") < 0) {
            if (path.indexOf("@") >= 0) {
                tag = path.substring(path.indexOf("@") + 1);
                return startingNode.getAttribute(tag);
            }
            if (path.indexOf("*") >= 0) {
                String childName = path.substring(path.indexOf("*") + 1);
                FieldNode fn = new FieldNode(startingNode.getName());
                fn.setAttributes(startingNode.getAttributes());
                fn.setChildren(startingNode.getChilddren(childName));
                return new JRXMLDataSource(fn, "/" + startingNode.getName() + "/" + childName);
            }
            return startingNode.getValue();
        }
        String childToTake = path = path.substring(path.indexOf("/") + 1);
        childToTake = JRXMLDataSource.getNextNodeName(path);
        return this.getSubPathValue(startingNode.getChild(childToTake), path);
    }

    private static String getNextNodeName(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String childToTake = path;
        if (path.indexOf("/") >= 0) {
            childToTake = path.substring(0, path.indexOf("/"));
        }
        if (childToTake.indexOf("@") >= 0) {
            childToTake = childToTake.substring(0, path.indexOf("@"));
        }
        if (childToTake.indexOf("*") >= 0) {
            childToTake = childToTake.substring(0, path.indexOf("*"));
        }
        return childToTake;
    }
}

