/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ReportClassLoader
extends ClassLoader {
    private ArrayList fPathItems = new ArrayList();
    private ArrayList fPathChachedItems = new ArrayList();
    private HashMap cachedClasses = new HashMap();

    public ReportClassLoader() {
        this.rescanLibDirectory();
    }

    public void rescanLibDirectory() {
        if (MainFrame.getMainInstance() == null) {
            return;
        }
        MainFrame.getMainInstance();
        File lib_dir = new File(MainFrame.IREPORT_HOME_DIR, "lib");
        String classpath = Misc.nvl(System.getProperty("java.class.path"), "");
        if (!lib_dir.exists()) {
            StringBuffer stringBuffer = new StringBuffer().append("Cannot find lib in iReport home  directory (");
            MainFrame.getMainInstance();
            System.out.println(stringBuffer.append(MainFrame.IREPORT_HOME_DIR).append(")").toString());
            return;
        }
        File[] new_libs = lib_dir.listFiles();
        for (int i = 0; i < new_libs.length; ++i) {
            if (!new_libs[i].getName().toLowerCase().endsWith("jar") && !new_libs[i].getName().toLowerCase().endsWith("zip") || classpath.indexOf(new_libs[i].getName()) >= 0 || this.fPathChachedItems.contains(new_libs[i].getAbsolutePath())) continue;
            this.fPathChachedItems.add(new_libs[i].getAbsolutePath());
        }
    }

    public void addNoRelodablePath(String path) {
        if (!this.fPathChachedItems.contains(path)) {
            this.fPathChachedItems.add(path);
        }
    }

    public void setRelodablePaths(String classPath) {
        this.scanPath(classPath);
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new ArrayList(31);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            String pp = st.nextToken();
            this.fPathItems.add(pp);
        }
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public synchronized Class findClass(String name) throws ClassNotFoundException {
        if (this.cachedClasses.containsKey(name)) {
            return (Class)this.cachedClasses.get(name);
        }
        byte[] b = this.loadClassData(name);
        if (this.cachedClasses.containsKey(name)) {
            return (Class)this.cachedClasses.get(name);
        }
        return this.defineClass(name, b, 0, b.length);
    }

    private byte[] loadClassData(String className) throws ClassNotFoundException {
        String fileName;
        String path;
        int i;
        byte[] data = null;
        for (i = 0; i < this.fPathChachedItems.size(); ++i) {
            path = (String)this.fPathChachedItems.get(i);
            fileName = className.replace('.', File.separatorChar) + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName.replace(File.separatorChar, '/')) : this.loadFileData(path, fileName);
            if (data == null) continue;
            if (!this.cachedClasses.containsKey(className)) {
                this.cachedClasses.put(className, this.defineClass(className, data, 0, data.length));
            }
            return data;
        }
        for (i = 0; i < this.fPathItems.size(); ++i) {
            path = (String)this.fPathItems.get(i);
            fileName = className.replace('.', File.separatorChar) + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data == null) continue;
            return data;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] loadJarData(String path, String fileName) {
        int n;
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        stream = zipFile.getInputStream(entry);
        byte[] data = new byte[size];
        for (int pos = 0; pos < size; pos += n) {
            n = stream.read(data, pos, data.length - pos);
        }
        zipFile.close();
        byte[] byArray = data;
        Object var12_14 = null;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return byArray;
        catch (IOException e) {
            try {
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {}
        }
        return null;
    }
}

