/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.NumberEntry;
import it.businesslogic.ireport.gui.event.ValueChangedEvent;
import it.businesslogic.ireport.gui.event.ValueChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;

public class JNumberComboBox
extends JComboBox
implements KeyListener,
ActionListener,
FocusListener {
    private NumberFormat numberFormat = null;
    private Vector entries = new Vector();
    private double value;
    private double minValue;
    private double maxValue;
    private EventListenerList listenerList = null;
    private String postfix = "";
    static /* synthetic */ Class class$it$businesslogic$ireport$gui$event$ValueChangedListener;

    public JNumberComboBox() {
        this.setFocusCycleRoot(false);
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        this.setEditable(true);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).addFocusListener(this);
        }
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addActionListener(this);
    }

    public void addEntry(String name, double value) {
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            NumberEntry ne = (NumberEntry)e.nextElement();
            if (!ne.name.equals(name)) continue;
            ne.value = value;
            return;
        }
        NumberEntry entry = new NumberEntry(name, value);
        this.addItem(entry);
        this.entries.addElement(entry);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex > -1) {
            if (((NumberEntry)this.getSelectedItem()).value != this.value) {
                double oldValue = this.value;
                this.value = ((NumberEntry)this.getSelectedItem()).value;
                this.fireValueChangedListenerValueChanged(new ValueChangedEvent(this, oldValue, this.value));
            }
            this.setSelectedItem(this.numberFormat.format(this.value) + this.getPostfix());
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            Number num = this.numberFormat.parse("" + this.getSelectedItem());
            if (num.doubleValue() != this.value) {
                double oldValue = this.value;
                this.value = num.doubleValue();
                this.fireValueChangedListenerValueChanged(new ValueChangedEvent(this, oldValue, this.value));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            this.fireValueChangedListenerValueChanged(new ValueChangedEvent(this, this.value, this.value));
        }
        this.setSelectedItem(this.numberFormat.format(this.value) + this.getPostfix());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (this.value != value) {
            double oldValue = this.value;
            this.value = value;
            this.fireValueChangedListenerValueChanged(new ValueChangedEvent(this, oldValue, this.value));
        }
        this.setSelectedItem(this.numberFormat.format(this.value) + this.getPostfix());
    }

    public synchronized void addValueChangedListener(ValueChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$it$businesslogic$ireport$gui$event$ValueChangedListener == null ? (class$it$businesslogic$ireport$gui$event$ValueChangedListener = JNumberComboBox.class$("it.businesslogic.ireport.gui.event.ValueChangedListener")) : class$it$businesslogic$ireport$gui$event$ValueChangedListener, listener);
    }

    public synchronized void removeValueChangedListener(ValueChangedListener listener) {
        this.listenerList.remove(class$it$businesslogic$ireport$gui$event$ValueChangedListener == null ? (class$it$businesslogic$ireport$gui$event$ValueChangedListener = JNumberComboBox.class$("it.businesslogic.ireport.gui.event.ValueChangedListener")) : class$it$businesslogic$ireport$gui$event$ValueChangedListener, listener);
    }

    private void fireValueChangedListenerValueChanged(ValueChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$ValueChangedListener == null ? JNumberComboBox.class$("it.businesslogic.ireport.gui.event.ValueChangedListener") : class$it$businesslogic$ireport$gui$event$ValueChangedListener)) continue;
            ((ValueChangedListener)listeners[i + 1]).valueChanged(event);
        }
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

