/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.Unit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class OptionsDialog
extends JDialog
implements LanguageChangedListener {
    MainFrame mf = null;
    Unit[] units;
    List listOfLanguages;
    List listOfPLAF;
    private ButtonGroup buttonGroup1;
    private JButton jButtonApply;
    private JButton jButtonBackupDirectory;
    private JButton jButtonBorderTextColor;
    private JButton jButtonBrowseEditor;
    private JButton jButtonBrowseEditor1;
    private JButton jButtonBrowseEditor2;
    private JButton jButtonBrowseEditor3;
    private JButton jButtonBrowseEditor4;
    private JButton jButtonCancel;
    private JButton jButtonCompilationDir;
    private JButton jButtonOK;
    private JButton jButtonTemplate;
    private JCheckBox jCheckBoxAutoRegisterFields;
    private JCheckBox jCheckBoxAutosave;
    private JCheckBox jCheckBoxUseCurrentFilesDirectoryForCompiles;
    private JCheckBox jCheckBoxViewBorderText;
    private JCheckBox jCheckBoxViewGrid;
    private JCheckBox jCheckBoxViewRules;
    private JComboBox jComboBoxDefaultRulesUnit;
    private JComboBox jComboBoxLanguage;
    private JComboBox jComboBoxLookAndFeel;
    private JLabel jLabelAutoRegisterFields;
    private JLabel jLabelCSVViewer;
    private JLabel jLabelDefaultBackupDir;
    private JLabel jLabelDefaultUnit;
    private JLabel jLabelGridSize;
    private JLabel jLabelHTMLViewer;
    private JLabel jLabelLanguage;
    private JLabel jLabelLookAndFeel;
    private JLabel jLabelPDFViewer;
    private JLabel jLabelRecentFileListLength;
    private JLabel jLabelTemplateForNewDocs;
    private JLabel jLabelTextBorderColor;
    private JLabel jLabelViewBorderForTextElements;
    private JLabel jLabelViewGrid;
    private JLabel jLabelViewRules;
    private JLabel jLabelXLSViewer;
    private JNumberField jNumberFieldGridSize;
    private JNumberField jNumberFieldRecentFilesListLenght;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanel jPanelBackup;
    private JPanel jPanelComper;
    private JPanel jPanelCompileDir;
    private JPanel jPanelExternalEditor;
    private JPanel jPanelExternalPrograms;
    private JPanel jPanelGeneral;
    private JPanel jPanelViewers;
    private JRadioButton jRadioButton1_NoBackup;
    private JRadioButton jRadioButton2_ReplaceExtension;
    private JRadioButton jRadioButton3_AppendExtension;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldBackupDirectory;
    private JTextField jTextFieldCSVViewer;
    private JTextField jTextFieldCompilationDir;
    private JTextField jTextFieldEditor;
    private JTextField jTextFieldHTMLViewer;
    private JTextField jTextFieldPDFViewer;
    private JTextField jTextFieldTemplate;
    private JTextField jTextFieldXLSViewer;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        this.initComponents();
        DocumentListener listener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }

            public void insertUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }

            public void removeUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }
        };
        this.jTextFieldBackupDirectory.getDocument().addDocumentListener(listener);
        this.jTextFieldCSVViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldCompilationDir.getDocument().addDocumentListener(listener);
        this.jTextFieldEditor.getDocument().addDocumentListener(listener);
        this.jTextFieldHTMLViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldPDFViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldTemplate.getDocument().addDocumentListener(listener);
        this.jTextFieldXLSViewer.getDocument().addDocumentListener(listener);
        this.units = Unit.getStandardUnits();
        for (int i = 0; i < this.units.length; ++i) {
            this.jComboBoxDefaultRulesUnit.addItem(this.units[i] + "");
        }
        this.listOfLanguages = I18n.getListOfAvailLanguages();
        Object languageModel = null;
        String selectedLanguage = this.mf.getProperties().getProperty("Language");
        String selectedCountry = this.mf.getProperties().getProperty("Country");
        for (int i = 0; i < this.listOfLanguages.size(); ++i) {
            Locale lang = (Locale)this.listOfLanguages.get(i);
            LocaleAdapter adapter = new LocaleAdapter(lang);
            this.jComboBoxLanguage.addItem(adapter);
            if (!lang.getCountry().equals(selectedCountry) || !lang.getLanguage().equals(selectedLanguage)) continue;
            this.jComboBoxLanguage.setSelectedItem(adapter);
        }
        this.listOfPLAF = Misc.getAvailablePLAF();
        String selectedPAF = this.mf.getProperties().getProperty("LookAndFeel");
        for (int i = 0; i < this.listOfPLAF.size(); ++i) {
            String pnf = (String)this.listOfPLAF.get(i);
            this.jComboBoxLookAndFeel.addItem(pnf);
            if (!pnf.equals(selectedPAF)) continue;
            this.jComboBoxLookAndFeel.setSelectedItem(pnf);
        }
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        this.pack();
    }

    public void applyI18n() {
        this.jLabelRecentFileListLength.setText(I18n.getString("gui.OptionsDialog.LabelRecentFileListLength", "Num of recent files in file menu"));
        this.jLabelDefaultUnit.setText(I18n.getString("gui.OptionsDialog.LabelDefaultUnit", "Default unit"));
        this.jLabelViewRules.setText(I18n.getString("gui.OptionsDialog.LabelViewRules", "View rules"));
        this.jLabelViewGrid.setText(I18n.getString("gui.OptionsDialog.LabelViewGrid", "View grid"));
        this.jLabelGridSize.setText(I18n.getString("gui.OptionsDialog.LabelGridSize", "Grid size"));
        this.jLabelViewBorderForTextElements.setText(I18n.getString("gui.OptionsDialog.LabelViewBorderForTextElements", "View border for text elements"));
        this.jLabelTextBorderColor.setText(I18n.getString("gui.OptionsDialog.LabelTextBorderColor", "Text border color"));
        this.jLabelLookAndFeel.setText(I18n.getString("gui.OptionsDialog.LabelLookAndFeel", "Look & Feel"));
        this.jLabelLanguage.setText(I18n.getString("gui.OptionsDialog.LabelLanguage", "Language"));
        this.jLabelAutoRegisterFields.setText(I18n.getString("gui.OptionsDialog.LabelAutoRegisterFields", "Auto register SQL fields"));
        this.jLabelTemplateForNewDocs.setText(I18n.getString("gui.OptionsDialog.LabelTemplateForNewDocs", "Use this file as template for new documents"));
        this.jButtonTemplate.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonOK.setText(I18n.getString("gui.OptionsDialog.ButtonSave", "Save"));
        this.jButtonApply.setText(I18n.getString("gui.OptionsDialog.ButtonApply", "Apply"));
        this.jButtonCancel.setText(I18n.getString("gui.OptionsDialog.ButtonCancel", "Cancel"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("gui.OptionsDialog.TabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("gui.OptionsDialog.TabCompiler", "Compiler"));
        ((TitledBorder)this.jPanelCompileDir.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.DefaultCompileDir", "Default compilation directory"));
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setText(I18n.getString("gui.OptionsDialog.UseCurrentFilesDirectoryForCompiles", "Use the reports directory for compiles"));
        this.jCheckBoxAutosave.setText(I18n.getString("gui.OptionsDialog.Autosave", "Autosave before compiling"));
        this.jButtonCompilationDir.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jTabbedPane1.setTitleAt(2, I18n.getString("gui.OptionsDialog.TabBackup", "Backup"));
        this.jTabbedPane1.setTitleAt(3, I18n.getString("gui.OptionsDialog.TabExternalPrograms", "External programs"));
        ((TitledBorder)this.jPanel6.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.BackupFilesOnSave", "Backup files on save"));
        this.jRadioButton1_NoBackup.setText(I18n.getString("gui.OptionsDialog.NoBackup", "No backup"));
        this.jRadioButton2_ReplaceExtension.setText(I18n.getString("gui.OptionsDialog.ReplaceExtension", "Replace extension with .bak"));
        this.jRadioButton3_AppendExtension.setText(I18n.getString("gui.OptionsDialog.AppendExtension", "Append .bak to existing extension"));
        this.jLabelDefaultBackupDir.setText(I18n.getString("gui.OptionsDialog.LabelDefaultBackupDir", "Default backup directory"));
        this.jButtonBackupDirectory.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor1.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor2.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor3.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor4.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        ((TitledBorder)this.jPanelExternalEditor.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.ExternalEditor", "External editor"));
        ((TitledBorder)this.jPanelViewers.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.Viewers", "Viewers"));
        this.jLabelPDFViewer.setText(I18n.getString("gui.OptionsDialog.PDFViewer", "PDF Viewer"));
        this.jLabelCSVViewer.setText(I18n.getString("gui.OptionsDialog.CSVViewer", "CSV Viewer"));
        this.jLabelHTMLViewer.setText(I18n.getString("gui.OptionsDialog.HTMLViewer", "HTML Viewer"));
        this.jLabelXLSViewer.setText(I18n.getString("gui.OptionsDialog.XLSViewer", "XLS Viewer"));
        this.setTitle("iReport - " + I18n.getString("gui.OptionsDialog.title", "Options"));
        this.getRootPane().updateUI();
    }

    public void loadConfiguration() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        try {
            this.jNumberFieldRecentFilesListLenght.setValue(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("RecentFilesLength"), "10")));
            this.jNumberFieldGridSize.setValue(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("GridSize"), "10")));
            this.jTextFieldBackupDirectory.setText(Misc.nvl(this.mf.getProperties().getProperty("DefaultBackupDirectory"), ""));
            this.jTextFieldCSVViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalCSVViewer"), ""));
            this.jTextFieldPDFViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalPDFViewer"), ""));
            this.jTextFieldXLSViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalXLSViewer"), ""));
            this.jTextFieldHTMLViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalHTMLViewer"), ""));
            this.jTextFieldEditor.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalEditor"), ""));
            this.jCheckBoxViewRules.setSelected(Misc.nvl(this.mf.getProperties().getProperty("ViewRules"), "true").equals("true"));
            this.jCheckBoxViewGrid.setSelected(Misc.nvl(this.mf.getProperties().getProperty("ViewGrid"), "false").equals("true"));
            this.jCheckBoxViewBorderText.setSelected(Misc.nvl(this.mf.getProperties().getProperty("ViewBorderForTextElements"), "true").equals("true"));
            this.jTextFieldCompilationDir.setText(this.mf.getDefaultCompilationDirectory());
            this.jRadioButton1_NoBackup.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("1"));
            this.jRadioButton2_ReplaceExtension.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("2"));
            this.jRadioButton3_AppendExtension.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("3"));
            this.jButtonBorderTextColor.setBackground(new Color(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("ViewBorderColor"), "1"))));
            this.jTextFieldTemplate.setText(Misc.nvl(this.mf.getProperties().getProperty("DefaultTemplate"), ""));
            this.jCheckBoxAutosave.setSelected(Misc.nvl(this.mf.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"));
            this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setSelected(this.mf.isUsingCurrentFilesDirectoryForCompiles());
            if (this.mf.isUsingCurrentFilesDirectoryForCompiles()) {
                this.disableCompileDirectoryBrowse();
            }
            for (int i = 0; i < this.jComboBoxDefaultRulesUnit.getItemCount(); ++i) {
                if (!(this.jComboBoxDefaultRulesUnit.getItemAt(i) + "").equals(Misc.nvl(this.mf.getProperties().getProperty("DefaultUnit"), "cm"))) continue;
                this.jComboBoxDefaultRulesUnit.setSelectedIndex(i);
                break;
            }
            this.jCheckBoxAutoRegisterFields.setSelected(Misc.nvl(this.mf.getProperties().getProperty("UseAutoRegiesterFields"), "true").equals("true"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.disableApplyAndOk();
        this.pack();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelGeneral = new JPanel();
        this.jPanel8 = new JPanel();
        this.jNumberFieldRecentFilesListLenght = new JNumberField();
        this.jLabelRecentFileListLength = new JLabel();
        this.jCheckBoxViewRules = new JCheckBox();
        this.jCheckBoxViewGrid = new JCheckBox();
        this.jNumberFieldGridSize = new JNumberField();
        this.jLabelGridSize = new JLabel();
        this.jLabelDefaultUnit = new JLabel();
        this.jComboBoxDefaultRulesUnit = new JComboBox();
        this.jCheckBoxViewBorderText = new JCheckBox();
        this.jLabelTextBorderColor = new JLabel();
        this.jButtonBorderTextColor = new JButton();
        this.jLabelLookAndFeel = new JLabel();
        this.jLabelLanguage = new JLabel();
        this.jComboBoxLookAndFeel = new JComboBox();
        this.jComboBoxLanguage = new JComboBox();
        this.jLabelViewBorderForTextElements = new JLabel();
        this.jLabelViewRules = new JLabel();
        this.jLabelViewGrid = new JLabel();
        this.jCheckBoxAutoRegisterFields = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabelAutoRegisterFields = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabelTemplateForNewDocs = new JLabel();
        this.jTextFieldTemplate = new JTextField();
        this.jButtonTemplate = new JButton();
        this.jPanelComper = new JPanel();
        this.jPanelCompileDir = new JPanel();
        this.jTextFieldCompilationDir = new JTextField();
        this.jButtonCompilationDir = new JButton();
        this.jCheckBoxAutosave = new JCheckBox();
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles = new JCheckBox();
        this.jPanelBackup = new JPanel();
        this.jPanel6 = new JPanel();
        this.jTextFieldBackupDirectory = new JTextField();
        this.jButtonBackupDirectory = new JButton();
        this.jRadioButton1_NoBackup = new JRadioButton();
        this.jRadioButton2_ReplaceExtension = new JRadioButton();
        this.jRadioButton3_AppendExtension = new JRadioButton();
        this.jLabelDefaultBackupDir = new JLabel();
        this.jPanelExternalPrograms = new JPanel();
        this.jPanelExternalEditor = new JPanel();
        this.jTextFieldEditor = new JTextField();
        this.jButtonBrowseEditor = new JButton();
        this.jPanelViewers = new JPanel();
        this.jTextFieldPDFViewer = new JTextField();
        this.jButtonBrowseEditor1 = new JButton();
        this.jTextFieldHTMLViewer = new JTextField();
        this.jButtonBrowseEditor2 = new JButton();
        this.jTextFieldXLSViewer = new JTextField();
        this.jButtonBrowseEditor3 = new JButton();
        this.jLabelPDFViewer = new JLabel();
        this.jLabelHTMLViewer = new JLabel();
        this.jLabelXLSViewer = new JLabel();
        this.jLabelCSVViewer = new JLabel();
        this.jTextFieldCSVViewer = new JTextField();
        this.jButtonBrowseEditor4 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("iReport Options");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelGeneral.setLayout(new BorderLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(new TitledBorder(new EtchedBorder(), "General", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel8.setFont(new Font("Dialog", 0, 11));
        this.jNumberFieldRecentFilesListLenght.setColumns(4);
        this.jNumberFieldRecentFilesListLenght.setHorizontalAlignment(4);
        try {
            this.jNumberFieldRecentFilesListLenght.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldRecentFilesListLenght.setValue(10.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldRecentFilesListLenght.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jNumberFieldRecentFilesListLenghtActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jNumberFieldRecentFilesListLenght, gridBagConstraints);
        this.jLabelRecentFileListLength.setHorizontalAlignment(4);
        this.jLabelRecentFileListLength.setText("Num of recent files in file menu");
        this.jLabelRecentFileListLength.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelRecentFileListLength, gridBagConstraints);
        this.jCheckBoxViewRules.setSelected(true);
        this.jCheckBoxViewRules.setHorizontalAlignment(4);
        this.jCheckBoxViewRules.setHorizontalTextPosition(4);
        this.jCheckBoxViewRules.setMargin(new Insets(2, 0, 2, 2));
        this.jCheckBoxViewRules.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jCheckBoxViewRulesItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel8.add((Component)this.jCheckBoxViewRules, gridBagConstraints);
        this.jCheckBoxViewGrid.setHorizontalAlignment(4);
        this.jCheckBoxViewGrid.setHorizontalTextPosition(4);
        this.jCheckBoxViewGrid.setMargin(new Insets(2, 0, 2, 2));
        this.jCheckBoxViewGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxViewGridActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel8.add((Component)this.jCheckBoxViewGrid, gridBagConstraints);
        this.jNumberFieldGridSize.setColumns(4);
        this.jNumberFieldGridSize.setHorizontalAlignment(4);
        try {
            this.jNumberFieldGridSize.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldGridSize.setValue(10.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldGridSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jNumberFieldGridSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jNumberFieldGridSize, gridBagConstraints);
        this.jLabelGridSize.setHorizontalAlignment(4);
        this.jLabelGridSize.setText("Grid size");
        this.jLabelGridSize.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelGridSize, gridBagConstraints);
        this.jLabelDefaultUnit.setHorizontalAlignment(4);
        this.jLabelDefaultUnit.setText("Default unit");
        this.jLabelDefaultUnit.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelDefaultUnit, gridBagConstraints);
        this.jComboBoxDefaultRulesUnit.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxDefaultRulesUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jComboBoxDefaultRulesUnitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 14);
        this.jPanel8.add((Component)this.jComboBoxDefaultRulesUnit, gridBagConstraints);
        this.jCheckBoxViewBorderText.setHorizontalAlignment(4);
        this.jCheckBoxViewBorderText.setHorizontalTextPosition(4);
        this.jCheckBoxViewBorderText.setMargin(new Insets(2, 0, 2, 2));
        this.jCheckBoxViewBorderText.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jCheckBoxViewBorderTextItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel8.add((Component)this.jCheckBoxViewBorderText, gridBagConstraints);
        this.jLabelTextBorderColor.setHorizontalAlignment(4);
        this.jLabelTextBorderColor.setText("Text border color");
        this.jLabelTextBorderColor.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelTextBorderColor, gridBagConstraints);
        this.jButtonBorderTextColor.setFont(new Font("Dialog", 0, 11));
        this.jButtonBorderTextColor.setBackground(new Color(128, 128, 128));
        this.jButtonBorderTextColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBorderTextColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel8.add((Component)this.jButtonBorderTextColor, gridBagConstraints);
        this.jLabelLookAndFeel.setHorizontalAlignment(4);
        this.jLabelLookAndFeel.setText("Look&Feel");
        this.jLabelLookAndFeel.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelLookAndFeel, gridBagConstraints);
        this.jLabelLanguage.setHorizontalAlignment(4);
        this.jLabelLanguage.setText("Language");
        this.jLabelLanguage.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelLanguage, gridBagConstraints);
        this.jComboBoxLookAndFeel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jComboBoxLookAndFeelItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 14);
        this.jPanel8.add((Component)this.jComboBoxLookAndFeel, gridBagConstraints);
        this.jComboBoxLanguage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jComboBoxLanguageItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 14);
        this.jPanel8.add((Component)this.jComboBoxLanguage, gridBagConstraints);
        this.jLabelViewBorderForTextElements.setHorizontalAlignment(4);
        this.jLabelViewBorderForTextElements.setText("View border for text elements");
        this.jLabelViewBorderForTextElements.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelViewBorderForTextElements, gridBagConstraints);
        this.jLabelViewRules.setHorizontalAlignment(4);
        this.jLabelViewRules.setText("View rules");
        this.jLabelViewRules.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelViewRules, gridBagConstraints);
        this.jLabelViewGrid.setHorizontalAlignment(4);
        this.jLabelViewGrid.setText("View grid");
        this.jLabelViewGrid.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelViewGrid, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.anchor = 18;
        this.jPanel8.add((Component)this.jCheckBoxAutoRegisterFields, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel8.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabelAutoRegisterFields.setHorizontalAlignment(4);
        this.jLabelAutoRegisterFields.setText("Auto register SQL fields");
        this.jLabelAutoRegisterFields.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jLabelAutoRegisterFields, gridBagConstraints);
        this.jPanelGeneral.add((Component)this.jPanel8, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelTemplateForNewDocs.setHorizontalAlignment(2);
        this.jLabelTemplateForNewDocs.setText("Use this file as template for new documents");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.jPanel2.add((Component)this.jLabelTemplateForNewDocs, gridBagConstraints);
        this.jTextFieldTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jTextFieldTemplateActionPerformed(evt);
            }
        });
        this.jTextFieldTemplate.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
                OptionsDialog.this.jTextFieldTemplateInputMethodTextChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 7, 3, 0);
        this.jPanel2.add((Component)this.jTextFieldTemplate, gridBagConstraints);
        this.jButtonTemplate.setText("Browse");
        this.jButtonTemplate.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 6);
        this.jPanel2.add((Component)this.jButtonTemplate, gridBagConstraints);
        this.jPanelGeneral.add((Component)this.jPanel2, "South");
        this.jTabbedPane1.addTab("General", this.jPanelGeneral);
        this.jPanelComper.setLayout(new GridBagLayout());
        this.jPanelCompileDir.setLayout(new GridBagLayout());
        this.jPanelCompileDir.setBorder(new TitledBorder(new EtchedBorder(), "Default compilation directory", 0, 0, new Font("Dialog", 0, 11)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelCompileDir.add((Component)this.jTextFieldCompilationDir, gridBagConstraints);
        this.jButtonCompilationDir.setText("Browse");
        this.jButtonCompilationDir.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonCompilationDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCompilationDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelCompileDir.add((Component)this.jButtonCompilationDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelComper.add((Component)this.jPanelCompileDir, gridBagConstraints);
        this.jCheckBoxAutosave.setText("Autosave before compiling");
        this.jCheckBoxAutosave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxAutosaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanelComper.add((Component)this.jCheckBoxAutosave, gridBagConstraints);
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setText("Use the reports directory for compiles");
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanelComper.add((Component)this.jCheckBoxUseCurrentFilesDirectoryForCompiles, gridBagConstraints);
        this.jTabbedPane1.addTab("Compiler", this.jPanelComper);
        this.jPanelBackup.setLayout(new GridBagLayout());
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(new TitledBorder(new EtchedBorder(), "Backup files on save", 0, 0, new Font("Dialog", 0, 11)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.jTextFieldBackupDirectory, gridBagConstraints);
        this.jButtonBackupDirectory.setText("Browse");
        this.jButtonBackupDirectory.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBackupDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBackupDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.jButtonBackupDirectory, gridBagConstraints);
        this.jRadioButton1_NoBackup.setText("No backup");
        this.buttonGroup1.add(this.jRadioButton1_NoBackup);
        this.jRadioButton1_NoBackup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton1_NoBackupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel6.add((Component)this.jRadioButton1_NoBackup, gridBagConstraints);
        this.jRadioButton2_ReplaceExtension.setText("Replace extension with .bak");
        this.buttonGroup1.add(this.jRadioButton2_ReplaceExtension);
        this.jRadioButton2_ReplaceExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton2_ReplaceExtensionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel6.add((Component)this.jRadioButton2_ReplaceExtension, gridBagConstraints);
        this.jRadioButton3_AppendExtension.setSelected(true);
        this.jRadioButton3_AppendExtension.setText("Append .bak to existing extension");
        this.buttonGroup1.add(this.jRadioButton3_AppendExtension);
        this.jRadioButton3_AppendExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton3_AppendExtensionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel6.add((Component)this.jRadioButton3_AppendExtension, gridBagConstraints);
        this.jLabelDefaultBackupDir.setText("Default backup directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel6.add((Component)this.jLabelDefaultBackupDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelBackup.add((Component)this.jPanel6, gridBagConstraints);
        this.jTabbedPane1.addTab("Backup", this.jPanelBackup);
        this.jPanelExternalPrograms.setLayout(new GridBagLayout());
        this.jPanelExternalEditor.setLayout(new GridBagLayout());
        this.jPanelExternalEditor.setBorder(new TitledBorder(new EtchedBorder(), "External editor", 0, 0, new Font("Dialog", 0, 11)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelExternalEditor.add((Component)this.jTextFieldEditor, gridBagConstraints);
        this.jButtonBrowseEditor.setText("Browse");
        this.jButtonBrowseEditor.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelExternalEditor.add((Component)this.jButtonBrowseEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelExternalPrograms.add((Component)this.jPanelExternalEditor, gridBagConstraints);
        this.jPanelViewers.setLayout(new GridBagLayout());
        this.jPanelViewers.setBorder(new TitledBorder(new EtchedBorder(), "Viewers", 0, 0, new Font("Dialog", 0, 11)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldPDFViewer, gridBagConstraints);
        this.jButtonBrowseEditor1.setText("Browse");
        this.jButtonBrowseEditor1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldHTMLViewer, gridBagConstraints);
        this.jButtonBrowseEditor2.setText("Browse");
        this.jButtonBrowseEditor2.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldXLSViewer, gridBagConstraints);
        this.jButtonBrowseEditor3.setText("Browse");
        this.jButtonBrowseEditor3.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor3, gridBagConstraints);
        this.jLabelPDFViewer.setText("PDF viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelPDFViewer, gridBagConstraints);
        this.jLabelHTMLViewer.setText("HTML viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelHTMLViewer, gridBagConstraints);
        this.jLabelXLSViewer.setText("XLS viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelXLSViewer, gridBagConstraints);
        this.jLabelCSVViewer.setText("CSV viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelCSVViewer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldCSVViewer, gridBagConstraints);
        this.jButtonBrowseEditor4.setText("Browse");
        this.jButtonBrowseEditor4.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 6, 3);
        this.jPanelExternalPrograms.add((Component)this.jPanelViewers, gridBagConstraints);
        this.jTabbedPane1.addTab("External programs", this.jPanelExternalPrograms);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jButtonOK.setText("Save");
        this.jButtonOK.setMnemonic('s');
        this.jButtonOK.setEnabled(false);
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setMnemonic('a');
        this.jButtonApply.setEnabled(false);
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonApply);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jComboBoxLookAndFeelItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jComboBoxLanguageItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected()) {
            this.disableCompileDirectoryBrowse();
        } else {
            this.enableCompileDirectoryBrowse();
        }
        this.enableApplyAndOk();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jButtonApply.isEnabled()) {
            this.jButtonApplyActionPerformed(evt);
        }
        if (this.mf != null) {
            this.mf.saveiReportConfiguration();
        }
        this.jButtonOK.setEnabled(false);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.applyConfiguration();
        this.jButtonApply.setEnabled(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonBrowseEditor4ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an CSV viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldCSVViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor3ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an XLS viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldXLSViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor2ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an HTML viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldHTMLViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor1ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an PDF viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldPDFViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditorActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an editor...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldEditor.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBackupDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldBackupDirectory.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonCompilationDirActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldCompilationDir.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonTemplateActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return "JasperReports XML *.xml";
            }
        });
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldTemplate.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jRadioButton3_AppendExtensionActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jRadioButton2_ReplaceExtensionActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jRadioButton1_NoBackupActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxAutosaveActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jTextFieldTemplateInputMethodTextChanged(InputMethodEvent evt) {
        this.enableApplyAndOk();
    }

    private void jTextFieldTemplateActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jButtonBorderTextColorActionPerformed(ActionEvent evt) {
        JColorChooser jcc = new JColorChooser();
        Color c = JColorChooser.showDialog(null, "Select a color...", this.jButtonBorderTextColor.getBackground());
        if (c != null) {
            this.enableApplyAndOk();
            this.jButtonBorderTextColor.setBackground(c);
            this.jButtonBorderTextColor.updateUI();
        }
    }

    private void jCheckBoxViewBorderTextItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jNumberFieldGridSizeActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxViewRulesItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jComboBoxDefaultRulesUnitActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jNumberFieldRecentFilesListLenghtActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxViewGridActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OptionsDialog((Frame)new JFrame(), true).show();
    }

    public void applyConfiguration() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            prop.put("RecentFilesLength", "" + (int)this.jNumberFieldRecentFilesListLenght.getValue());
            prop.put("GridSize", "" + (int)this.jNumberFieldGridSize.getValue());
            prop.put("DefaultBackupDirectory", "" + this.jTextFieldBackupDirectory.getText());
            prop.put("ExternalCSVViewer", "" + this.jTextFieldCSVViewer.getText());
            prop.put("ExternalPDFViewer", "" + this.jTextFieldPDFViewer.getText());
            prop.put("ExternalXLSViewer", "" + this.jTextFieldXLSViewer.getText());
            prop.put("ExternalHTMLViewer", "" + this.jTextFieldHTMLViewer.getText());
            prop.put("ExternalEditor", "" + this.jTextFieldEditor.getText());
            prop.put("ViewRules", "" + this.jCheckBoxViewRules.isSelected());
            prop.put("ViewGrid", "" + this.jCheckBoxViewGrid.isSelected());
            prop.put("ViewBorderForTextElements", "" + this.jCheckBoxViewBorderText.isSelected());
            prop.put("UseAutoRegiesterFields", "" + this.jCheckBoxAutoRegisterFields.isSelected());
            prop.put("ViewRules", "" + this.jCheckBoxViewRules.isSelected());
            prop.put("DefaultTemplate", "" + this.jTextFieldTemplate.getText());
            prop.put("SaveBeforeCompiling", "" + this.jCheckBoxAutosave.isSelected());
            prop.put("DefaultUnit", "" + this.jComboBoxDefaultRulesUnit.getSelectedItem() + "");
            prop.put("LookAndFeel", (String)this.jComboBoxLookAndFeel.getSelectedItem());
            this.mf.setUsingMultiLineExpressions(false);
            this.mf.setUsingCurrentFilesDirectoryForCompiles(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected());
            prop.put("useCurrentFilesDirectoryForCompiles", this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected() + "");
            this.mf.setDefaultCompilationDirectory(this.jTextFieldCompilationDir.getText());
            prop.put("DefaultCompilationDirectory", this.jTextFieldCompilationDir.getText());
            String policy = "3";
            if (this.jRadioButton1_NoBackup.isSelected()) {
                policy = "1";
            }
            if (this.jRadioButton2_ReplaceExtension.isSelected()) {
                policy = "2";
            }
            if (this.jRadioButton3_AppendExtension.isSelected()) {
                policy = "3";
            }
            prop.put("BackupPolicy", policy);
            prop.put("ViewBorderColor", "" + this.jButtonBorderTextColor.getBackground().getRGB());
            LocaleAdapter adapter = (LocaleAdapter)this.jComboBoxLanguage.getSelectedItem();
            Locale selectedLang = adapter.getLocale();
            prop.put("Language", selectedLang.getLanguage());
            prop.put("Country", selectedLang.getCountry());
            I18n.setCurrentLocale(selectedLang);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jButtonApply.setEnabled(false);
    }

    protected void enableCompileDirectoryBrowse() {
        this.jTextFieldCompilationDir.setEnabled(true);
        this.jButtonCompilationDir.setEnabled(true);
    }

    protected void disableCompileDirectoryBrowse() {
        this.jTextFieldCompilationDir.setEnabled(false);
        this.jButtonCompilationDir.setEnabled(false);
    }

    protected void disableApplyAndOk() {
        this.jButtonApply.setEnabled(false);
        this.jButtonOK.setEnabled(false);
    }

    protected void disableApply() {
        this.jButtonOK.setEnabled(false);
    }

    protected void enableApplyAndOk() {
        this.jButtonApply.setEnabled(true);
        this.jButtonOK.setEnabled(true);
    }

    protected void enableApply() {
        this.jButtonOK.setEnabled(true);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    class LocaleAdapter {
        Locale l;

        public LocaleAdapter(Locale locale) {
            this.l = locale;
        }

        public Locale getLocale() {
            return this.l;
        }

        public String toString() {
            if (this.l.getCountry() == null || this.l.getCountry().length() == 0) {
                return this.l.getDisplayLanguage();
            }
            return this.l.getDisplayLanguage() + " - " + this.l.getDisplayCountry();
        }
    }
}

