/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.massivecompiler;

import it.businesslogic.ireport.plugin.massivecompiler.FileEntry;
import it.businesslogic.ireport.plugin.massivecompiler.MassiveCompilerFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.JasperCompileManager;

public class CompileThread
implements Runnable {
    private MassiveCompilerFrame massiveCompilerFrame = null;
    private boolean stop = false;
    private Thread thread = null;
    private boolean compileSelectedOnly = false;

    public CompileThread(MassiveCompilerFrame mcf) {
        this.massiveCompilerFrame = mcf;
        this.thread = new Thread(this);
    }

    public void stop() {
        this.stop = true;
    }

    public void start() {
        this.thread.start();
    }

    public void run() {
        if (this.massiveCompilerFrame == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.massiveCompilerFrame.getFileTable().getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            FileEntry fe = (FileEntry)dtm.getValueAt(i, 0);
            if (this.isCompileSelectedOnly() && !this.massiveCompilerFrame.getFileTable().isRowSelected(i)) continue;
            String srcFileName = "";
            String destFileName = "";
            try {
                File old_jasper;
                srcFileName = fe.getFile().getCanonicalPath();
                if (this.massiveCompilerFrame.isSelectedChangeFileExt()) {
                    String srcFileName2 = Misc.changeFileExtension(srcFileName, "jrxml");
                    if (!fe.getFile().renameTo(new File(srcFileName2))) {
                        fe.setFile(new File(srcFileName2));
                        fe.setStatus(3);
                        fe.setMessage("impossibile rinominare " + srcFileName + " in " + Misc.changeFileExtension(srcFileName, "jrxml") + " **" + fe);
                        dtm.setValueAt(fe, i, 0);
                        dtm.setValueAt(FileEntry.decodeStatus(fe.getStatus()), i, 2);
                        this.massiveCompilerFrame.getFileTable().updateUI();
                        continue;
                    }
                    fe.setFile(new File(srcFileName2));
                    dtm.setValueAt(FileEntry.decodeStatus(fe.getStatus()), i, 2);
                    System.out.println("File rinominato a:" + fe.getFile().getCanonicalPath());
                    srcFileName = srcFileName2;
                }
                destFileName = Misc.changeFileExtension(srcFileName, "jasper");
                if (this.massiveCompilerFrame.isSelectedBackup() && (old_jasper = new File(destFileName)).exists()) {
                    old_jasper.renameTo(new File(Misc.changeFileExtension(destFileName, "jasper.bak")));
                }
                JasperCompileManager.compileReportToFile((String)srcFileName, (String)destFileName);
                fe.setStatus(2);
            }
            catch (Exception ex) {
                fe.setStatus(3);
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                fe.setMessage(sw.getBuffer().toString());
            }
            dtm.setValueAt(fe, i, 0);
            try {
                dtm.setValueAt(fe.getFile().getCanonicalPath(), i, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            dtm.setValueAt(FileEntry.decodeStatus(fe.getStatus()), i, 2);
        }
        this.massiveCompilerFrame.getFileTable().updateUI();
        this.massiveCompilerFrame.finishedCompiling();
    }

    public boolean isCompileSelectedOnly() {
        return this.compileSelectedOnly;
    }

    public void setCompileSelectedOnly(boolean compileSelectedOnly) {
        this.compileSelectedOnly = compileSelectedOnly;
    }
}

