/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public class JRBeanCollectionDataSource
implements JRRewindableDataSource {
    private Collection data = null;
    private Iterator iterator = null;
    private Object currentBean = null;

    public JRBeanCollectionDataSource(Collection beanCollection) {
        this.data = beanCollection;
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentBean = this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object value = null;
        if (this.currentBean != null) {
            try {
                value = PropertyUtils.getProperty((Object)this.currentBean, (String)jrField.getName());
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), e);
            }
        }
        return value;
    }

    public void moveFirst() throws JRException {
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }
}

