/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRMapArrayDataSource
implements JRRewindableDataSource {
    private Object[] records = null;
    private int index = -1;

    public JRMapArrayDataSource(Object[] array) {
        this.records = array;
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.records != null) {
            return this.index < this.records.length;
        }
        return false;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        Map currentRecord = (Map)this.records[this.index];
        if (currentRecord != null) {
            value = currentRecord.get(field.getName());
        }
        return value;
    }

    public void moveFirst() throws JRException {
        this.index = -1;
    }
}

