/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public abstract class JRCalculator {
    protected Map parsm = null;
    protected Map fldsm = null;
    protected Map varsm = null;
    protected JRFillVariable[] variables = null;
    protected JRFillGroup[] groups = null;
    private JRFillVariable pageNumber = null;
    private JRFillVariable columnNumber = null;

    protected JRCalculator() {
    }

    protected void init(Map parametersMap, Map fieldsMap, Map variablesMap, JRFillVariable[] vars, JRFillGroup[] grps) throws JRException {
        this.parsm = parametersMap;
        this.fldsm = fieldsMap;
        this.varsm = variablesMap;
        this.variables = vars;
        this.groups = grps;
        this.pageNumber = (JRFillVariable)variablesMap.get("PAGE_NUMBER");
        this.columnNumber = (JRFillVariable)variablesMap.get("COLUMN_NUMBER");
        this.customizedInit(parametersMap, fieldsMap, variablesMap);
    }

    protected abstract void customizedInit(Map var1, Map var2, Map var3) throws JRException;

    public JRFillVariable getPageNumber() {
        return this.pageNumber;
    }

    public JRFillVariable getColumnNumber() {
        return this.columnNumber;
    }

    public void calculateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable variable = null;
            Object expressionValue = null;
            Object newValue = null;
            int i = 0;
            while (i < this.variables.length) {
                variable = this.variables[i];
                expressionValue = this.evaluate(variable.getExpression());
                newValue = variable.getIncrementer().increment(variable, expressionValue, AbstractValueProvider.getCurrentValueProvider());
                variable.setValue(newValue);
                variable.setInitialized(false);
                ++i;
            }
        }
    }

    public void estimateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable variable = null;
            Object expressionValue = null;
            Object newValue = null;
            int i = 0;
            while (i < this.variables.length) {
                variable = this.variables[i];
                expressionValue = this.evaluateEstimated(variable.getExpression());
                newValue = variable.getIncrementer().increment(variable, expressionValue, AbstractValueProvider.getEstimatedValueProvider());
                variable.setEstimatedValue(newValue);
                variable.setInitialized(false);
                ++i;
            }
        }
    }

    public void estimateGroupRuptures() throws JRException {
        this.estimateVariables();
        JRFillGroup group = null;
        Object oldValue = null;
        Object estimatedValue = null;
        boolean groupHasChanged = false;
        boolean isTopLevelChange = false;
        if (this.groups != null && this.groups.length > 0) {
            int i = 0;
            while (i < this.groups.length) {
                group = this.groups[i];
                isTopLevelChange = false;
                if (!groupHasChanged) {
                    oldValue = this.evaluateOld(group.getExpression());
                    estimatedValue = this.evaluateEstimated(group.getExpression());
                    if (oldValue == null && estimatedValue != null || oldValue != null && !oldValue.equals(estimatedValue)) {
                        groupHasChanged = true;
                        isTopLevelChange = true;
                    }
                }
                group.setHasChanged(groupHasChanged);
                group.setTopLevelChange(isTopLevelChange);
                ++i;
            }
        }
    }

    public void initializeVariables(byte resetType) throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            int i = 0;
            while (i < this.variables.length) {
                this.initializeVariable(this.variables[i], resetType);
                ++i;
            }
        }
    }

    private void initializeVariable(JRFillVariable variable, byte resetType) throws JRException {
        if (variable.getResetType() != 5) {
            boolean toInitialize = false;
            switch (resetType) {
                case 1: {
                    toInitialize = true;
                    break;
                }
                case 2: {
                    toInitialize = variable.getResetType() == 2 || variable.getResetType() == 3;
                    break;
                }
                case 3: {
                    toInitialize = variable.getResetType() == 3;
                    break;
                }
                case 4: {
                    if (variable.getResetType() != 4) break;
                    JRFillGroup group = (JRFillGroup)variable.getResetGroup();
                    toInitialize = group.hasChanged();
                    break;
                }
            }
            if (toInitialize) {
                variable.setValue(this.evaluate(variable.getInitialValueExpression()));
                variable.setInitialized(true);
            }
        } else {
            variable.setValue(this.evaluate(variable.getExpression()));
        }
    }

    protected Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
        Object value = null;
        switch (evaluationType) {
            case 1: {
                value = this.evaluateOld(expression);
                break;
            }
            case 2: {
                value = this.evaluateEstimated(expression);
                break;
            }
            default: {
                value = this.evaluate(expression);
            }
        }
        return value;
    }

    protected Object evaluateOld(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        try {
            value = this.evaluateOld(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (Throwable e) {
            throw new JRExpressionEvalException(expression, e);
        }
        return value;
    }

    protected Object evaluateEstimated(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        try {
            value = this.evaluateEstimated(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (Throwable e) {
            throw new JRExpressionEvalException(expression, e);
        }
        return value;
    }

    protected Object evaluate(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        try {
            value = this.evaluate(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (Throwable e) {
            throw new JRExpressionEvalException(expression, e);
        }
        return value;
    }

    protected abstract Object evaluateOld(int var1) throws Throwable;

    protected abstract Object evaluateEstimated(int var1) throws Throwable;

    protected abstract Object evaluate(int var1) throws Throwable;
}

