/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRClassGenerator {
    private JasperDesign jasperDesign = null;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;

    protected JRClassGenerator(JasperDesign jrDesign) {
        this.jasperDesign = jrDesign;
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }

    public static String generateClass(JasperDesign jrDesign) throws JRException {
        JRClassGenerator generator = new JRClassGenerator(jrDesign);
        return generator.generateClass();
    }

    protected String generateClass() throws JRException {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("/*\n");
        sb.append(" * Generated by JasperReports - ");
        sb.append(new SimpleDateFormat().format(new Date()));
        sb.append("\n");
        sb.append(" */\n");
        sb.append("import net.sf.jasperreports.engine.*;\n");
        sb.append("import net.sf.jasperreports.engine.fill.*;\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.text.*;\n");
        sb.append("import java.io.*;\n");
        sb.append("import java.net.*;\n");
        sb.append("\n");
        String[] imports = this.jasperDesign.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                sb.append("import ");
                sb.append(imports[i]);
                sb.append(";\n");
            }
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("/**\n");
        sb.append(" *\n");
        sb.append(" */\n");
        sb.append("public class ");
        sb.append(this.jasperDesign.getName());
        sb.append(" extends JRCalculator\n");
        sb.append("{\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        Map parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            Iterator it2 = parameterNames.iterator();
            while (it2.hasNext()) {
                sb.append("    private JRFillParameter parameter_");
                sb.append(it2.next());
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            Iterator it3 = fieldNames.iterator();
            while (it3.hasNext()) {
                sb.append("    private JRFillField field_");
                sb.append(it3.next());
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                sb.append("    private JRFillVariable variable_");
                sb.append(variables[i].getName());
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    public void customizedInit(\n");
        sb.append("        Map pm,\n");
        sb.append("        Map fm,\n");
        sb.append("        Map vm\n");
        sb.append("        ) throws JRException\n");
        sb.append("    {\n");
        parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            String parameterName = null;
            it = parameterNames.iterator();
            while (it.hasNext()) {
                parameterName = (String)it.next();
                sb.append("        parameter_");
                sb.append(parameterName);
                sb.append(" = (JRFillParameter)parsm.get(\"");
                sb.append(parameterName);
                sb.append("\");\n");
            }
        }
        sb.append("\n");
        fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            String fieldName = null;
            it = fieldNames.iterator();
            while (it.hasNext()) {
                fieldName = (String)it.next();
                sb.append("        field_");
                sb.append(fieldName);
                sb.append(" = (JRFillField)fldsm.get(\"");
                sb.append(fieldName);
                sb.append("\");\n");
            }
        }
        sb.append("\n");
        variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            String variableName = null;
            for (int i = 0; i < variables.length; ++i) {
                variableName = variables[i].getName();
                sb.append("        variable_");
                sb.append(variableName);
                sb.append(" = (JRFillVariable)varsm.get(\"");
                sb.append(variableName);
                sb.append("\");\n");
            }
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(this.generateMethod((byte)3));
        sb.append(this.generateMethod((byte)1));
        sb.append(this.generateMethod((byte)2));
        sb.append("}\n");
        return sb.toString();
    }

    private String generateMethod(byte evaluationType) throws JRException {
        StringBuffer sb = new StringBuffer();
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    public Object evaluate");
        sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
        sb.append("(int id) throws Throwable\n");
        sb.append("    {\n");
        sb.append("        Object value = null;\n");
        sb.append("\n");
        sb.append("        switch (id)\n");
        sb.append("        {\n");
        Collection expressions = this.jasperDesign.getExpressions();
        if (expressions != null && expressions.size() > 0) {
            JRExpression expression = null;
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                expression = (JRExpression)it.next();
                sb.append("            case ");
                sb.append(expression.getId());
                sb.append(" : // ");
                sb.append(expression.getName());
                sb.append("\n");
                sb.append("            {\n");
                sb.append("                value = (");
                sb.append(expression.getValueClassName());
                sb.append(")(");
                sb.append(this.generateExpression(expression, evaluationType));
                sb.append(");\n");
                sb.append("                break;\n");
                sb.append("            }\n");
            }
        }
        sb.append("           default :\n");
        sb.append("           {\n");
        sb.append("           }\n");
        sb.append("        }\n");
        sb.append("        \n");
        sb.append("        return value;\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private String generateExpression(JRExpression expression, byte evaluationType) throws JRException {
        Map parametersMap = this.jasperDesign.getParametersMap();
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        Map variablesMap = this.jasperDesign.getVariablesMap();
        JRParameter jrParameter = null;
        JRField jrField = null;
        JRVariable jrVariable = null;
        StringBuffer sb = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            block7: for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sb.append(chunkText);
                        continue block7;
                    }
                    case 2: {
                        jrParameter = (JRParameter)parametersMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrParameter.getValueClassName());
                        sb.append(")parameter_");
                        sb.append(chunkText);
                        sb.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jrField = (JRField)fieldsMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrField.getValueClassName());
                        sb.append(")field_");
                        sb.append(chunkText);
                        sb.append(".get");
                        sb.append((String)fieldPrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jrVariable = (JRVariable)variablesMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrVariable.getValueClassName());
                        sb.append(")variable_");
                        sb.append(chunkText);
                        sb.append(".get");
                        sb.append((String)variablePrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        sb.append("str(\"");
                        sb.append(chunkText);
                        sb.append("\")");
                    }
                }
            }
        }
        if (sb.length() == 0) {
            sb.append("null");
        }
        return sb.toString();
    }
}

