/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import net.sf.jasperreports.engine.fill.JRYComparator;

public class JRFillBand
extends JRFillElementGroup
implements JRBand {
    private JRBand parent = null;
    protected JRBaseFiller filler = null;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    private boolean isOverflow = false;
    private boolean isPrintWhenTrue = true;
    private int stretchHeight = 0;
    private int firstY = 0;
    private boolean isFirstYFound = false;
    private boolean isNewPageColumn = false;
    private Map isNewGroupMap = new HashMap();

    protected JRFillBand(JRBaseFiller filler, JRBand band, JRFillObjectFactory factory) {
        super(band, factory);
        this.parent = band;
        this.filler = filler;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> sortedElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setBand(this);
                this.elements[i].setBandBottomY(this.getHeight() - this.elements[i].getY() - this.elements[i].getHeight());
                sortedElemsList.add(this.elements[i]);
                if (this.elements[i].getPositionType() == 3) {
                    bandBottomElemsList.add(this.elements[i]);
                }
                if (this.elements[i].getStretchType() != 0) {
                    stretchElemsList.add(this.elements[i]);
                }
                if (!this.elements[i].isRemoveLineWhenBlank()) continue;
                removableElemsList.add(this.elements[i]);
            }
            Collections.sort(sortedElemsList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            sortedElemsList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            JRFillElement iElem = null;
            JRFillElement jElem = null;
            int left = 0;
            int right = 0;
            for (int i = 0; i < this.ySortedElements.length - 1; ++i) {
                iElem = this.ySortedElements[i];
                for (int j = i + 1; j < this.ySortedElements.length; ++j) {
                    jElem = this.ySortedElements[j];
                    left = Math.min(iElem.getX(), jElem.getX());
                    right = Math.max(iElem.getX() + iElem.getWidth(), jElem.getX() + jElem.getWidth());
                    if (jElem.getPositionType() != 1 || iElem.getY() + iElem.getHeight() > jElem.getY() || iElem.getWidth() + jElem.getWidth() <= right - left) continue;
                    iElem.addDependantElement(jElem);
                }
            }
        }
    }

    protected void setNewPageColumn(boolean isNew) {
        this.isNewPageColumn = isNew;
    }

    protected boolean isNewPageColumn() {
        return this.isNewPageColumn;
    }

    protected void setNewGroup(JRGroup group, boolean isNew) {
        this.isNewGroupMap.put(group, isNew ? Boolean.TRUE : Boolean.FALSE);
    }

    protected boolean isNewGroup(JRGroup group) {
        Boolean value = (Boolean)this.isNewGroupMap.get(group);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public int getHeight() {
        return this.parent != null ? this.parent.getHeight() : 0;
    }

    public boolean isSplitAllowed() {
        return this.parent.isSplitAllowed();
    }

    public void setSplitAllowed(boolean isSplitAllowed) {
    }

    public JRExpression getPrintWhenExpression() {
        return this.parent != null ? this.parent.getPrintWhenExpression() : null;
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.getPrintWhenExpression() == null;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue();
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRElement[] elements = this.getElements();
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                ((JRFillElement)elements[i]).evaluate(evaluation);
            }
        }
    }

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isPrintTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            Boolean printWhenExpressionValue = (Boolean)this.filler.calculator.evaluate(expression, evaluation);
            isPrintTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenTrue(isPrintTrue);
    }

    protected JRPrintBand refill(int availableStretchHeight) throws JRException {
        this.rewind();
        return this.fill(availableStretchHeight);
    }

    protected JRPrintBand fill() throws JRException {
        return this.fill(0, false);
    }

    protected JRPrintBand fill(int availableStretchHeight) throws JRException {
        return this.fill(availableStretchHeight, true);
    }

    protected JRPrintBand fill(int availableStretchHeight, boolean isOverflowAllowed) throws JRException {
        if (Thread.currentThread().isInterrupted() || this.filler.isInterrupted()) {
            this.filler.setInterrupted(true);
            throw new JRFillInterruptedException();
        }
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.isFirstYFound = false;
        this.resetElements();
        this.prepareElements(availableStretchHeight, isOverflowAllowed);
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        this.isNewPageColumn = false;
        this.isNewGroupMap = new HashMap();
        return this.fillElements();
    }

    protected void rewind() throws JRException {
        JRFillElement[] elements = this.ySortedElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            for (int i = 0; i < elements.length; ++i) {
                element = elements[i];
                element.rewind();
                element.setAlreadyPrinted(false);
            }
        }
        this.willOverflow = false;
    }

    private void resetElements() throws JRException {
        JRFillElement[] elements = this.ySortedElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            for (int i = 0; i < elements.length; ++i) {
                element = elements[i];
                element.reset();
                if (this.isOverflow) continue;
                element.setAlreadyPrinted(false);
            }
        }
    }

    private void prepareElements(int availableStretchHeight, boolean isOverflowAllowed) throws JRException {
        boolean willOverflow = false;
        int maxBandStretch = 0;
        int bandStretch = 0;
        this.firstY = this.isOverflow ? this.getHeight() : 0;
        JRFillElement[] elements = this.ySortedElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            for (int i = 0; i < elements.length; ++i) {
                element = elements[i];
                willOverflow = element.prepare(availableStretchHeight, this.isOverflow) || willOverflow;
                element.moveDependantElements();
                if (!element.isToPrint()) continue;
                if (this.isOverflow) {
                    if (element.isReprinted()) {
                        this.firstY = 0;
                    } else if (!this.isFirstYFound) {
                        this.firstY = element.getY();
                    }
                    this.isFirstYFound = true;
                }
                if ((bandStretch = element.getRelativeY() + element.getStretchHeight() - this.getHeight() + element.getBandBottomY()) <= maxBandStretch) continue;
                maxBandStretch = bandStretch;
            }
        }
        if (maxBandStretch > availableStretchHeight) {
            // empty if block
        }
        this.stretchHeight = willOverflow ? this.getHeight() + availableStretchHeight : this.getHeight() + maxBandStretch;
        this.willOverflow = willOverflow && isOverflowAllowed;
    }

    private void stretchElements() throws JRException {
        JRFillElement[] elements = this.stretchElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            for (int i = 0; i < elements.length; ++i) {
                element = elements[i];
                element.stretchElement(this.stretchHeight - this.getHeight());
                element.moveDependantElements();
            }
        }
    }

    private void moveBandBottomElements() throws JRException {
        JRFillElement[] elements = this.bandBottomElements;
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            for (int i = 0; i < elements.length; ++i) {
                element = elements[i];
                element.setRelativeY(element.getY() + this.stretchHeight - this.getHeight());
                element.setToPrint(element.isToPrint() && !this.willOverflow);
            }
        }
    }

    private void removeBlankElements() throws JRException {
        JRFillElement[] remElems = this.removableElements;
        if (remElems != null && remElems.length > 0) {
            JRFillElement[] elems = this.ySortedElements;
            JRFillElement iElem = null;
            JRFillElement jElem = null;
            int top = 0;
            int bottom = 0;
            boolean isToRemove = true;
            for (int i = 0; i < remElems.length; ++i) {
                int j;
                iElem = remElems[i];
                if (iElem.isToPrint() || iElem.getRelativeY() + iElem.getStretchHeight() > this.stretchHeight || iElem.getRelativeY() < this.firstY) continue;
                isToRemove = true;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (iElem == jElem || !jElem.isToPrint()) continue;
                    top = Math.min(iElem.getRelativeY(), jElem.getRelativeY());
                    bottom = Math.max(iElem.getRelativeY() + iElem.getHeight(), jElem.getRelativeY() + jElem.getStretchHeight());
                    if (iElem.getHeight() + jElem.getStretchHeight() <= bottom - top) continue;
                    isToRemove = false;
                    break;
                }
                if (!isToRemove) continue;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (jElem.getRelativeY() < iElem.getRelativeY() + iElem.getHeight()) continue;
                    jElem.setRelativeY(jElem.getRelativeY() - iElem.getHeight());
                }
                this.stretchHeight -= iElem.getHeight();
            }
        }
    }

    private JRPrintBand fillElements() throws JRException {
        JRPrintBand printBand = new JRPrintBand();
        JRElement[] elements = this.getElements();
        if (elements != null && elements.length > 0) {
            JRFillElement element = null;
            JRPrintElement printElement = null;
            for (int i = 0; i < elements.length; ++i) {
                Collection printElements;
                element = (JRFillElement)elements[i];
                element.setRelativeY(element.getRelativeY() - this.firstY);
                if (element.getRelativeY() + element.getStretchHeight() > this.stretchHeight) {
                    element.setToPrint(false);
                }
                element.setAlreadyPrinted(element.isToPrint() || element.isAlreadyPrinted());
                if (!element.isToPrint() || (printElement = element.fill()) == null) continue;
                printBand.addElement(printElement);
                if (!(element instanceof JRFillSubreport)) continue;
                JRFillSubreport subreport = (JRFillSubreport)element;
                JRReportFont[] fonts = subreport.getFonts();
                if (fonts != null) {
                    for (int j = 0; j < fonts.length; ++j) {
                        try {
                            this.filler.getJasperPrint().addFont(fonts[j]);
                            continue;
                        }
                        catch (JRException e) {
                            // empty catch block
                        }
                    }
                }
                if ((printElements = subreport.getPrintElements()) == null || printElements.size() <= 0) continue;
                Iterator it = printElements.iterator();
                while (it.hasNext()) {
                    printElement = (JRPrintElement)it.next();
                    printElement.setX(element.getX() + printElement.getX());
                    printElement.setY(element.getRelativeY() + printElement.getY());
                    printBand.addElement(printElement);
                }
            }
        }
        printBand.setHeight(this.stretchHeight - this.firstY);
        return printBand;
    }
}

